module Schleuder
  class ResendPlugin < Plugin
    def initialize
      @plugin_type = :list
    end

    def resend(mail, value)
      store_address(mail, value, false)
    end

    def resend_encrypted_only(mail, value)
      store_address(mail, value, true)
    end

    def store_address(mail, value, encrypted_only)
      if mail.to.to_a.include? Schleuder.list.request_addr
        msg = "The resend-command may only be used in message sent over the list, not messages sent to the request-address."
        Schleuder.log.warn msg
        return msg.fmt
      end
      if Utils.emailaddress? value
        m = Member.new({'email' => value})
        if encrypted_only
          m.encrypted_only = true
        end
        mail.resend_to << m
      else
        Schleuder.log.warn "Skipping invalid email address given with resend-keyword: #{value}"
        mail.metadata[:error] << "Invalid address given: '#{value}'."
      end
      mail
    end

  end
end
