module Schleuder
  class ListLogger < Log4r::Logger
    # Instantiates the list-logger and sets outputters and level.
    # Warning: Do *not* rely on the list-object here!  It's not yet available
    # (this actually is part of setting it up) and you'd produce loops and
    # break the whole thing.
    def initialize(listname, listdir, config)
      # Initialize self
      super('list')

      # define the initial log_level for all outputters (they inherit it)
      @level = eval("Log4r::#{config.log_level.upcase}")

      # Setting up outputters.
      fmtr = Log4r::PatternFormatter.new(:pattern => "%d #{listname} %l\t%M")

      if config.log_file
        require 'log4r/outputter/fileoutputter'
        filename = config.log_file
        filename = File.join(listdir, filename) unless filename[0..0].eql?('/')
        add Log4r::FileOutputter.new("file",
                                       { :level => @level,
                                         :filename => filename,
                                         :formatter => fmtr }
                                     )
      end

      if config.log_syslog
        require 'log4r/outputter/syslogoutputter'
        syslogfmtr = Log4r::PatternFormatter.new(:pattern => "#{listname}\t%M")
        add Log4r::SyslogOutputter.new("syslog",
                                         { :level => @level,
                                           :ident => 'Schleuder',
                                           :facility => "LOG_MAIL",
                                           :formatter => syslogfmtr }
                                      )
      end

      if config.log_io
        require 'log4r/outputter/iooutputter'
        require 'stringio'
        io = IO.popen(config.log_io, 'w')
        add Log4r::IOOutputter.new("io", io, :level => @level)
      end

      # Add this as last outputter, else you'll see logging-statements from
      # sending the email before the original error is logged — that's a little
      # confusing.
      add EmailOutputter.new("email", :formatter => fmtr)
    end

    def notify_admin(*args)
      Log4r::Outputter['email'].notify_admin *args
    end
  end
end
