#!/usr/bin/env ruby

# defaults
port = 25
output = "/tmp"

def usage
  file = File.basename(__FILE__)
  puts "Usage: #{file} [-p portnum]  { .../output_base_dir/ | .../bin/schleuder listname }"
  exit 1
end

# get args
if (not ARGV.empty?) and (ARGV.first[0..0] == '-')
  arg = ARGV.shift
  if arg == '-p'
    port = ARGV.shift.to_i 
    usage if port == 0 # nil or not convertable strings convert to 0
  else
    usage
  end
end

output = ARGV.join(" ") || output


# run the server
require 'socket'
server = TCPServer.new("localhost", port)

def p msg
  #puts "o:" + msg
  @s.print msg + "\r\n"
end

# receive input
while (@s = server.accept)
  input = ''
  #p "200 OK"
  p "220 localhost SMTP"
  #p "Wazzup?"
  begin
    while i = @s.gets.chomp
      #puts "i:" + i
      case i[0..3].downcase
      when 'ehlo', 'helo'
        p "250 localhost"
      when 'mail', 'rcpt', 'rset', '.'
        p "250 ok"
      when 'data'
        p "354 go ahead"
      when 'quit'
        p "221 localhost" 
        @s.close
      else
        input << i + "\n"
      end
    end
  rescue IOError
  end
  # write input to #{output}
  if File.directory? output
    file = output + "/schleuder-#{$$}-#{Time.now.to_f}"
    File.open(file, 'w') do |f|
      f.puts input
    end
    File.chown 1000, 10, file
    puts file
  else
    IO.popen(output, 'w') do |p|
      p.puts input
    end
  end
end


