/*
 * scamper_target.h
 *
 * $Id: scamper_target.h,v 1.7 2009/07/14 00:04:27 mjl Exp $
 *
 * Copyright (C) 2005-2008 The University of Waikato
 * Author: Matthew Luckie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __SCAMPER_TARGET_H
#define __SCAMPER_TARGET_H

typedef struct scamper_targetset scamper_targetset_t;

/*
 * scamper_targetset_alloc,free:
 *
 * routines to allocate a targetset given a task, and then to free the
 * targetset when finished.
 */
scamper_targetset_t *scamper_targetset_alloc(scamper_task_t *task);
void scamper_targetset_free(scamper_targetset_t *targetset);

/*
 * scamper_target_find:
 *
 * given an address, find the task associated with it
 */
scamper_task_t *scamper_target_find(scamper_addr_t *addr);

/*
 * scamper_target_detach,attach:
 *
 * routines to detach an address from being associated with a task, and
 * then to add it back.
 */
int scamper_target_detach(scamper_task_t *task, scamper_addr_t *addr);
int scamper_target_attach(scamper_task_t *task, scamper_addr_t *addr);

/*
 * scamper_targets_init,cleanup:
 *
 * routines to initialise/cleanup a set of structures for managing tasks
 * probing different addresses.
 */
int scamper_targets_init(void);
void scamper_targets_cleanup(void);

#endif /* __SCAMPER_TARGET_H */
