/*
 * Decompiled with CFR 0.152.
 */
package scala.dbc.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.dbc.DataType$;
import scala.dbc.Value;
import scala.dbc.value.ApproximateNumeric;
import scala.dbc.value.Boolean;
import scala.dbc.value.Character;
import scala.dbc.value.CharacterLargeObject;
import scala.dbc.value.CharacterVarying;
import scala.dbc.value.Conversion;
import scala.dbc.value.ExactNumeric;
import scala.runtime.BoxesUtility;

public final class Conversion$
implements ScalaObject {
    public static final Conversion$ MODULE$;

    static {
        Conversion$ conversion$ = new Conversion$();
    }

    public Conversion$() {
        MODULE$ = this;
    }

    public String view10(Value value) {
        String string;
        Value value2 = value;
        if (!(value2 instanceof Character)) {
            if (!(value2 instanceof CharacterLargeObject)) {
                if (!(value2 instanceof CharacterVarying)) {
                    throw new Conversion.Illegal("Cannot convert value to string");
                }
                string = (String)((CharacterVarying)value2).nativeValue();
            } else {
                string = (String)((CharacterLargeObject)value2).nativeValue();
            }
        } else {
            string = (String)((Character)value2).nativeValue();
        }
        return string;
    }

    public boolean view9(Value value) {
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BOOLEAN()) {
            throw new Conversion.Illegal("Cannot convert value to boolean: " + value);
        }
        Boolean v = (Boolean)value;
        return BoxesUtility.unboxToBoolean(v.nativeValue());
    }

    public double view8(Value value) {
        double d;
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.FLOAT()) {
            if (value.dataType().nativeTypeId() != DataType$.MODULE$.DOUBLE()) {
                throw new Conversion.Illegal("Cannot convert value to double: " + value);
            }
            ApproximateNumeric v = (ApproximateNumeric)value;
            d = BoxesUtility.unboxToDouble(v.nativeValue());
        } else {
            ApproximateNumeric v = (ApproximateNumeric)value;
            d = Predef$.MODULE$.float2double(BoxesUtility.unboxToFloat(v.nativeValue()));
        }
        return d;
    }

    public float view7(Value value) {
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.FLOAT()) {
            throw new Conversion.Illegal("Cannot convert value to float: " + value);
        }
        ApproximateNumeric v = (ApproximateNumeric)value;
        return BoxesUtility.unboxToFloat(v.nativeValue());
    }

    public BigDecimal view6(Value value) {
        BigDecimal bigDecimal;
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BYTE()) {
            if (value.dataType().nativeTypeId() != DataType$.MODULE$.SHORT()) {
                if (value.dataType().nativeTypeId() != DataType$.MODULE$.INT()) {
                    if (value.dataType().nativeTypeId() != DataType$.MODULE$.LONG()) {
                        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BIG_INTEGER()) {
                            if (value.dataType().nativeTypeId() != DataType$.MODULE$.BIG_DECIMAL()) {
                                throw new Conversion.Illegal("Cannot convert value to big decimal: " + value);
                            }
                            ExactNumeric v = (ExactNumeric)value;
                            bigDecimal = (BigDecimal)v.nativeValue();
                        } else {
                            ExactNumeric v = (ExactNumeric)value;
                            bigDecimal = new BigDecimal((BigInteger)v.nativeValue());
                        }
                    } else {
                        ExactNumeric v = (ExactNumeric)value;
                        bigDecimal = new BigDecimal(v.nativeValue().toString());
                    }
                } else {
                    ExactNumeric v = (ExactNumeric)value;
                    bigDecimal = new BigDecimal(v.nativeValue().toString());
                }
            } else {
                ExactNumeric v = (ExactNumeric)value;
                bigDecimal = new BigDecimal(v.nativeValue().toString());
            }
        } else {
            ExactNumeric v = (ExactNumeric)value;
            bigDecimal = new BigDecimal(v.nativeValue().toString());
        }
        return bigDecimal;
    }

    public BigInteger view5(Value value) {
        BigInteger bigInteger;
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BYTE()) {
            if (value.dataType().nativeTypeId() != DataType$.MODULE$.SHORT()) {
                if (value.dataType().nativeTypeId() != DataType$.MODULE$.INT()) {
                    if (value.dataType().nativeTypeId() != DataType$.MODULE$.LONG()) {
                        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BIG_INTEGER()) {
                            throw new Conversion.Illegal("Cannot convert value to big integer: " + value);
                        }
                        ExactNumeric v = (ExactNumeric)value;
                        bigInteger = (BigInteger)v.nativeValue();
                    } else {
                        ExactNumeric v = (ExactNumeric)value;
                        bigInteger = new BigInteger(v.nativeValue().toString(), 10);
                    }
                } else {
                    ExactNumeric v = (ExactNumeric)value;
                    bigInteger = new BigInteger(v.nativeValue().toString(), 10);
                }
            } else {
                ExactNumeric v = (ExactNumeric)value;
                bigInteger = new BigInteger(v.nativeValue().toString(), 10);
            }
        } else {
            ExactNumeric v = (ExactNumeric)value;
            bigInteger = new BigInteger(v.nativeValue().toString(), 10);
        }
        return bigInteger;
    }

    public long view4(Value value) {
        long l;
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BYTE()) {
            if (value.dataType().nativeTypeId() != DataType$.MODULE$.SHORT()) {
                if (value.dataType().nativeTypeId() != DataType$.MODULE$.INT()) {
                    if (value.dataType().nativeTypeId() != DataType$.MODULE$.LONG()) {
                        throw new Conversion.Illegal("Cannot convert value to long: " + value);
                    }
                    ExactNumeric v = (ExactNumeric)value;
                    l = BoxesUtility.unboxToLong(v.nativeValue());
                } else {
                    ExactNumeric v = (ExactNumeric)value;
                    l = BoxesUtility.unboxToInt(v.nativeValue());
                }
            } else {
                ExactNumeric v = (ExactNumeric)value;
                l = BoxesUtility.unboxToShort(v.nativeValue());
            }
        } else {
            ExactNumeric v = (ExactNumeric)value;
            l = BoxesUtility.unboxToByte(v.nativeValue());
        }
        return l;
    }

    public int view3(Value value) {
        short s;
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BYTE()) {
            if (value.dataType().nativeTypeId() != DataType$.MODULE$.SHORT()) {
                if (value.dataType().nativeTypeId() != DataType$.MODULE$.INT()) {
                    throw new Conversion.Illegal("Cannot convert value to int: " + value);
                }
                ExactNumeric v = (ExactNumeric)value;
                s = (short)BoxesUtility.unboxToInt(v.nativeValue());
            } else {
                ExactNumeric v = (ExactNumeric)value;
                s = BoxesUtility.unboxToShort(v.nativeValue());
            }
        } else {
            ExactNumeric v = (ExactNumeric)value;
            s = BoxesUtility.unboxToByte(v.nativeValue());
        }
        return s;
    }

    public short view2(Value value) {
        short s;
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BYTE()) {
            if (value.dataType().nativeTypeId() != DataType$.MODULE$.SHORT()) {
                throw new Conversion.Illegal("Cannot convert value to short: " + value);
            }
            ExactNumeric v = (ExactNumeric)value;
            s = BoxesUtility.unboxToShort(v.nativeValue());
        } else {
            ExactNumeric v = (ExactNumeric)value;
            s = BoxesUtility.unboxToByte(v.nativeValue());
        }
        return s;
    }

    public byte view1(Value value) {
        if (value.dataType().nativeTypeId() != DataType$.MODULE$.BYTE()) {
            throw new Conversion.Illegal("Cannot convert value to byte: " + value);
        }
        ExactNumeric v = (ExactNumeric)value;
        return BoxesUtility.unboxToByte(v.nativeValue());
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

