/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.io.RandomDataCollectorTimeStamped;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.computing.Trace2DArithmeticMean;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.swing.JFrame;

public final class DynamicChartWithArithmeticMeanTrace {
    public static void main(String[] args) {
        Chart2D chart = new Chart2D();
        chart.getAxisX().setFormatter(new LabelFormatterDate((SimpleDateFormat)DateFormat.getDateTimeInstance()));
        Trace2DLtd trace = new Trace2DLtd(600);
        trace.setColor(Color.RED);
        trace.setTracePainter(new TracePainterDisc(4));
        Trace2DArithmeticMean traceArithmeticMean = new Trace2DArithmeticMean(200);
        trace.addComputingTrace(traceArithmeticMean);
        chart.addTrace(trace);
        chart.addTrace(traceArithmeticMean);
        JFrame frame = new JFrame("DynamicChart with arithmetic mean");
        frame.getContentPane().add(new ChartPanel(chart));
        frame.setSize(600, 300);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
        RandomDataCollectorTimeStamped collector = new RandomDataCollectorTimeStamped((ITrace2D)trace, 100);
        collector.start();
    }

    private DynamicChartWithArithmeticMeanTrace() {
    }
}

