#! /bin/sh

# functions

testit () {
    echo "Test $1 $2 $3 $4 $5"
    xpaset -p ds9 regions format $1
    xpaset -p ds9 regions system $2
    xpaset -p ds9 regions sky $3
    xpaset -p ds9 regions skyformat $4
    xpaset -p ds9 regions file $5
    xpaset -p ds9 regions save ${5}.out
    xpaset -p ds9 regions deleteall

    o=`diff $5 ${5}.out`
    if [ "$o" = "" ]
    then
	echo "PASSED"
    else
        echo "FAILED"
	echo "$o"
    fi
    rm -f ${5}.out
}

testit2 () {
    echo "Test $1 $2 $3 $4 $5 $6"
    xpaset -p ds9 regions format $1
    xpaset -p ds9 regions system $2
    xpaset -p ds9 regions sky $3
    xpaset -p ds9 regions skyformat $4
    xpaset -p ds9 regions file $5
    xpaset -p ds9 regions save ${5}.out
    xpaset -p ds9 regions deleteall

    o=`diff $6 ${5}.out`
    if [ "$o" = "" ]
    then
	echo "PASSED"
    else
        echo "FAILED"
	echo "$o"
    fi
    rm -f ${5}.out
}

testit3 () {
    echo "Test $1 $2 $3 $4 $5"
    xpaset -p ds9 regions format $1
    xpaset -p ds9 regions system $2
    xpaset -p ds9 regions sky $3
    xpaset -p ds9 regions skyformat $4
    xpaset -p ds9 regions file $5
    xpaset -p ds9 regions deleteall
    echo "PASSED"
}

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9 -3d -3d vp 45 30&

    i=1
    while [ "$i" -le 30 ]
    do
        sleep 2
        if [ `xpaaccess ds9` = yes ]
        then
	    break
        fi

        i=`expr $i + 1`
    done
fi

echo "Loading Data..."
xpaset -p ds9 file img16.fits

if [ "$1" = "ds9" -o  -z "$1" ]; then
echo
echo "Testing DS9 Format..."
testit ds9 image fk5 degrees ds9.image.reg
testit ds9 physical fk5 degrees ds9.physical.reg
testit ds9 wcs fk4 degrees ds9.fk4.reg
testit ds9 wcs fk4 sexagesimal ds9.fk4.hms.reg
testit ds9 wcs fk5 degrees ds9.fk5.reg
testit ds9 wcs fk5 sexagesimal ds9.fk5.hms.reg
testit ds9 wcs icrs degrees ds9.icrs.reg
testit ds9 wcs icrs sexagesimal ds9.icrs.hms.reg
testit ds9 wcs galactic degrees ds9.galactic.reg
testit ds9 wcs galactic sexagesimal ds9.galactic.hms.reg
testit ds9 wcs ecliptic degrees ds9.ecliptic.reg
testit ds9 wcs ecliptic sexagesimal ds9.ecliptic.hms.reg

echo
echo "Testing XML Format..."
testit xml image fk5 degrees xml.image.reg
testit xml physical fk5 degrees xml.physical.reg
testit xml wcs fk4 degrees xml.fk4.reg
testit xml wcs fk4 sexagesimal xml.fk4.hms.reg
testit xml wcs fk5 degrees xml.fk5.reg
testit xml wcs fk5 sexagesimal xml.fk5.hms.reg
testit xml wcs icrs degrees xml.icrs.reg
testit xml wcs icrs sexagesimal xml.icrs.hms.reg
testit xml wcs galactic degrees xml.galactic.reg
testit xml wcs galactic sexagesimal xml.galactic.hms.reg
testit xml wcs ecliptic degrees xml.ecliptic.reg
testit xml wcs ecliptic sexagesimal xml.ecliptic.hms.reg
fi

if [ -z "$1" ]; then
xpaset -p ds9 quit
fi
