#! /bin/sh

KillIt () {
    i=1
    while [ "$i" -le 15 ]; do
      sleep 1
      if [ `xpaaccess ds9` = yes ]; then
	  if [ $slow = "1" ]; then
	      sleep 1
	  fi
	  xpaset -p ds9 quit
	  break
      fi
      
      i=`expr $i + 1`
    done
}

DoXPA () {
    echo "$1"
    cat $2 | xpaset ds9 fits foo
    if [ $slow = "1" ]; then
	sleep 1
    fi
    xpaset -p ds9 frame clear
}

StartDS9 () {
    if [ `xpaaccess ds9` = no ]; then
	ds9&

	i=1
	while [ "$i" -le 30 ]
	    do
	    sleep 2
	    if [ `xpaaccess ds9` = yes ]; then
		break
	    fi

	    i=`expr $i + 1`
	done
    fi
}

# slow down?
slow=1
if [ "$1" = "slow" ]; then
    slow=1
    shift
fi

# Command Line

export XPA_CONNECT_TIMEOUT=0
export XPA_SHORT_TIMEOUT=-1
export XPA_LONG_TIMEOUT=-1

if [ "$1" = "command" -o  -z "$1" ]; then
echo "Testing Command Line File"

echo "..fits"
ds9 large/ds9.image64.fits &
KillIt

echo "..fits gz"
ds9 large/ds9.image64.fits.gz &
KillIt

echo "..events table"
ds9 large/ds9.table64.fits &
KillIt

echo "..events table gz"
ds9 large/ds9.table64.fits.gz &
KillIt

echo "PASSED"
fi

# Stdin

if [ "$1" = "stdin" -o  -z "$1" ]; then
echo "Testing Stdin File"

echo "..fits"
cat large/ds9.image64.fits | ds9 - &
KillIt

echo "..fits gz"
cat large/ds9.image64.fits.gz | ds9 - &
KillIt

echo "..events table"
cat large/ds9.table64.fits | ds9 - &
KillIt

echo "..events table gz"
cat large/ds9.table64.fits.gz | ds9 - &
KillIt

echo "PASSED"
fi

# XPA
if [ "$1" = "xpa" -o  -z "$1" ]; then
echo "Testing XPA Fits"

StartDS9

echo "Testing Fits"
export XPA_SHORT_TIMEOUT=-1
DoXPA "..fits" large/ds9.image64.fits
DoXPA "..fits gz" large/ds9.image64.fits.gz
DoXPA "..events table" large/ds9.table64.fits
DoXPA "..events table gz" large/ds9.table64.fits.gz
unset  XPA_SHORT_TIMEOUT
xpaset -p ds9 quit
echo "PASSED"
fi

echo "DONE"
