#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

# Menus

proc FileMainMenu {} {
    global ds9

    menu $ds9(mb).file 
    $ds9(mb).file add command -label "[msgcat::mc {Open}]..." \
	-command OpenFits -accelerator "${ds9(ctrl)}O"
    $ds9(mb).file add cascade -label [msgcat::mc {Open Other}] \
	-menu $ds9(mb).file.open
    $ds9(mb).file add separator
    $ds9(mb).file add command -label "[msgcat::mc {Save}]..." \
	-command SaveFits -accelerator "${ds9(ctrl)}S"
    $ds9(mb).file add command -label "[msgcat::mc {Export}]..." \
	-command ExportDialog
    $ds9(mb).file add separator
    $ds9(mb).file add command -label "[msgcat::mc {Save Image}]..." \
	-command SaveImageDialog
    $ds9(mb).file add command -label "[msgcat::mc {Create Movie}]..." \
	-command MovieDialog
    $ds9(mb).file add separator
    $ds9(mb).file add cascade -label [msgcat::mc {Preserve During Load}] \
	-menu $ds9(mb).file.preserve
    $ds9(mb).file add separator
    $ds9(mb).file add command -label "[msgcat::mc {Display Header}]..." \
	-command DisplayHeaderMenu 
    $ds9(mb).file add separator
    $ds9(mb).file add cascade -label [msgcat::mc {XPA}] \
	-menu $ds9(mb).file.xpa
    $ds9(mb).file add cascade -label [msgcat::mc {SAMP}] \
	-menu $ds9(mb).file.samp
    $ds9(mb).file add separator
    $ds9(mb).file add command -label "[msgcat::mc {Backup}]..." \
	-command BackupDialog
    $ds9(mb).file add command -label "[msgcat::mc {Restore}]..." \
	-command RestoreDialog
    $ds9(mb).file add separator
    $ds9(mb).file add command -label "[msgcat::mc {Open TCL Console}]..." \
	-command OpenConsole
    $ds9(mb).file add command -label "[msgcat::mc {Source TCL}]..." \
	-command OpenSource
    $ds9(mb).file add separator
    switch $ds9(wm) {
	x11 {
	    $ds9(mb).file add command -label "[msgcat::mc {Page Setup}]..." \
		-command PSPageSetup -accelerator "${ds9(shiftctrl)}P"
	    $ds9(mb).file add command -label "[msgcat::mc {Print}]..." \
		-command PSPrint -accelerator "${ds9(ctrl)}P"
	}
	win32 {
	    $ds9(mb).file add command \
		-label "[msgcat::mc {Postscript Page Setup}]..." \
		-command PSPageSetup
	    $ds9(mb).file add command \
		-label "[msgcat::mc {Postscript Print}]..." \
		-command PSPrint
	    $ds9(mb).file add separator
	    $ds9(mb).file add command -label "[msgcat::mc {Page Setup}]..." \
		-command Win32PageSetup -accelerator "${ds9(shiftctrl)}P"
	    $ds9(mb).file add command -label "[msgcat::mc {Print}]..." \
		-command Win32Print -accelerator "${ds9(ctrl)}P"
	}
	aqua {
	    $ds9(mb).file add command \
		-label "[msgcat::mc {Postscript Page Setup}]..." \
		-command PSPageSetup
	    $ds9(mb).file add command \
		-label "[msgcat::mc {Postscript Print}]..." \
		-command PSPrint
	    $ds9(mb).file add separator
	    $ds9(mb).file add command -label "[msgcat::mc {Page Setup}]..." \
		-command MacOSXPageSetup -accelerator "${ds9(shiftctrl)}P"
	    $ds9(mb).file add command -label "[msgcat::mc {Print}]..." \
		-command MacOSXPrint -accelerator "${ds9(ctrl)}P"
	}
    }
    switch $ds9(wm) {
	x11 -
	win32 {
	    $ds9(mb).file add separator
	    $ds9(mb).file add command \
		-label [msgcat::mc {Exit}] -command QuitDS9
	}
	aqua {}
    }

    # File Open Menu
    menu $ds9(mb).file.open
    $ds9(mb).file.open add command -label "[msgcat::mc {Open Array}]..." \
	-command OpenArray
    $ds9(mb).file.open add command -label "[msgcat::mc {Open Photo}]..." \
	-command OpenPhoto
    $ds9(mb).file.open add command -label "[msgcat::mc {Open URL}]..." \
	-command OpenURL
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open RGB Fits Image}]..." \
	-command OpenRGBImageFits
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open RGB Fits Cube}]..."\
	-command OpenRGBCubeFits
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open RGB Array}]..." \
	-command OpenRGBArray
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command -label "[msgcat::mc {Open Slice}]..." \
	-command OpenSliceFits
    $ds9(mb).file.open add command -label "[msgcat::mc {Open Photo Slice}]..." \
	-command OpenSlicePhoto
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Multi Ext Cube}]..." \
	-command OpenMECubeFits
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Multi Ext Multi Frames}]..." \
	-command {OpenMultiFrameFits}
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Mosaic IRAF}]..." \
	-command OpenMosaicImageIRAFFits
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Mosaic IRAF Segment}]..." \
	-command OpenMosaicIRAFFits
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Mosaic WCS}]..." \
	-command OpenMosaicImageWCSFits
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Mosaic WCS Segment}]..." \
	-command OpenMosaicWCSFits
    $ds9(mb).file.open add separator
    $ds9(mb).file.open add command \
	-label "[msgcat::mc {Open Mosaic WFPC2}]..." \
	-command OpenMosaicImageWFPC2Fits

    # File Preserve Menu
    menu $ds9(mb).file.preserve
    $ds9(mb).file.preserve add checkbutton -label [msgcat::mc {Scale}] \
	-variable scale(preserve) -command PreserveScale
    $ds9(mb).file.preserve add checkbutton -label [msgcat::mc {Pan}] \
	-variable panzoom(preserve) -command PreservePan
    $ds9(mb).file.preserve add checkbutton -label [msgcat::mc {Region}] \
	-variable marker(preserve) -command MarkerPreserve

    menu $ds9(mb).file.samp
    $ds9(mb).file.samp add command -label [msgcat::mc {Connect}] \
	-command SAMPConnect
    $ds9(mb).file.samp add command -label [msgcat::mc {Disconnect}] \
	-command SAMPDisconnect
    $ds9(mb).file.samp add separator
    $ds9(mb).file.samp add cascade -label [msgcat::mc {Image}] \
	-menu $ds9(mb).file.samp.image
    $ds9(mb).file.samp add cascade -label [msgcat::mc {Table}] \
	-menu $ds9(mb).file.samp.table

    menu $ds9(mb).file.samp.image
    $ds9(mb).file.samp.image add command -label [msgcat::mc {Broadcast}] \
	-command "SAMPSendImageLoadFits {}"
    $ds9(mb).file.samp.image add separator

    menu $ds9(mb).file.samp.table
    $ds9(mb).file.samp.table add command -label [msgcat::mc {Broadcast}] \
	-command "SAMPSendTableLoadFits {}"
    $ds9(mb).file.samp.table add separator

    menu $ds9(mb).file.xpa
    $ds9(mb).file.xpa add command -label [msgcat::mc {Information}] \
	-command XPAInfo
    $ds9(mb).file.xpa add separator
    $ds9(mb).file.xpa add command -label [msgcat::mc {Connect}] \
	-command XPAConnect
    $ds9(mb).file.xpa add command -label [msgcat::mc {Disconnect}] \
	-command XPADisconnect

    # Bindings
    bind $ds9(top) <<Open>> OpenFits
    switch $ds9(wm) {
 	x11 {
	    bind $ds9(top) <<PageSetup>> PSPageSetup
	    bind $ds9(top) <<Print>> PSPrint
	}
 	win32 {
	    bind $ds9(top) <<PageSetup>> Win32PageSetup
	    bind $ds9(top) <<Print>> Win32Print
	}
 	aqua {
	    bind $ds9(top) <<PageSetup>> MacOSXPageSetup
	    bind $ds9(top) <<Print>> MacOSXPrint
	}
    }
}

proc PrefsDialogFileMenu {w} {
    set f [ttk::labelframe $w.mfile -text [msgcat::mc {File}]]

    ttk::menubutton $f.menu -text [msgcat::mc {Menu}] -menu $f.menu.menu
    PrefsDialogButtonbarFile $f.buttonbar

    grid $f.menu $f.buttonbar -padx 2 -pady 2

    set m $f.menu.menu
    menu $m
    $m add cascade -label [msgcat::mc {Preserve During Load}] \
	-menu $m.preserve

    global pscale
    global ppanzoom
    global pmarker
    menu $m.preserve
    $m.preserve add checkbutton -label [msgcat::mc {Scale}] \
	-variable pscale(preserve)
    $m.preserve add checkbutton -label [msgcat::mc {Pan}] \
	-variable ppanzoom(preserve)
    $m.preserve add checkbutton -label [msgcat::mc {Region}] \
	-variable pmarker(preserve)

    pack $f -side top -fill both -expand true
}

# Buttons

proc ButtonsFileDef {} {
    global pbuttons

    array set pbuttons {
	file,open 1
	file,save 1
	file,export 0
	file,saveimage 1
	file,movie 0
	file,header 1
	file,samp,image 0
	file,samp,table 0
	file,xpa 0
	file,console 0
	file,tcl 0
	file,pspage 0
	file,psprint 0
	file,page 1
	file,print 1
	file,exit 1
    }
}

proc CreateButtonsFile {} {
    global ds9
    global buttons

    ttk::frame $ds9(buttons).file

    ButtonButton $ds9(buttons).file.open \
	[string tolower [msgcat::mc {Open}]] OpenFits

    ButtonButton $ds9(buttons).file.save \
	[string tolower [msgcat::mc {Save}]] SaveFits
    ButtonButton $ds9(buttons).file.export \
	[string tolower [msgcat::mc {Export}]] ExportDialog

    ButtonButton $ds9(buttons).file.saveimage \
	[string tolower [msgcat::mc {Save Image}]] SaveImageDialog
    ButtonButton $ds9(buttons).file.movie \
	[string tolower [msgcat::mc {Create Movie}]] MovieDialog

    ButtonButton $ds9(buttons).file.header \
	[string tolower [msgcat::mc {Header}]] DisplayHeaderMenu

    ButtonButton $ds9(buttons).file.sampimage \
	[string tolower [msgcat::mc {SAMP Image}]] "SAMPSendImageLoadFits {}"
    ButtonButton $ds9(buttons).file.samptable \
	[string tolower [msgcat::mc {SAMP Table}]] "SAMPSendTableLoadFits {}"

    ButtonButton $ds9(buttons).file.xpa \
	[string tolower {XPA}] XPAInfo
    ButtonButton $ds9(buttons).file.console \
	[string tolower [msgcat::mc {Console}]] OpenConsole
    ButtonButton $ds9(buttons).file.tcl \
	[string tolower {TCL}] OpenSource

    ButtonButton $ds9(buttons).file.pspage \
	[string tolower [msgcat::mc {PS Page Setup}]] PSPageSetup
    ButtonButton $ds9(buttons).file.psprint \
	[string tolower [msgcat::mc {PS Print}]] PSPrint

    switch $ds9(wm) {
 	x11 {
	    ButtonButton $ds9(buttons).file.page \
		[string tolower [msgcat::mc {Page Setup}]] PSPageSetup
	    ButtonButton $ds9(buttons).file.print \
		[string tolower [msgcat::mc {Print}]] PSPrint
	}
 	win32 {
	    ButtonButton $ds9(buttons).file.page \
		[string tolower [msgcat::mc {Page Setup}]] Win32PageSetup
	    ButtonButton $ds9(buttons).file.print \
		[string tolower [msgcat::mc {Print}]] Win32Print
	}
 	aqua {
	    ButtonButton $ds9(buttons).file.page \
		[string tolower [msgcat::mc {Page Setup}]] MacOSXPageSetup
	    ButtonButton $ds9(buttons).file.print \
		[string tolower [msgcat::mc {Print}]] MacOSXPrint
	}
    }

    ButtonButton $ds9(buttons).file.exit \
	[string tolower [msgcat::mc {Exit}]] QuitDS9

    set buttons(file) "
        $ds9(buttons).file.open pbuttons(file,open)
        $ds9(buttons).file.save pbuttons(file,save)
        $ds9(buttons).file.export pbuttons(file,export)
        $ds9(buttons).file.saveimage pbuttons(file,saveimage)
        $ds9(buttons).file.movie pbuttons(file,movie)
        $ds9(buttons).file.header pbuttons(file,header)
        $ds9(buttons).file.sampimage pbuttons(file,samp,image)
        $ds9(buttons).file.samptable pbuttons(file,samp,table)
        $ds9(buttons).file.xpa pbuttons(file,xpa)
        $ds9(buttons).file.console pbuttons(file,console)
        $ds9(buttons).file.tcl pbuttons(file,tcl)
        $ds9(buttons).file.pspage pbuttons(file,pspage)
        $ds9(buttons).file.psprint pbuttons(file,psprint)
        $ds9(buttons).file.page pbuttons(file,page)
        $ds9(buttons).file.print pbuttons(file,print)
        $ds9(buttons).file.exit pbuttons(file,exit)
    "
}

proc PrefsDialogButtonbarFile {f} {
    global buttons
    global pbuttons

    ttk::menubutton $f -text [msgcat::mc {Buttonbar}] -menu $f.menu
    
    set m $f.menu
    menu $m
    $m add checkbutton -label "[msgcat::mc {Open}]..." \
	-variable pbuttons(file,open) -command {UpdateButtons buttons(file)}

    $m add checkbutton -label "[msgcat::mc {Save}]..." \
	-variable pbuttons(file,save) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add checkbutton -label "[msgcat::mc {Export}]..." \
	-variable pbuttons(file,export) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add checkbutton -label "[msgcat::mc {Save Image}]..." \
	-variable pbuttons(file,saveimage) -command {UpdateButtons buttons(file)}
    $m add checkbutton -label "[msgcat::mc {Create Movie}]..." \
	-variable pbuttons(file,movie) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add checkbutton -label "[msgcat::mc {Display Header}]..." \
	-variable pbuttons(file,header) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add cascade -label [msgcat::mc {SAMP}] -menu $m.samp
    $m add separator
    $m add checkbutton -label "[msgcat::mc {XPA Information}]..." \
	-variable pbuttons(file,xpa) -command {UpdateButtons buttons(file)}
    $m add checkbutton -label "[msgcat::mc {Open TCL Console}]..." \
	-variable pbuttons(file,console) -command {UpdateButtons buttons(file)}
    $m add checkbutton -label "[msgcat::mc {Source TCL}]..." \
	-variable pbuttons(file,tcl) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add checkbutton -label "[msgcat::mc {Postscript Page Setup}]..." \
	-variable pbuttons(file,pspage) -command {UpdateButtons buttons(file)}
    $m add checkbutton -label "[msgcat::mc {Postscript Print}]..." \
	-variable pbuttons(file,psprint) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add checkbutton -label "[msgcat::mc {Page Setup}]..." \
	-variable pbuttons(file,page) -command {UpdateButtons buttons(file)}
    $m add checkbutton -label "[msgcat::mc {Print}]..." \
	-variable pbuttons(file,print) -command {UpdateButtons buttons(file)}
    $m add separator
    $m add checkbutton -label [msgcat::mc {Exit}] \
	-variable pbuttons(file,exit) -command {UpdateButtons buttons(filew)}

    menu $m.samp
    $m.samp add checkbutton -label [msgcat::mc {SAMP Image}] \
	-variable pbuttons(file,samp,image) \
	-command {UpdateButtons buttons(file)}
    $m.samp add checkbutton -label [msgcat::mc {SAMP Table}] \
	-variable pbuttons(file,samp,table) \
	-command {UpdateButtons buttons(file)}
}

# Support

proc UpdateFileMenuStatic {} {
    global ds9
 
    global debug
    if {$debug(tcl,update)} {
	puts stderr "UpdateFileMenuStatic"
    }

    if {$ds9(active,num) > 0} {
	$ds9(mb).file entryconfig "[msgcat::mc {Open}]..." \
	    -state normal
	$ds9(mb).file entryconfig [msgcat::mc {Open Other}] \
	    -state normal
	$ds9(mb).file entryconfig "[msgcat::mc {Save Image}]..." \
	    -state normal
	$ds9(mb).file entryconfig "[msgcat::mc {Create Movie}]..." \
	    -state normal

	$ds9(buttons).file.open configure -state normal
	$ds9(buttons).file.saveimage configure -state normal
	$ds9(buttons).file.movie configure -state normal
    } else {
	$ds9(mb).file entryconfig "[msgcat::mc {Open}]..." \
	    -state disabled
	$ds9(mb).file entryconfig [msgcat::mc {Open Other}] \
	    -state disabled
	$ds9(mb).file entryconfig "[msgcat::mc {Save Image}]..." \
	    -state disabled
	$ds9(mb).file entryconfig "[msgcat::mc {Create Movie}]..." \
	    -state disabled

	$ds9(buttons).file.open configure -state disabled
	$ds9(buttons).file.saveimage configure -state disabled
	$ds9(buttons).file.movie configure -state disabled
    }
}

proc UpdateFileMenu {} {
    global ds9
    global current
    global samp
    global xpa
 
    global debug
    if {$debug(tcl,update)} {
	puts stderr "UpdateFileMenu"
    }

    set mm $ds9(mb).file
    set bb $ds9(buttons).file

    if {$current(frame) != {}} {
	if {[$current(frame) has fits]} {
	    $mm entryconfig "[msgcat::mc {Save}]..." -state normal
	    $mm entryconfig "[msgcat::mc {Export}]..." -state normal
	    $mm entryconfig "[msgcat::mc {Display Header}]..." \
		-state normal

	    $bb.save configure -state normal
	    $bb.header configure -state normal
	} else {
	    $mm entryconfig "[msgcat::mc {Save}]..." -state disabled
	    $mm entryconfig "[msgcat::mc {Export}]..." -state disabled
	    $mm entryconfig "[msgcat::mc {Display Header}]..." \
		-state disabled

	    $bb.save configure -state disabled
	    $bb.header configure -state disabled
	}

	switch -- [$current(frame) get type] {
	    base {
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Fits Image}]..." -state disabled
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Fits Cube}]..." -state disabled
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Array}]..." -state disabled

		$bb.export configure -state normal
	    }
	    rgb {
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Fits Image}]..." -state normal
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Fits Cube}]..." -state normal
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Array}]..." -state normal
		# override above
		$mm entryconfig "[msgcat::mc {Export}]..." -state disabled

		$bb.export configure -state disabled
	    }
	    3d {
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Fits Image}]..." -state disabled
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Fits Cube}]..." -state disabled
		$mm.open entryconfig \
		    "[msgcat::mc {Open RGB Array}]..." -state disabled
		# override above
		$mm entryconfig "[msgcat::mc {Export}]..." -state disabled

		$bb.export configure -state disabled
	    }
	}

	if {[info exists samp]} {
	    set ss [expr $ds9(menu,start)+2]

	    if {[$current(frame) has fits]} {

		$mm.samp entryconfig [msgcat::mc {Image}] \
		    -state normal
		if {[$mm.samp.image index end] >= $ss} {
		    $mm.samp.image delete $ss end
		}
		foreach args $samp(apps,image) {
		    foreach {id name} $args {
			$mm.samp.image add command -label $name \
			    -command "SAMPSendImageLoadFits $id"
		    }
		}
		$bb.sampimage configure -state normal

		if {[$current(frame) has fits bin]} {
		    $mm.samp entryconfig [msgcat::mc {Table}] -state normal
		    if {[$mm.samp.table index end] >= $ss} {
			$mm.samp.table delete $ss end
		    }
		    foreach args $samp(apps,table) {
			foreach {id name} $args {
			    $mm.samp.table add command -label $name \
				-command "SAMPSendTableLoadFits $id"
			}
		    }
		    $bb.samptable configure -state normal

		} else {
		    $mm.samp entryconfig [msgcat::mc {Table}] -state disabled
		    $bb.samptable configure -state disabled
		}
	    } else {
		$mm.samp entryconfig [msgcat::mc {Image}] -state disabled
		$mm.samp entryconfig [msgcat::mc {Table}] -state disabled
		$bb.sampimage configure -state disabled
		$bb.samptable configure -state disabled
	    }
	} else {
	    $mm.samp entryconfig [msgcat::mc {Image}] -state disabled
	    $mm.samp entryconfig [msgcat::mc {Table}] -state disabled
	    $bb.sampimage configure -state disabled
	    $bb.samptable configure -state disabled
	}
    } else {
	$mm entryconfig "[msgcat::mc {Display Header}]..." \
	    -state disabled

	$bb.header configure -state disabled

	$mm.samp entryconfig [msgcat::mc {Image}] -state disabled
	$mm.samp entryconfig [msgcat::mc {Table}] -state disabled
	$bb.sampimage configure -state disabled
	$bb.samptable configure -state disabled
    }

    # XPA
    if [info exists xpa] {
	$mm.xpa entryconfig [msgcat::mc {Information}] -state normal
	$mm.xpa entryconfig [msgcat::mc {Disconnect}] -state normal
    } else {
	$mm.xpa entryconfig [msgcat::mc {Information}] -state disabled
	$mm.xpa entryconfig [msgcat::mc {Disconnect}] -state disabled
    }

    # SAMP
    if {[info exists samp]} {
	$mm.samp entryconfig [msgcat::mc {Connect}] -state disabled
	$mm.samp entryconfig [msgcat::mc {Disconnect}] -state normal
    } else {
	$mm.samp entryconfig [msgcat::mc {Connect}] -state normal
	$mm.samp entryconfig [msgcat::mc {Disconnect}] -state disabled
    }
}

