#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc MarkerAnalysisRadialDialog {varname} {
    upvar #0 $varname var
    global $varname

    set id $var(id)
    set frame $var(frame)

    set vvarname radial${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    set var(radial) [info exists ${vvarname}(top)]

    $var(mb).analysis add checkbutton -label [msgcat::mc {Radial Profile}] \
	-variable ${varname}(radial) \
	-command "MarkerAnalysisRadialCmd $varname"
}

proc MarkerAnalysisRadialCmd {varname} {
    upvar #0 $varname var
    global $varname

    MarkerAnalysisRadial $var(frame) $var(id) $var(radial)
}

proc MarkerAnalysisRadial {frame id radial} {
    $frame marker $id analysis radial $radial
    if {$radial} {
	MarkerAnalysisRadialCB $frame $id

	set vvarname radial${id}${frame}
	upvar #0 $vvarname vvar
	global $vvarname

	PlotRaise $vvarname
    } else {
	MarkerAnalysisRadialDeleteCB $frame $id
    }
}

proc MarkerAnalysisRadialSystem {varname} {
    upvar #0 $varname var
    global $varname

    if {[info exists var(radial)]} {
	if {$var(radial)} {
	    MarkerAnalysisRadialCB $var(frame) $var(id)
	    MarkerAnalysisRadialAxisTitle $var(frame) $var(id)
	}
    }
}

# hardcoded marker.C
proc MarkerAnalysisRadialCB {frame id} {
    set varname "mk${frame}-${id}"
    global $varname
    upvar #0 $varname var

    set vvarname radial${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    if {[info exists var(system)]} {
	set vvar(system) $var(system)
	set sys $var(system)
    } elseif {[info exists vvar(system)]} {
	set sys $vvar(system)
    } else {
	global wcs
	set vvar(system) $wcs(system)
	set sys $wcs(system)
    }

    set xdata radial${id}${frame}x
    set ydata radial${id}${frame}y
    set yedata radial${id}${frame}ye
    global $xdata $ydata $yedata

    if {[PlotPing $vvarname]} {
	$frame get marker $id analysis radial $xdata $ydata $yedata $sys
	PlotCreateErrorY $vvarname
	PlotStats $vvarname
	PlotList $vvarname
    } else {
	set tt [string totitle [$frame get marker $id type]]
	PlotLineDialog $vvarname $tt $tt $sys {}
	MarkerAnalysisRadialAxisTitle $frame $id

	set vvar(manage) 0
	set vvar(dim) xyey
	set vvar(xdata) $xdata
	set vvar(ydata) $ydata
	set vvar(xedata) {}
	set vvar(yedata) $yedata
	blt::vector create $xdata $ydata $yedata

	$frame get marker $id analysis radial $xdata $ydata $yedata $sys

	PlotExternal $vvarname
	$vvar(proc,createelement) $vvarname
	$vvar(proc,updateelement) $vvarname
	$vvar(proc,updategraph) $vvarname
	PlotStats $vvarname
	PlotList $vvarname
    }
}

proc MarkerAnalysisRadialDeleteCB {frame id} {
    # this routine could be called by the region 
    # after the dialog has been deleted

    set vvarname radial${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    # clear any errors
    global errorInfo
    set errorInfo {}

    PlotDestroy $vvarname
}

proc MarkerAnalysisRadialAxisTitle {frame id} {
    set vvarname radial${id}${frame}
    upvar #0 $vvarname vvar
    global $vvarname

    switch -- $vvar(system) {
	image -
	physical -
	amplifier -
	detector {
	    set xtitle "Avg Radius (pixels)"
	    set ytitle "Surface Brightness (cnts/pixels**2)"
	}
	default {
	    if {[$frame has wcs equatorial $vvar(system)]} {
		set xtitle "Avg Radius (arcsecs)"
		set ytitle "Surface Brightness (cnts/arcsec**2)"
	    } else {
		set xtitle "Avg Radius (pixels)"
		set ytitle "Surface Brightness (cnts/pixels**2)"
	    }
	}
    }

    $vvar(graph) xaxis configure -title $xtitle
    $vvar(graph) yaxis configure -title $ytitle
}
