// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

%{

#define YYPARSE_PARAM ff
#define FF ((FitsFile*)ff)
#define YYDEBUG 1

#define GOTOFILT(x) {yyclearin; ffFilter(x);}
#define GOTOARR(x) {yyclearin; ffArray(x);}

#include "file.h"
#include "hpx.h"

char ff_filter[512];
extern int fflex(void);
extern void fferror(const char*);
extern void ffFilter(int);
extern void ffArray(int);

%}

%union {
  float real;
  int integer;
  char str[256];
  void* ptr;
}

%token <integer> INT
%token <integer> INTP
%token <str> STRING

%token ARCH_
%token ARRAY_
%token BIGENDIAN_
%token BIN_
%token BINKEY_
%token BINCOL_
%token BITPIX_
%token COL_
%token DIM_
%token DIMS_
%token ECLIPTIC_
%token EQUATORIAL_
%token GALACTIC_
%token KEY_
%token LAYOUT_
%token LITTLEENDIAN_
%token NESTED_
%token NORTH_
%token ORDER_
%token QUAD_
%token RING_
%token SKIP_
%token SOUTH_
%token SYSTEM_
%token UNKNOWN_
%token XDIM_
%token YDIM_
%token ZDIM_

%%

/*start	: {yydebug=1;} command*/

// assume any error is the start of a filter
command	: filename
	| filename ext
 	| filename sect
	| filename bin
 	| filename ext sect
	| filename ext bin
 	| filename ext sect bin
 	| filename '[' extb ',' sectb ']'
 	| filename '[' extb ',' binb ']'
	| filename '[' arrs ']'
	| filename '[' ARRAY_ {GOTOARR(0)} '(' array ')' ']'
	| filename '[' hpxs ']'
	| filename '[' extb hpxs ']'
	| error {GOTOFILT(0)} STRING {FF->setpFilter(ff_filter);}
	;

filename : /* empty */
	|  STRING {FF->setpName($1);}
	;

ext	: '[' extb ']'
	;

extb	: STRING {FF->setpExt($1);}
	| INT {FF->setpIndex($1);}
	;

sect	: '[' sectb ']'

sectb	: rangex ',' rangey
	| rangex ',' rangey ',' rangez
	| INT '@' INT '@' INT
	{
	  FF->setXMin($3-$1/2); FF->setXMax($3+$1/2); FF->setXValid(1);
	  FF->setYMin($5-$1/2); FF->setYMax($5+$1/2); FF->setYValid(1);
 	}
	| INT '@' INT '@' INT '@' INT
	{
	  FF->setXMin($3-$1/2); FF->setXMax($3+$1/2); FF->setXValid(1);
	  FF->setYMin($5-$1/2); FF->setYMax($5+$1/2); FF->setYValid(1);
	  FF->setZMin($7-$1/2); FF->setZMax($7+$1/2); FF->setZValid(1);
 	}
	| INT '@' INT '@' INTP
	{
	  FF->setXMin($3-$1/2); FF->setXMax($3+$1/2); FF->setXValid(1);
	  FF->setYMin($5-$1/2); FF->setYMax($5+$1/2); FF->setYValid(1);
	  FF->setCoord(1);
 	}
	| INT '@' INT '@' INT '@' INTP
	{
	  FF->setXMin($3-$1/2); FF->setXMax($3+$1/2); FF->setXValid(1);
	  FF->setYMin($5-$1/2); FF->setYMax($5+$1/2); FF->setYValid(1);
	  FF->setZMin($7-$1/2); FF->setZMax($7+$1/2); FF->setZValid(1);
	  FF->setCoord(1);
 	}
	;

rangex	: INT ':' INT 
	  {FF->setXMin($1); FF->setXMax($3); FF->setXValid(1);}
	| INT ':' INTP
	{
	  FF->setXMin($1); FF->setXMax($3); FF->setXValid(1);
	  FF->setCoord(1);
	}
	| INT '@' INT 
	  {FF->setXMin($3-$1/2); FF->setXMax($3+$1/2); FF->setXValid(1);}
	| INT '@' INTP
	{
	  FF->setXMin($3-$1/2); FF->setXMax($3+$1/2); FF->setXValid(1);
	  FF->setCoord(1);
	}
	| '*' {FF->setXValid(0);}
	;

rangey	: INT ':' INT
	  {FF->setYMin($1); FF->setYMax($3); FF->setYValid(1);}
	| INT ':' INTP
	{
	  FF->setYMin($1); FF->setYMax($3); FF->setYValid(1);
	  FF->setCoord(1);
	}
	| INT '@' INT
	  {FF->setYMin($3-$1/2); FF->setYMax($3+$1/2); FF->setYValid(1);}
	| INT '@' INTP
	{
	  FF->setYMin($3-$1/2); FF->setYMax($3+$1/2); FF->setYValid(1);
	  FF->setCoord(1);
	}
	| '*' {FF->setYValid(0);}
	;

rangez	: INT ':' INT
	  {FF->setZMin($1); FF->setZMax($3); FF->setZValid(1);}
	| INT ':' INTP
	{
	  FF->setZMin($1); FF->setZMax($3); FF->setZValid(1);
	  FF->setCoord(1);
	}
	| INT '@' INT
	  {FF->setZMin($3-$1/2); FF->setZMax($3+$1/2); FF->setZValid(1);}
	| INT '@' INTP
	{
	  FF->setZMin($3-$1/2); FF->setZMax($3+$1/2); FF->setZValid(1);
	  FF->setCoord(1);
	}
	| '*' {FF->setZValid(0);}
	;

bin	: '[' binb ']'

binb	: binword '=' binkey
	| binword binkey
	;

binword	: BIN_
	| BINKEY_
	| BINCOL_
	| KEY_
	;

binkey	: '(' STRING ',' STRING ')' {FF->setpBinXY($2,$4);}
	| STRING ',' STRING {FF->setpBinXY($1,$3);}
	| '(' STRING ',' STRING ',' STRING ')' {FF->setpBinXYZ($2,$4,$6);}
	| STRING ',' STRING ',' STRING {FF->setpBinXYZ($1,$3,$5);}
	| '(' STRING ')' {FF->setpBinZ($2);}
	| STRING {FF->setpBinZ($1);}
	;

arrs	: arrs ',' arr
	| arr
	;

arr	: XDIM_ '=' INT {FF->setpXdim($3);}
	| YDIM_ '=' INT {FF->setpYdim($3);}
	| ZDIM_ '=' INT {FF->setpZdim($3);}
	| DIM_ '=' INT {FF->setpXdim($3);FF->setpYdim($3);}
	| DIMS_ '=' INT {FF->setpXdim($3);FF->setpYdim($3);}
	| BITPIX_ '=' INT {FF->setpBitpix($3);}
	| SKIP_ '=' INT {FF->setpSkip($3);}
	| ARCH_ '=' endian
	| endian
	;

endian	: BIGENDIAN_ {FF->setpArch(FitsFile::BIGENDIAN);}
	| LITTLEENDIAN_ {FF->setpArch(FitsFile::LITTLEENDIAN);}
	;

array	: atype adims askip aendian
	;

atype	: 'b' {FF->setpBitpix(8);}
	| 's' {FF->setpBitpix(16);}
	| 'u' {FF->setpBitpix(-16);}
	| 'i' {FF->setpBitpix(32);}
	| 'l' {FF->setpBitpix(64);}
	| 'r' {FF->setpBitpix(-32);}
	| 'f' {FF->setpBitpix(-32);}
	| 'd' {FF->setpBitpix(-64);}
	;

adims	: INT {FF->setpXdim($1);FF->setpYdim($1);}
	| INT '.' INT {FF->setpXdim($1);FF->setpYdim($3);}
	| INT '.' INT '.' INT 
	  {FF->setpXdim($1);FF->setpYdim($3);FF->setpZdim($5);}
	;

askip	: /* empty */
	| ':' INT {FF->setpSkip($2);}
	;

aendian	: /* empty */
	| 'l' {FF->setpArch(FitsFile::LITTLEENDIAN);}
	| 'b' {FF->setpArch(FitsFile::BIGENDIAN);}
	;

hpxs	: hpxs ',' hpx
	| hpx
	;

hpx	: SYSTEM_ '=' hpxSystem
	| ORDER_ '=' hpxOrder
	| LAYOUT_ '=' hpxLayout
	| COL_ '=' INT {FF->setpHPXColumn($3);}
	| QUAD_ '=' INT {FF->setpHPXQuad($3);}
	;

hpxSystem : EQUATORIAL_ {FF->setpHPXSystem(FitsHPX::EQU);}
	  | GALACTIC_ {FF->setpHPXSystem(FitsHPX::GAL);}
	  | ECLIPTIC_ {FF->setpHPXSystem(FitsHPX::ECL);}
	  | UNKNOWN_ {FF->setpHPXSystem(FitsHPX::UNKNOWN);}
	  ;

hpxOrder : RING_ {FF->setpHPXOrder(FitsHPX::RING);}
	 | NESTED_ {FF->setpHPXOrder(FitsHPX::NESTED);}
	 ;

hpxLayout : EQUATORIAL_ {FF->setpHPXLayout(FitsHPX::EQUATOR);}
	  | NORTH_ {FF->setpHPXLayout(FitsHPX::NORTH);}
	  | SOUTH_ {FF->setpHPXLayout(FitsHPX::SOUTH);}
	  ;

%%
