#! /bin/sh

# functions

testit () {
    echo "Testing $1..."
    xpaset -p ds9 scale $1
    xpaset -p ds9 contour scale $1
    xpaset -p ds9 file $2
    xpaset -p ds9 contour yes
    read
    xpaset -p ds9 frame clear
}

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]; then
    ds9&

    i=1
    while [ "$i" -le 30 ]
    do
        sleep 2
        if [ `xpaaccess ds9` = yes ]
        then
	    break
        fi

        i=`expr $i + 1`
    done
fi

echo "Setup..."
xpaset -p ds9 cmap i8
xpaset -p ds9 contour nlevels 9
xpaset -p ds9 contour color black

testit linear linear.fits
testit log pow.fits
testit pow log.fits
testit sqrt squ.fits
testit squared sqrt.fits
testit asinh sinh.fits
testit sinh asinh.fits

echo "Testing histequ..."
xpaset -p ds9 scale histequ
xpaset -p ds9 contour scale histequ
xpaset -p ds9 file linear.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 file log.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 file pow.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 file sqrt.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 file squ.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 file asinh.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 file sinh.fits
xpaset -p ds9 contour generate
xpaset -p ds9 contour yes
read
xpaset -p ds9 frame clear

xpaset -p ds9 quit

