#! /bin/sh

echo "Analysis Tests"
echo

echo "Starting DS9..."
if [ `xpaaccess ds9` = no ]
then
    ds9&
fi

i=1
while [ "$i" -le 30 ]
do
    sleep 2
    if [ `xpaaccess ds9` = yes ]
    then
	break
    fi

    i=`expr $i + 1`
done

# load default
xpaset -p ds9 scale zscale
xpaset -p ds9 file img16.fits
xpaset -p ds9 regions file analysis.reg
xpaset -p ds9 analysis clear
xpaset -p ds9 analysis load analysis.ans

j=0

# Main
if [ "$1" = "help" -o  -z "$1" ]; then
echo "$j Help"
xpaset -p ds9 analysis $j
fi

# Web
if [ "$1" = "web" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "$j Web"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j web url"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j web file"
xpaset -p ds9 analysis $j
fi

# Basics
if [ "$1" = "basics" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "Basic"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j escape macro"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j non macro"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$xpa"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$xpa_method"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$vo_method"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename(root)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename(full)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename(root,3d)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename(full,3d)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filedialog(open)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename(save)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$width $height $depth $bitpix"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$pan"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$env"
xpaset -p ds9 analysis $j
fi

# Regions
if [ "$1" = "regions" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "$j Regions"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$regions"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$regions wcs"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$jnclude_regions_pixels"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$filename $regions"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$regions()"
xpaset -p ds9 analysis $j
fi

# Output
if [ "$1" = "output" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "$j Output"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$null"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$text"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(title,x,y,xyey)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(title,x,y,xyexey)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(title,x,y,4)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(title,x,y,5)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(stdin)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(stdin) text"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$plot(stdin) error"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$data"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$jmage"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$jmage(3d)"
xpaset -p ds9 analysis $j
fi

# Dialogs
if [ "$1" = "dialogs" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "$j Dialog"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$message(message)"

j=`expr $j + 1`
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$message(ok,message)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$entry(message)"
xpaset -p ds9 analysis $j
fi

# Params
if [ "$1" = "params" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "$j Param"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$param"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$param @file"
xpaset -p ds9 analysis $j
fi

# Network
if [ "$1" = "network" -o  -z "$1" ]; then
j=`expr $j + 1`
echo "$j Network"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$url(http://)"
xpaset -p ds9 analysis $j

j=`expr $j + 1`
echo "..$j \$url(ftp://)"
xpaset -p ds9 analysis $j
fi

echo "PASSED"

# Other
if [ "$1" = "other" -o  -z "$1" ]; then
xpaset -p ds9 analysis message {press 'x','y','z' to test interactive}
fi

echo "Done"
