#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc SaveFitsDef {} {
    global savefits

    set savefits(type) image
}

proc SaveFits {} {
    global current
    global savefits

    set fn [SaveFileDialog savefitsfbox]
    if {$fn != {} && $current(frame) != {}} {
	if {[$current(frame) has fits bin]} {
	    if {![SaveFitsParams savefits]} {
		return
	    }
	} else {
	    set savefits(type) image
	}
	$current(frame) save fits $savefits(type) file "\{$fn\}"
    }
}

proc SaveFitsParams {varname} {
    upvar $varname var
    global ed2
    set w {.savefits}

    set ed2(ok) 0
    set ed2(type) $var(type)

    DialogCreate $w {Fits} ed2(ok)

    # Param
    set f [ttk::frame $w.param]

    ttk::label $f.tfits -text [msgcat::mc {Fits}]
    ttk::radiobutton $f.image -text [msgcat::mc {Image}] \
	-variable ed2(type) -value image
    ttk::radiobutton $f.table -text {Table} \
	-variable ed2(type) -value table
    grid $f.tfits $f.image $f.table -padx 2 -pady 2 -sticky w

    # Buttons
    set f [ttk::frame $w.buttons]
    ttk::button $f.ok -text [msgcat::mc {OK}] -command {set ed2(ok) 1} \
	-default active 
    ttk::button $f.cancel -text [msgcat::mc {Cancel}] -command {set ed2(ok) 0}
    pack $f.ok $f.cancel -side left -expand true -padx 2 -pady 4

    bind $w <Return> {set ed2(ok) 1}

    # Fini
    ttk::separator $w.sep -orient horizontal
    pack $w.buttons $w.sep -side bottom -fill x
    pack $w.param -side top -fill both -expand true

    DialogCenter $w 
    DialogWait $w ed2(ok)
    DialogDismiss $w

    if {$ed2(ok)} {
	set var(type) $ed2(type)
    }

    set rr $ed2(ok)
    unset ed2
    return $rr
}

# Cmd

proc ProcessSaveCmd {varname iname} {
    upvar $varname var
    upvar $iname i

    global current
    global savefits

    set fn [lindex $var $i]
    set item [lindex $var [expr $i+1]]
    set type image
    switch --  $item {
	image -
	table {incr i; set type $item}
    }
    if {$fn != {} && $current(frame) != {}} {
	$current(frame) save fits $type file "\{$fn\}"
	FileLast savefitsfbox $fn
    }
}

