// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __fitshpx_h__
#define __fitshpx_h__

#include "vector.h"
#include "file.h"

class FitsHPX : public FitsFile {
 public:
  enum Order {RING, NESTED};
  enum CoordSys {UNKNOWN, EQU, GAL, ECL};
  enum Layout {EQUATOR=0, NORTH=1, SOUTH=2};

 private:
  Order order;
  CoordSys coord;
  Layout layout;
  int quad;

  int width;
  int height;
  off_t size;

  FitsBinColumn* col;

  long nside;
  long nfacet;

  void build(FitsFile*);
  int initHeader(FitsFile*);
  void swap();
  void NESTidx(int facet, int rotn, int jmap, long *healidx);
  void RINGidx(int facet, int rotn, int jmap, long *healidx);

 public:
  FitsHPX(FitsFile*, Order, CoordSys, Layout, int, int);
  ~FitsHPX();
};

class FitsHPXNext : public FitsFile {
 public:
  FitsHPXNext(FitsFile* prev);
};

#endif
