# Samizdat engine exceptions
#
#   Copyright (c) 2002-2006  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#
# vim: et sw=2 sts=2 ts=8 tw=0

require 'samizdat/engine'

# raised for syntax errors in Squish statements
class ProgrammingError < RuntimeError; end

# raised when non-existent resource is requested
class ResourceNotFoundError < RuntimeError; end

# raised on incorrect user action
class UserError < RuntimeError; end

# raised on action that requires login
class AuthError < UserError; end

# raised when account is blocked for email confirmation
class AccountBlockedError < UserError; end
