/*
   Unix SMB/CIFS implementation.
   Parameter loading functions
   Copyright (C) Karl Auer 1993-1998

   Largely re-written by Andrew Tridgell, September 1994

   Copyright (C) Simo Sorce 2001
   Copyright (C) Alexander Bokovoy 2002
   Copyright (C) Stefan (metze) Metzmacher 2002
   Copyright (C) Jim McDonough <jmcd@us.ibm.com> 2003
   Copyright (C) Michael Adam 2008
   Copyright (C) Jelmer Vernooij <jelmer@samba.org> 2007
   Copyright (C) Andrew Bartlett 2011

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

FN_LOCAL_STRING(pathname, szPath)
FN_LOCAL_LIST(hostsallow, szHostsallow)
FN_LOCAL_LIST(hostsdeny, szHostsdeny)
FN_LOCAL_STRING(fstype, fstype)
FN_LOCAL_LIST(ntvfs_handler, ntvfs_handler)
FN_LOCAL_BOOL(msdfs_root, bMSDfsRoot)
FN_LOCAL_BOOL(browseable, bBrowseable)
FN_LOCAL_BOOL(readonly, bRead_only)
FN_LOCAL_BOOL(print_ok, bPrint_ok)
FN_LOCAL_BOOL(map_hidden, bMap_hidden)
FN_LOCAL_BOOL(map_archive, bMap_archive)
FN_LOCAL_BOOL(oplocks, bOpLocks)
FN_LOCAL_BOOL(strict_sync, bStrictSync)
FN_LOCAL_BOOL(ci_filesystem, bCIFileSystem)
FN_LOCAL_BOOL(map_system, bMap_system)
FN_LOCAL_INTEGER(max_connections, iMaxConnections)
FN_LOCAL_INTEGER(csc_policy, iCSCPolicy)
FN_LOCAL_INTEGER(create_mask, iCreate_mask)
FN_LOCAL_INTEGER(force_create_mode, iCreate_force_mode)
FN_LOCAL_INTEGER(dir_mask, iDir_mask)
FN_LOCAL_INTEGER(force_dir_mode, iDir_force_mode)
FN_LOCAL_STRING(preexec, szPreExec)
FN_LOCAL_STRING(postexec, szPostExec)
FN_LOCAL_STRING(rootpreexec, szRootPreExec)
FN_LOCAL_STRING(rootpostexec, szRootPostExec)
FN_LOCAL_STRING(dontdescend, szDontdescend)
FN_LOCAL_STRING(username, szUsername)
FN_LOCAL_LIST(invalid_users, szInvalidUsers)
FN_LOCAL_LIST(valid_users, szValidUsers)
FN_LOCAL_LIST(admin_users, szAdminUsers)
FN_LOCAL_STRING(printcommand, szPrintcommand)
FN_LOCAL_STRING(lpqcommand, szLpqcommand)
FN_LOCAL_STRING(lprmcommand, szLprmcommand)
FN_LOCAL_STRING(lppausecommand, szLppausecommand)
FN_LOCAL_STRING(lpresumecommand, szLpresumecommand)
FN_LOCAL_STRING(queuepausecommand, szQueuepausecommand)
FN_LOCAL_STRING(queueresumecommand, szQueueresumecommand)
static FN_LOCAL_STRING(_printername, szPrintername)
FN_LOCAL_CONST_STRING(printjob_username, szPrintjobUsername)
FN_LOCAL_STRING(magicscript, szMagicScript)
FN_LOCAL_STRING(magicoutput, szMagicOutput)
FN_LOCAL_STRING(comment, comment)
FN_LOCAL_STRING(force_user, force_user)
FN_LOCAL_STRING(force_group, force_group)
FN_LOCAL_LIST(readlist, readlist)
FN_LOCAL_LIST(writelist, writelist)
FN_LOCAL_LIST(printer_admin, printer_admin)
FN_LOCAL_LIST(vfs_objects, szVfsObjects)
FN_LOCAL_STRING(msdfs_proxy, szMSDfsProxy)
static FN_LOCAL_STRING(volume, volume)
FN_LOCAL_STRING(veto_files, szVetoFiles)
FN_LOCAL_STRING(hide_files, szHideFiles)
FN_LOCAL_STRING(veto_oplocks, szVetoOplockFiles)
FN_LOCAL_STRING(aio_write_behind, szAioWriteBehind)
FN_LOCAL_STRING(dfree_command, szDfree)
FN_LOCAL_BOOL(autoloaded, autoloaded)
FN_LOCAL_BOOL(preexec_close, bPreexecClose)
FN_LOCAL_BOOL(rootpreexec_close, bRootpreexecClose)
FN_LOCAL_INTEGER(casesensitive, iCaseSensitive)
FN_LOCAL_BOOL(preservecase, bCasePreserve)
FN_LOCAL_BOOL(shortpreservecase, bShortCasePreserve)
FN_LOCAL_BOOL(hide_dot_files, bHideDotFiles)
FN_LOCAL_BOOL(hide_special_files, bHideSpecialFiles)
FN_LOCAL_BOOL(hideunreadable, bHideUnReadable)
FN_LOCAL_BOOL(hideunwriteable_files, bHideUnWriteableFiles)
FN_LOCAL_BOOL(access_based_share_enum, bAccessBasedShareEnum)
FN_LOCAL_BOOL(no_set_dir, bNo_set_dir)
FN_LOCAL_BOOL(guest_ok, bGuest_ok)
FN_LOCAL_BOOL(guest_only, bGuest_only)
FN_LOCAL_BOOL(administrative_share, bAdministrative_share)
FN_LOCAL_BOOL(print_notify_backchannel, bPrintNotifyBackchannel)
FN_LOCAL_BOOL(store_dos_attributes, bStoreDosAttributes)
FN_LOCAL_BOOL(dmapi_support, bDmapiSupport)
FN_LOCAL_PARM_BOOL(locking, bLocking)
FN_LOCAL_PARM_INTEGER(strict_locking, iStrictLocking)
FN_LOCAL_PARM_BOOL(posix_locking, bPosixLocking)
FN_LOCAL_BOOL(share_modes, bShareModes)
FN_LOCAL_BOOL(kernel_oplocks, bKernelOplocks)
FN_LOCAL_BOOL(level2_oplocks, bLevel2OpLocks)
FN_LOCAL_BOOL(onlyuser, bOnlyUser)
FN_LOCAL_PARM_BOOL(manglednames, bMangledNames)
FN_LOCAL_BOOL(symlinks, bSymlinks)
FN_LOCAL_BOOL(syncalways, bSyncAlways)
FN_LOCAL_BOOL(strict_allocate, bStrictAllocate)
FN_LOCAL_BOOL(delete_readonly, bDeleteReadonly)
FN_LOCAL_BOOL(fake_oplocks, bFakeOplocks)
FN_LOCAL_BOOL(recursive_veto_delete, bDeleteVetoFiles)
FN_LOCAL_BOOL(dos_filemode, bDosFilemode)
FN_LOCAL_BOOL(dos_filetimes, bDosFiletimes)
FN_LOCAL_BOOL(dos_filetime_resolution, bDosFiletimeResolution)
FN_LOCAL_BOOL(fake_dir_create_times, bFakeDirCreateTimes)
FN_LOCAL_BOOL(blocking_locks, bBlockingLocks)
FN_LOCAL_BOOL(inherit_perms, bInheritPerms)
FN_LOCAL_BOOL(inherit_acls, bInheritACLS)
FN_LOCAL_BOOL(inherit_owner, bInheritOwner)
FN_LOCAL_BOOL(use_client_driver, bUseClientDriver)
FN_LOCAL_BOOL(default_devmode, bDefaultDevmode)
FN_LOCAL_BOOL(force_printername, bForcePrintername)
FN_LOCAL_BOOL(nt_acl_support, bNTAclSupport)
FN_LOCAL_BOOL(force_unknown_acl_user, bForceUnknownAclUser)
FN_LOCAL_BOOL(ea_support, bEASupport)
FN_LOCAL_BOOL(_use_sendfile, bUseSendfile)
FN_LOCAL_BOOL(profile_acls, bProfileAcls)
FN_LOCAL_BOOL(map_acl_inherit, bMap_acl_inherit)
FN_LOCAL_BOOL(afs_share, bAfs_Share)
FN_LOCAL_BOOL(acl_check_permissions, bAclCheckPermissions)
FN_LOCAL_BOOL(acl_group_control, bAclGroupControl)
FN_LOCAL_BOOL(acl_map_full_control, bAclMapFullControl)
FN_LOCAL_INTEGER(security_mask, iSecurity_mask)
FN_LOCAL_INTEGER(force_security_mode, iSecurity_force_mode)
FN_LOCAL_INTEGER(dir_security_mask, iDir_Security_mask)
FN_LOCAL_INTEGER(force_dir_security_mode, iDir_Security_force_mode)
FN_LOCAL_INTEGER(defaultcase, iDefaultCase)
FN_LOCAL_INTEGER(minprintspace, iMinPrintSpace)
FN_LOCAL_INTEGER(printing, iPrinting)
FN_LOCAL_INTEGER(max_reported_jobs, iMaxReportedPrintJobs)
FN_LOCAL_INTEGER(oplock_contention_limit, iOplockContentionLimit)
FN_LOCAL_INTEGER(write_cache_size, iWriteCacheSize)
FN_LOCAL_INTEGER(block_size, iBlock_size)
FN_LOCAL_INTEGER(dfree_cache_time, iDfreeCacheTime)
FN_LOCAL_INTEGER(allocation_roundup_size, iallocation_roundup_size)
FN_LOCAL_INTEGER(aio_read_size, iAioReadSize)
FN_LOCAL_INTEGER(aio_write_size, iAioWriteSize)
FN_LOCAL_INTEGER(map_readonly, iMap_readonly)
FN_LOCAL_INTEGER(directory_name_cache_size, iDirectoryNameCacheSize)
FN_LOCAL_INTEGER(smb_encrypt, ismb_encrypt)
FN_LOCAL_CHAR(magicchar, magic_char)
FN_LOCAL_STRING(cups_options, szCupsOptions)
FN_LOCAL_PARM_BOOL(change_notify, bChangeNotify)
FN_LOCAL_PARM_BOOL(kernel_change_notify, bKernelChangeNotify)

FN_GLOBAL_BOOL(allow_insecure_widelinks, bAllowInsecureWidelinks)
FN_GLOBAL_BOOL(allow_trusted_domains, bAllowTrustedDomains)
FN_GLOBAL_BOOL(async_smb_echo_handler, bAsyncSMBEchoHandler)
FN_GLOBAL_BOOL(bind_interfaces_only, bBindInterfacesOnly)
FN_GLOBAL_BOOL(browse_list, bBrowseList)
FN_GLOBAL_BOOL(client_lanman_auth, bClientLanManAuth)
FN_GLOBAL_BOOL(client_ntlmv2_auth, bClientNTLMv2Auth)
FN_GLOBAL_BOOL(client_plaintext_auth, bClientPlaintextAuth)
FN_GLOBAL_BOOL(client_use_spnego, bClientUseSpnego)
FN_GLOBAL_BOOL(client_use_spnego_principal, client_use_spnego_principal)
FN_GLOBAL_BOOL(clustering, clustering)
FN_GLOBAL_BOOL(create_krb5_conf, bCreateKrb5Conf)
FN_GLOBAL_BOOL(debug_class, bDebugClass)
FN_GLOBAL_BOOL(debug_hires_timestamp, bDebugHiresTimestamp)
FN_GLOBAL_BOOL(debug_pid, bDebugPid)
FN_GLOBAL_BOOL(debug_prefix_timestamp, bDebugPrefixTimestamp)
FN_GLOBAL_BOOL(debug_uid, bDebugUid)
FN_GLOBAL_BOOL(defer_sharing_violations, bDeferSharingViolations)
FN_GLOBAL_BOOL(disable_netbios, bDisableNetbios)
FN_GLOBAL_BOOL(_disable_spoolss, bDisableSpoolss)
FN_GLOBAL_BOOL(dns_recursive_queries, dns_recursive_queries)
FN_GLOBAL_BOOL(enable_asu_support, bASUSupport)
FN_GLOBAL_BOOL(enable_core_files, bEnableCoreFiles)
FN_GLOBAL_BOOL(enable_privileges, bEnablePrivileges)
FN_GLOBAL_BOOL(encrypted_passwords, bEncryptPasswords)
FN_GLOBAL_BOOL(enhanced_browsing, enhanced_browsing)
FN_GLOBAL_BOOL(getwd_cache, getwd_cache)
FN_GLOBAL_BOOL(host_msdfs, bHostMSDfs)
FN_GLOBAL_BOOL(hostname_lookups, bHostnameLookups)
FN_GLOBAL_BOOL(lanman_auth, bLanmanAuth)
FN_GLOBAL_BOOL(large_readwrite, bLargeReadwrite)
FN_GLOBAL_BOOL(ldap_delete_dn, ldap_delete_dn)
FN_GLOBAL_BOOL(ldap_ssl_ads, ldap_ssl_ads)
FN_GLOBAL_BOOL(load_printers, bLoadPrinters)
FN_GLOBAL_BOOL(local_master, bLocalMaster)
FN_GLOBAL_BOOL(log_writeable_files_on_exit, bLogWriteableFilesOnExit)
FN_GLOBAL_BOOL(map_untrusted_to_domain, bMapUntrustedToDomain)
FN_GLOBAL_BOOL(ms_add_printer_wizard, bMsAddPrinterWizard)
FN_GLOBAL_BOOL(multicast_dns_register, bMulticastDnsRegister)
FN_GLOBAL_BOOL(nis_home_map, bNISHomeMap)
FN_GLOBAL_BOOL(nmbd_bind_explicit_broadcast, bNmbdBindExplicitBroadcast)
FN_GLOBAL_BOOL(ntlm_auth, bNTLMAuth)
FN_GLOBAL_BOOL(nt_pipe_support, bNTPipeSupport)
FN_GLOBAL_BOOL(nt_status_support, bNTStatusSupport)
FN_GLOBAL_BOOL(null_passwords, bNullPasswords)
FN_GLOBAL_BOOL(obey_pam_restrictions, bObeyPamRestrictions)
FN_GLOBAL_BOOL(pam_password_change, bPamPasswordChange)
FN_GLOBAL_BOOL(paranoid_server_security, paranoid_server_security)
FN_GLOBAL_BOOL(passdb_expand_explicit, bPassdbExpandExplicit)
FN_GLOBAL_BOOL(passwd_chat_debug, bPasswdChatDebug)
FN_GLOBAL_BOOL(registry_shares, bRegistryShares)
FN_GLOBAL_BOOL(reset_on_zero_vc, bResetOnZeroVC)
FN_GLOBAL_BOOL(rpc_big_endian, bRpcBigEndian)
FN_GLOBAL_BOOL(stat_cache, bStatCache)
FN_GLOBAL_BOOL(syslog_only, bSyslogOnly)
FN_GLOBAL_BOOL(timestamp_logs, bTimestampLogs)
FN_GLOBAL_BOOL(tls_enabled, tls_enabled)
FN_GLOBAL_BOOL(unix_extensions, bUnixExtensions)
FN_GLOBAL_BOOL(unix_password_sync, bUnixPasswdSync)
FN_GLOBAL_BOOL(use_mmap, bUseMmap)
FN_GLOBAL_BOOL(usershare_allow_guests, bUsershareAllowGuests)
FN_GLOBAL_BOOL(usershare_owner_only, bUsershareOwnerOnly)
FN_GLOBAL_BOOL(use_spnego, bUseSpnego)
FN_GLOBAL_BOOL(utmp, bUtmp)
FN_GLOBAL_BOOL(we_are_a_wins_server, bWINSsupport)
FN_GLOBAL_BOOL(winbind_enum_groups, bWinbindEnumGroups)
FN_GLOBAL_BOOL(winbind_enum_users, bWinbindEnumUsers)
FN_GLOBAL_BOOL(winbind_nested_groups, bWinbindNestedGroups)
FN_GLOBAL_BOOL(winbind_normalize_names, bWinbindNormalizeNames)
FN_GLOBAL_BOOL(winbind_offline_logon, bWinbindOfflineLogon)
FN_GLOBAL_BOOL(winbind_refresh_tickets, bWinbindRefreshTickets)
FN_GLOBAL_BOOL(winbind_rpc_only, bWinbindRpcOnly)
FN_GLOBAL_BOOL(winbind_sealed_pipes, bWinbindSealedPipes)
FN_GLOBAL_BOOL(winbind_trusted_domains_only, bWinbindTrustedDomainsOnly)
FN_GLOBAL_BOOL(winbind_use_default_domain, bWinbindUseDefaultDomain)
FN_GLOBAL_BOOL(wins_dns_proxy, bWINSdnsProxy)
FN_GLOBAL_BOOL(wins_proxy, bWINSproxy)
FN_GLOBAL_CONST_STRING(afs_username_map, szAfsUsernameMap)
FN_GLOBAL_CONST_STRING(dedicated_keytab_file, szDedicatedKeytabFile)
FN_GLOBAL_CONST_STRING(dnsdomain, szRealm_lower)
FN_GLOBAL_CONST_STRING(dns_forwarder, dns_forwarder)
FN_GLOBAL_CONST_STRING(dos_charset, dos_charset)
FN_GLOBAL_CONST_STRING(guestaccount, szGuestaccount)
FN_GLOBAL_CONST_STRING(idmap_backend, szIdmapBackend)
FN_GLOBAL_CONST_STRING(lockdir, szLockDir)
FN_GLOBAL_CONST_STRING(logon_drive, szLogonDrive)
FN_GLOBAL_CONST_STRING(logon_home, szLogonHome)
FN_GLOBAL_CONST_STRING(logon_path, szLogonPath)
FN_GLOBAL_CONST_STRING(logon_script, szLogonScript)
FN_GLOBAL_CONST_STRING(ncalrpc_dir, ncalrpc_dir)
FN_GLOBAL_CONST_STRING(netbios_name, szNetbiosName)
FN_GLOBAL_CONST_STRING(netbios_scope, szNetbiosScope)
FN_GLOBAL_CONST_STRING(ntp_signd_socket_directory, szNTPSignDSocketDirectory)
FN_GLOBAL_CONST_STRING(passdb_backend, passdb_backend)
FN_GLOBAL_CONST_STRING(passwordserver, szPasswordServer)
FN_GLOBAL_CONST_STRING(piddir, szPidDir)
FN_GLOBAL_CONST_STRING(private_dir, szPrivateDir)
FN_GLOBAL_CONST_STRING(realm, szRealm_upper)
FN_GLOBAL_CONST_STRING(smb_passwd_file, szSMBPasswdFile)
FN_GLOBAL_CONST_STRING(socket_options, socket_options)
FN_GLOBAL_CONST_STRING(template_homedir, szTemplateHomedir)
FN_GLOBAL_CONST_STRING(template_shell, szTemplateShell)
FN_GLOBAL_CONST_STRING(unix_charset, unix_charset)
FN_GLOBAL_CONST_STRING(utmpdir, szUtmpDir)
FN_GLOBAL_CONST_STRING(winbindd_privileged_socket_directory, szWinbinddPrivilegedSocketDirectory)
FN_GLOBAL_CONST_STRING(winbindd_socket_directory, szWinbinddSocketDirectory)
FN_GLOBAL_CONST_STRING(winbind_separator, szWinbindSeparator)
FN_GLOBAL_CONST_STRING(workgroup, szWorkgroup)
FN_GLOBAL_CONST_STRING(wtmpdir, szWtmpDir)
FN_GLOBAL_INTEGER(acl_compatibility, iAclCompat)
FN_GLOBAL_INTEGER(afs_token_lifetime, iAfsTokenLifetime)
FN_GLOBAL_INTEGER(algorithmic_rid_base, AlgorithmicRidBase)
FN_GLOBAL_INTEGER(allow_dns_updates, allow_dns_updates)
FN_GLOBAL_INTEGER(cldap_port, cldap_port)
FN_GLOBAL_INTEGER(client_ldap_sasl_wrapping, client_ldap_sasl_wrapping)
FN_GLOBAL_INTEGER(client_schannel, clientSchannel)
FN_GLOBAL_INTEGER(client_signing, client_signing)
FN_GLOBAL_INTEGER(cli_maxprotocol, cli_maxprotocol)
FN_GLOBAL_INTEGER(cli_minprotocol, cli_minprotocol)
FN_GLOBAL_INTEGER(config_backend, ConfigBackend)
FN_GLOBAL_INTEGER(ctdb_locktime_warn_threshold, ctdb_locktime_warn_threshold)
FN_GLOBAL_INTEGER(ctdb_timeout, ctdb_timeout)
FN_GLOBAL_INTEGER(cups_connection_timeout, cups_connection_timeout)
FN_GLOBAL_INTEGER(deadtime, deadtime)
FN_GLOBAL_INTEGER(dgram_port, dgram_port)
FN_GLOBAL_INTEGER(idmap_cache_time, iIdmapCacheTime)
FN_GLOBAL_INTEGER(idmap_negative_cache_time, iIdmapNegativeCacheTime)
FN_GLOBAL_INTEGER(init_logon_delay, InitLogonDelay)
FN_GLOBAL_INTEGER(keepalive, iKeepalive)
FN_GLOBAL_INTEGER(kerberos_method, iKerberosMethod)
FN_GLOBAL_INTEGER(kpasswd_port, kpasswd_port)
FN_GLOBAL_INTEGER(krb5_port, krb5_port)
FN_GLOBAL_INTEGER(ldap_connection_timeout, ldap_connection_timeout)
FN_GLOBAL_INTEGER(ldap_debug_level, ldap_debug_level)
FN_GLOBAL_INTEGER(ldap_debug_threshold, ldap_debug_threshold)
FN_GLOBAL_INTEGER(ldap_deref, ldap_deref)
FN_GLOBAL_INTEGER(ldap_follow_referral, ldap_follow_referral)
FN_GLOBAL_INTEGER(ldap_page_size, ldap_page_size)
FN_GLOBAL_INTEGER(ldap_passwd_sync, ldap_passwd_sync)
FN_GLOBAL_INTEGER(ldap_replication_sleep, ldap_replication_sleep)
FN_GLOBAL_INTEGER(ldap_ssl, ldap_ssl)
FN_GLOBAL_INTEGER(ldap_timeout, ldap_timeout)
FN_GLOBAL_INTEGER(lm_announce, lm_announce)
FN_GLOBAL_INTEGER(lm_interval, lm_interval)
FN_GLOBAL_INTEGER(lock_spin_time, iLockSpinTime)
FN_GLOBAL_INTEGER(lpqcachetime, lpqcachetime)
FN_GLOBAL_INTEGER(machine_password_timeout, machine_password_timeout)
FN_GLOBAL_INTEGER(mangle_prefix, mangle_prefix)
FN_GLOBAL_INTEGER(map_to_guest, map_to_guest)
FN_GLOBAL_INTEGER(maxdisksize, maxdisksize)
FN_GLOBAL_INTEGER(max_log_size, max_log_size)
FN_GLOBAL_INTEGER(maxmux, max_mux)
FN_GLOBAL_INTEGER(max_open_files, max_open_files)
FN_GLOBAL_INTEGER(max_smbd_processes, iMaxSmbdProcesses)
FN_GLOBAL_INTEGER(max_stat_cache_size, iMaxStatCacheSize)
FN_GLOBAL_INTEGER(max_ttl, max_ttl)
FN_GLOBAL_INTEGER(max_wins_ttl, max_wins_ttl)
FN_GLOBAL_INTEGER(max_xmit, max_xmit)
FN_GLOBAL_INTEGER(min_wins_ttl, min_wins_ttl)
FN_GLOBAL_INTEGER(name_cache_timeout, name_cache_timeout)
FN_GLOBAL_INTEGER(nbt_port, nbt_port)
FN_GLOBAL_INTEGER(open_files_db_hash_size, open_files_db_hash_size)
FN_GLOBAL_INTEGER(oplock_break_wait_time, oplock_break_wait_time)
FN_GLOBAL_INTEGER(os_level, os_level)
FN_GLOBAL_INTEGER(passwd_chat_timeout, iPasswdChatTimeout)
FN_GLOBAL_INTEGER(passwordlevel, pwordlevel)
FN_GLOBAL_INTEGER(printcap_cache_time, PrintcapCacheTime)
FN_GLOBAL_INTEGER(restrict_anonymous, restrict_anonymous)
FN_GLOBAL_INTEGER(server_schannel, serverSchannel)
FN_GLOBAL_INTEGER(server_signing, server_signing)
FN_GLOBAL_INTEGER(smb2_max_read, ismb2_max_read)
FN_GLOBAL_INTEGER(smb2_max_trans, ismb2_max_trans)
FN_GLOBAL_INTEGER(smb2_max_write, ismb2_max_write)
FN_GLOBAL_INTEGER(srv_maxprotocol, srv_maxprotocol)
FN_GLOBAL_INTEGER(srv_minprotocol, srv_minprotocol)
FN_GLOBAL_INTEGER(syslog, syslog)
FN_GLOBAL_INTEGER(usernamelevel, unamelevel)
FN_GLOBAL_INTEGER(username_map_cache_time, iUsernameMapCacheTime)
FN_GLOBAL_INTEGER(web_port, web_port)
FN_GLOBAL_INTEGER(winbind_cache_time, winbind_cache_time)
FN_GLOBAL_INTEGER(winbind_expand_groups, winbind_expand_groups)
FN_GLOBAL_INTEGER(winbind_max_clients, winbind_max_clients)
FN_GLOBAL_INTEGER(winbind_reconnect_delay, winbind_reconnect_delay)
FN_GLOBAL_LIST(auth_methods, AuthMethods)
FN_GLOBAL_LIST(cluster_addresses, szClusterAddresses)
FN_GLOBAL_LIST(dcerpc_endpoint_servers, dcerpc_ep_servers)
FN_GLOBAL_LIST(dns_update_command, szDNSUpdateCommand)
FN_GLOBAL_LIST(eventlog_list, szEventLogs)
FN_GLOBAL_LIST(init_logon_delayed_hosts, szInitLogonDelayedHosts)
FN_GLOBAL_LIST(interfaces, szInterfaces)
FN_GLOBAL_LIST(netbios_aliases, szNetbiosAliases)
FN_GLOBAL_LIST(nsupdate_command, szNSUpdateCommand)
FN_GLOBAL_LIST(preload_modules, szPreloadModules)
FN_GLOBAL_LIST(rndc_command, szRNDCCommand)
FN_GLOBAL_LIST(samba_kcc_command, szSambaKCCCommand)
FN_GLOBAL_LIST(server_services, server_services)
FN_GLOBAL_LIST(spn_update_command, szSPNUpdateCommand)
FN_GLOBAL_LIST(svcctl_list, szServicesList)
FN_GLOBAL_LIST(usershare_prefix_allow_list, szUsersharePrefixAllowList)
FN_GLOBAL_LIST(usershare_prefix_deny_list, szUsersharePrefixDenyList)
FN_GLOBAL_LIST(winbind_nss_info, szWinbindNssInfo)
FN_GLOBAL_LIST(wins_server_list, szWINSservers)
FN_GLOBAL_STRING(abort_shutdown_script, szAbortShutdownScript)
FN_GLOBAL_STRING(addgroup_script, szAddGroupScript)
FN_GLOBAL_STRING(addmachine_script, szAddMachineScript)
FN_GLOBAL_STRING(addport_cmd, szAddPortCommand)
FN_GLOBAL_STRING(addprinter_cmd, szAddPrinterCommand)
FN_GLOBAL_STRING(add_share_cmd, szAddShareCommand)
FN_GLOBAL_STRING(adduser_script, szAddUserScript)
FN_GLOBAL_STRING(addusertogroup_script, szAddUserToGroupScript)
FN_GLOBAL_STRING(auto_services, szAutoServices)
FN_GLOBAL_STRING(change_share_cmd, szChangeShareCommand)
FN_GLOBAL_STRING(check_password_script, szCheckPasswordScript)
FN_GLOBAL_STRING(cups_server, szCupsServer)
FN_GLOBAL_STRING(defaultservice, szDefaultService)
FN_GLOBAL_STRING(deleteprinter_cmd, szDeletePrinterCommand)
FN_GLOBAL_STRING(delete_share_cmd, szDeleteShareCommand)
FN_GLOBAL_STRING(delgroup_script, szDelGroupScript)
FN_GLOBAL_STRING(deluserfromgroup_script, szDelUserFromGroupScript)
FN_GLOBAL_STRING(deluser_script, szDelUserScript)
FN_GLOBAL_STRING(enumports_cmd, szEnumPortsCommand)
FN_GLOBAL_STRING(get_quota_command, szGetQuota)
FN_GLOBAL_STRING(iprint_server, szIPrintServer)
FN_GLOBAL_STRING(ldap_admin_dn, szLdapAdminDn)
FN_GLOBAL_STRING(ldap_suffix, szLdapSuffix)
FN_GLOBAL_STRING(logfile, logfile)
FN_GLOBAL_STRING(log_nt_token_command, szLogNtTokenCommand)
FN_GLOBAL_STRING(mangling_method, szManglingMethod)
FN_GLOBAL_STRING(msg_command, szMsgCommand)
FN_GLOBAL_STRING(nis_home_map_name, szNISHomeMapName)
FN_GLOBAL_STRING(ntptr_providor, ntptr_providor)
FN_GLOBAL_STRING(os2_driver_map, szOs2DriverMap)
FN_GLOBAL_STRING(panic_action, szPanicAction)
FN_GLOBAL_STRING(passwd_chat, szPasswdChat)
FN_GLOBAL_STRING(passwd_program, szPasswdProgram)
FN_GLOBAL_STRING(perfcount_module, szSMBPerfcountModule)
FN_GLOBAL_STRING(remote_announce, szRemoteAnnounce)
FN_GLOBAL_STRING(remote_browse_sync, szRemoteBrowseSync)
FN_GLOBAL_STRING(renameuser_script, szRenameUserScript)
FN_GLOBAL_STRING(rootdir, szRootdir)
FN_GLOBAL_STRING(serverstring, szServerString)
FN_GLOBAL_STRING(setprimarygroup_script, szSetPrimaryGroupScript)
FN_GLOBAL_STRING(set_quota_command, szSetQuota)
FN_GLOBAL_STRING(share_backend, szShareBackend)
FN_GLOBAL_STRING(shutdown_script, szShutdownScript)
FN_GLOBAL_STRING(username_map_script, szUsernameMapScript)
FN_GLOBAL_STRING(username_map, szUsernameMap)
FN_GLOBAL_STRING(usershare_path, szUsersharePath)
FN_GLOBAL_STRING(wins_hook, szWINSHook)
