/* server functions auto-generated by pidl */
#include "autoconf/librpc/gen_ndr/ndr_srvsvc.h"

NTSTATUS dcerpc_server_srvsvc_init(void);

/* srvsvc - dcerpc server boilerplate generated by pidl */


static NTSTATUS srvsvc__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface, uint32_t if_version)
{
#ifdef DCESRV_INTERFACE_SRVSVC_BIND
	return DCESRV_INTERFACE_SRVSVC_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void srvsvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SRVSVC_UNBIND
	DCESRV_INTERFACE_SRVSVC_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS srvsvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_srvsvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_srvsvc.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_srvsvc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_srvsvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_srvsvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS srvsvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct srvsvc_NetCharDevEnum *r2 = (struct srvsvc_NetCharDevEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevEnum will reply async\n"));
		}
		break;
	}
	case 1: {
		struct srvsvc_NetCharDevGetInfo *r2 = (struct srvsvc_NetCharDevGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevGetInfo will reply async\n"));
		}
		break;
	}
	case 2: {
		struct srvsvc_NetCharDevControl *r2 = (struct srvsvc_NetCharDevControl *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevControl, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevControl(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevControl will reply async\n"));
		}
		break;
	}
	case 3: {
		struct srvsvc_NetCharDevQEnum *r2 = (struct srvsvc_NetCharDevQEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevQEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQEnum will reply async\n"));
		}
		break;
	}
	case 4: {
		struct srvsvc_NetCharDevQGetInfo *r2 = (struct srvsvc_NetCharDevQGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevQGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQGetInfo will reply async\n"));
		}
		break;
	}
	case 5: {
		struct srvsvc_NetCharDevQSetInfo *r2 = (struct srvsvc_NetCharDevQSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQSetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevQSetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQSetInfo will reply async\n"));
		}
		break;
	}
	case 6: {
		struct srvsvc_NetCharDevQPurge *r2 = (struct srvsvc_NetCharDevQPurge *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurge, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevQPurge(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQPurge will reply async\n"));
		}
		break;
	}
	case 7: {
		struct srvsvc_NetCharDevQPurgeSelf *r2 = (struct srvsvc_NetCharDevQPurgeSelf *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurgeSelf, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetCharDevQPurgeSelf(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQPurgeSelf will reply async\n"));
		}
		break;
	}
	case 8: {
		struct srvsvc_NetConnEnum *r2 = (struct srvsvc_NetConnEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetConnEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetConnEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetConnEnum will reply async\n"));
		}
		break;
	}
	case 9: {
		struct srvsvc_NetFileEnum *r2 = (struct srvsvc_NetFileEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetFileEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileEnum will reply async\n"));
		}
		break;
	}
	case 10: {
		struct srvsvc_NetFileGetInfo *r2 = (struct srvsvc_NetFileGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetFileGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileGetInfo will reply async\n"));
		}
		break;
	}
	case 11: {
		struct srvsvc_NetFileClose *r2 = (struct srvsvc_NetFileClose *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileClose, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetFileClose(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileClose will reply async\n"));
		}
		break;
	}
	case 12: {
		struct srvsvc_NetSessEnum *r2 = (struct srvsvc_NetSessEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetSessEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSessEnum will reply async\n"));
		}
		break;
	}
	case 13: {
		struct srvsvc_NetSessDel *r2 = (struct srvsvc_NetSessDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetSessDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSessDel will reply async\n"));
		}
		break;
	}
	case 14: {
		struct srvsvc_NetShareAdd *r2 = (struct srvsvc_NetShareAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareAdd, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareAdd will reply async\n"));
		}
		break;
	}
	case 15: {
		struct srvsvc_NetShareEnumAll *r2 = (struct srvsvc_NetShareEnumAll *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnumAll, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareEnumAll(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareEnumAll will reply async\n"));
		}
		break;
	}
	case 16: {
		struct srvsvc_NetShareGetInfo *r2 = (struct srvsvc_NetShareGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareGetInfo will reply async\n"));
		}
		break;
	}
	case 17: {
		struct srvsvc_NetShareSetInfo *r2 = (struct srvsvc_NetShareSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareSetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareSetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareSetInfo will reply async\n"));
		}
		break;
	}
	case 18: {
		struct srvsvc_NetShareDel *r2 = (struct srvsvc_NetShareDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDel will reply async\n"));
		}
		break;
	}
	case 19: {
		struct srvsvc_NetShareDelSticky *r2 = (struct srvsvc_NetShareDelSticky *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelSticky, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareDelSticky(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelSticky will reply async\n"));
		}
		break;
	}
	case 20: {
		struct srvsvc_NetShareCheck *r2 = (struct srvsvc_NetShareCheck *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareCheck, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareCheck(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareCheck will reply async\n"));
		}
		break;
	}
	case 21: {
		struct srvsvc_NetSrvGetInfo *r2 = (struct srvsvc_NetSrvGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetSrvGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSrvGetInfo will reply async\n"));
		}
		break;
	}
	case 22: {
		struct srvsvc_NetSrvSetInfo *r2 = (struct srvsvc_NetSrvSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvSetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetSrvSetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSrvSetInfo will reply async\n"));
		}
		break;
	}
	case 23: {
		struct srvsvc_NetDiskEnum *r2 = (struct srvsvc_NetDiskEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetDiskEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetDiskEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetDiskEnum will reply async\n"));
		}
		break;
	}
	case 24: {
		struct srvsvc_NetServerStatisticsGet *r2 = (struct srvsvc_NetServerStatisticsGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerStatisticsGet, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetServerStatisticsGet(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerStatisticsGet will reply async\n"));
		}
		break;
	}
	case 25: {
		struct srvsvc_NetTransportAdd *r2 = (struct srvsvc_NetTransportAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportAdd, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetTransportAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportAdd will reply async\n"));
		}
		break;
	}
	case 26: {
		struct srvsvc_NetTransportEnum *r2 = (struct srvsvc_NetTransportEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetTransportEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportEnum will reply async\n"));
		}
		break;
	}
	case 27: {
		struct srvsvc_NetTransportDel *r2 = (struct srvsvc_NetTransportDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetTransportDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportDel will reply async\n"));
		}
		break;
	}
	case 28: {
		struct srvsvc_NetRemoteTOD *r2 = (struct srvsvc_NetRemoteTOD *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetRemoteTOD, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetRemoteTOD(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetRemoteTOD will reply async\n"));
		}
		break;
	}
	case 29: {
		struct srvsvc_NetSetServiceBits *r2 = (struct srvsvc_NetSetServiceBits *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetServiceBits, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetSetServiceBits(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSetServiceBits will reply async\n"));
		}
		break;
	}
	case 30: {
		struct srvsvc_NetPathType *r2 = (struct srvsvc_NetPathType *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathType, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetPathType(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathType will reply async\n"));
		}
		break;
	}
	case 31: {
		struct srvsvc_NetPathCanonicalize *r2 = (struct srvsvc_NetPathCanonicalize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCanonicalize, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetPathCanonicalize(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathCanonicalize will reply async\n"));
		}
		break;
	}
	case 32: {
		struct srvsvc_NetPathCompare *r2 = (struct srvsvc_NetPathCompare *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCompare, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetPathCompare(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathCompare will reply async\n"));
		}
		break;
	}
	case 33: {
		struct srvsvc_NetNameValidate *r2 = (struct srvsvc_NetNameValidate *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetNameValidate, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetNameValidate(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetNameValidate will reply async\n"));
		}
		break;
	}
	case 34: {
		struct srvsvc_NETRPRNAMECANONICALIZE *r2 = (struct srvsvc_NETRPRNAMECANONICALIZE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRPRNAMECANONICALIZE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRPRNAMECANONICALIZE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRPRNAMECANONICALIZE will reply async\n"));
		}
		break;
	}
	case 35: {
		struct srvsvc_NetPRNameCompare *r2 = (struct srvsvc_NetPRNameCompare *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPRNameCompare, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetPRNameCompare(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPRNameCompare will reply async\n"));
		}
		break;
	}
	case 36: {
		struct srvsvc_NetShareEnum *r2 = (struct srvsvc_NetShareEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnum, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareEnum(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareEnum will reply async\n"));
		}
		break;
	}
	case 37: {
		struct srvsvc_NetShareDelStart *r2 = (struct srvsvc_NetShareDelStart *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelStart, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareDelStart(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelStart will reply async\n"));
		}
		break;
	}
	case 38: {
		struct srvsvc_NetShareDelCommit *r2 = (struct srvsvc_NetShareDelCommit *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelCommit, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetShareDelCommit(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelCommit will reply async\n"));
		}
		break;
	}
	case 39: {
		struct srvsvc_NetGetFileSecurity *r2 = (struct srvsvc_NetGetFileSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetGetFileSecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetGetFileSecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetGetFileSecurity will reply async\n"));
		}
		break;
	}
	case 40: {
		struct srvsvc_NetSetFileSecurity *r2 = (struct srvsvc_NetSetFileSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetFileSecurity, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetSetFileSecurity(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSetFileSecurity will reply async\n"));
		}
		break;
	}
	case 41: {
		struct srvsvc_NetServerTransportAddEx *r2 = (struct srvsvc_NetServerTransportAddEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerTransportAddEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetServerTransportAddEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerTransportAddEx will reply async\n"));
		}
		break;
	}
	case 42: {
		struct srvsvc_NetServerSetServiceBitsEx *r2 = (struct srvsvc_NetServerSetServiceBitsEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerSetServiceBitsEx, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NetServerSetServiceBitsEx(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerSetServiceBitsEx will reply async\n"));
		}
		break;
	}
	case 43: {
		struct srvsvc_NETRDFSGETVERSION *r2 = (struct srvsvc_NETRDFSGETVERSION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSGETVERSION, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSGETVERSION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSGETVERSION will reply async\n"));
		}
		break;
	}
	case 44: {
		struct srvsvc_NETRDFSCREATELOCALPARTITION *r2 = (struct srvsvc_NETRDFSCREATELOCALPARTITION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATELOCALPARTITION, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSCREATELOCALPARTITION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSCREATELOCALPARTITION will reply async\n"));
		}
		break;
	}
	case 45: {
		struct srvsvc_NETRDFSDELETELOCALPARTITION *r2 = (struct srvsvc_NETRDFSDELETELOCALPARTITION *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETELOCALPARTITION, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSDELETELOCALPARTITION(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSDELETELOCALPARTITION will reply async\n"));
		}
		break;
	}
	case 46: {
		struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r2 = (struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETLOCALVOLUMESTATE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSSETLOCALVOLUMESTATE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSSETLOCALVOLUMESTATE will reply async\n"));
		}
		break;
	}
	case 47: {
		struct srvsvc_NETRDFSSETSERVERINFO *r2 = (struct srvsvc_NETRDFSSETSERVERINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETSERVERINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSSETSERVERINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSSETSERVERINFO will reply async\n"));
		}
		break;
	}
	case 48: {
		struct srvsvc_NETRDFSCREATEEXITPOINT *r2 = (struct srvsvc_NETRDFSCREATEEXITPOINT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATEEXITPOINT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSCREATEEXITPOINT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSCREATEEXITPOINT will reply async\n"));
		}
		break;
	}
	case 49: {
		struct srvsvc_NETRDFSDELETEEXITPOINT *r2 = (struct srvsvc_NETRDFSDELETEEXITPOINT *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETEEXITPOINT, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSDELETEEXITPOINT(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSDELETEEXITPOINT will reply async\n"));
		}
		break;
	}
	case 50: {
		struct srvsvc_NETRDFSMODIFYPREFIX *r2 = (struct srvsvc_NETRDFSMODIFYPREFIX *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMODIFYPREFIX, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSMODIFYPREFIX(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSMODIFYPREFIX will reply async\n"));
		}
		break;
	}
	case 51: {
		struct srvsvc_NETRDFSFIXLOCALVOLUME *r2 = (struct srvsvc_NETRDFSFIXLOCALVOLUME *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSFIXLOCALVOLUME, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSFIXLOCALVOLUME(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSFIXLOCALVOLUME will reply async\n"));
		}
		break;
	}
	case 52: {
		struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r2 = (struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMANAGERREPORTSITEINFO, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRDFSMANAGERREPORTSITEINFO(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSMANAGERREPORTSITEINFO will reply async\n"));
		}
		break;
	}
	case 53: {
		struct srvsvc_NETRSERVERTRANSPORTDELEX *r2 = (struct srvsvc_NETRSERVERTRANSPORTDELEX *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRSERVERTRANSPORTDELEX, NDR_IN, r2);
		}
		r2->out.result = dcesrv_srvsvc_NETRSERVERTRANSPORTDELEX(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRSERVERTRANSPORTDELEX will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_srvsvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS srvsvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct srvsvc_NetCharDevEnum *r2 = (struct srvsvc_NetCharDevEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct srvsvc_NetCharDevGetInfo *r2 = (struct srvsvc_NetCharDevGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct srvsvc_NetCharDevControl *r2 = (struct srvsvc_NetCharDevControl *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevControl replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevControl, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevControl\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct srvsvc_NetCharDevQEnum *r2 = (struct srvsvc_NetCharDevQEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevQEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct srvsvc_NetCharDevQGetInfo *r2 = (struct srvsvc_NetCharDevQGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevQGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct srvsvc_NetCharDevQSetInfo *r2 = (struct srvsvc_NetCharDevQSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevQSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct srvsvc_NetCharDevQPurge *r2 = (struct srvsvc_NetCharDevQPurge *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQPurge replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurge, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevQPurge\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct srvsvc_NetCharDevQPurgeSelf *r2 = (struct srvsvc_NetCharDevQPurgeSelf *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetCharDevQPurgeSelf replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetCharDevQPurgeSelf, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetCharDevQPurgeSelf\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct srvsvc_NetConnEnum *r2 = (struct srvsvc_NetConnEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetConnEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetConnEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetConnEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct srvsvc_NetFileEnum *r2 = (struct srvsvc_NetFileEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetFileEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct srvsvc_NetFileGetInfo *r2 = (struct srvsvc_NetFileGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetFileGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct srvsvc_NetFileClose *r2 = (struct srvsvc_NetFileClose *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetFileClose replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetFileClose, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetFileClose\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct srvsvc_NetSessEnum *r2 = (struct srvsvc_NetSessEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSessEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetSessEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct srvsvc_NetSessDel *r2 = (struct srvsvc_NetSessDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSessDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSessDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetSessDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct srvsvc_NetShareAdd *r2 = (struct srvsvc_NetShareAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct srvsvc_NetShareEnumAll *r2 = (struct srvsvc_NetShareEnumAll *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareEnumAll replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnumAll, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareEnumAll\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct srvsvc_NetShareGetInfo *r2 = (struct srvsvc_NetShareGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct srvsvc_NetShareSetInfo *r2 = (struct srvsvc_NetShareSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct srvsvc_NetShareDel *r2 = (struct srvsvc_NetShareDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct srvsvc_NetShareDelSticky *r2 = (struct srvsvc_NetShareDelSticky *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelSticky replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelSticky, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareDelSticky\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct srvsvc_NetShareCheck *r2 = (struct srvsvc_NetShareCheck *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareCheck replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareCheck, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareCheck\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct srvsvc_NetSrvGetInfo *r2 = (struct srvsvc_NetSrvGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSrvGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetSrvGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct srvsvc_NetSrvSetInfo *r2 = (struct srvsvc_NetSrvSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSrvSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSrvSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetSrvSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct srvsvc_NetDiskEnum *r2 = (struct srvsvc_NetDiskEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetDiskEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetDiskEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetDiskEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct srvsvc_NetServerStatisticsGet *r2 = (struct srvsvc_NetServerStatisticsGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerStatisticsGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerStatisticsGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetServerStatisticsGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 25: {
		struct srvsvc_NetTransportAdd *r2 = (struct srvsvc_NetTransportAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetTransportAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 26: {
		struct srvsvc_NetTransportEnum *r2 = (struct srvsvc_NetTransportEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetTransportEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 27: {
		struct srvsvc_NetTransportDel *r2 = (struct srvsvc_NetTransportDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetTransportDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetTransportDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetTransportDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 28: {
		struct srvsvc_NetRemoteTOD *r2 = (struct srvsvc_NetRemoteTOD *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetRemoteTOD replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetRemoteTOD, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetRemoteTOD\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 29: {
		struct srvsvc_NetSetServiceBits *r2 = (struct srvsvc_NetSetServiceBits *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSetServiceBits replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetServiceBits, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetSetServiceBits\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 30: {
		struct srvsvc_NetPathType *r2 = (struct srvsvc_NetPathType *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathType replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathType, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetPathType\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 31: {
		struct srvsvc_NetPathCanonicalize *r2 = (struct srvsvc_NetPathCanonicalize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathCanonicalize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCanonicalize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetPathCanonicalize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 32: {
		struct srvsvc_NetPathCompare *r2 = (struct srvsvc_NetPathCompare *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPathCompare replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPathCompare, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetPathCompare\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 33: {
		struct srvsvc_NetNameValidate *r2 = (struct srvsvc_NetNameValidate *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetNameValidate replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetNameValidate, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetNameValidate\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 34: {
		struct srvsvc_NETRPRNAMECANONICALIZE *r2 = (struct srvsvc_NETRPRNAMECANONICALIZE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRPRNAMECANONICALIZE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRPRNAMECANONICALIZE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRPRNAMECANONICALIZE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 35: {
		struct srvsvc_NetPRNameCompare *r2 = (struct srvsvc_NetPRNameCompare *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetPRNameCompare replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetPRNameCompare, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetPRNameCompare\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 36: {
		struct srvsvc_NetShareEnum *r2 = (struct srvsvc_NetShareEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 37: {
		struct srvsvc_NetShareDelStart *r2 = (struct srvsvc_NetShareDelStart *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelStart replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelStart, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareDelStart\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 38: {
		struct srvsvc_NetShareDelCommit *r2 = (struct srvsvc_NetShareDelCommit *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetShareDelCommit replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetShareDelCommit, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetShareDelCommit\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 39: {
		struct srvsvc_NetGetFileSecurity *r2 = (struct srvsvc_NetGetFileSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetGetFileSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetGetFileSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetGetFileSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 40: {
		struct srvsvc_NetSetFileSecurity *r2 = (struct srvsvc_NetSetFileSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetSetFileSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetSetFileSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetSetFileSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 41: {
		struct srvsvc_NetServerTransportAddEx *r2 = (struct srvsvc_NetServerTransportAddEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerTransportAddEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerTransportAddEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetServerTransportAddEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 42: {
		struct srvsvc_NetServerSetServiceBitsEx *r2 = (struct srvsvc_NetServerSetServiceBitsEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NetServerSetServiceBitsEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NetServerSetServiceBitsEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NetServerSetServiceBitsEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 43: {
		struct srvsvc_NETRDFSGETVERSION *r2 = (struct srvsvc_NETRDFSGETVERSION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSGETVERSION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSGETVERSION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSGETVERSION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 44: {
		struct srvsvc_NETRDFSCREATELOCALPARTITION *r2 = (struct srvsvc_NETRDFSCREATELOCALPARTITION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSCREATELOCALPARTITION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATELOCALPARTITION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSCREATELOCALPARTITION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 45: {
		struct srvsvc_NETRDFSDELETELOCALPARTITION *r2 = (struct srvsvc_NETRDFSDELETELOCALPARTITION *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSDELETELOCALPARTITION replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETELOCALPARTITION, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSDELETELOCALPARTITION\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 46: {
		struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *r2 = (struct srvsvc_NETRDFSSETLOCALVOLUMESTATE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSSETLOCALVOLUMESTATE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETLOCALVOLUMESTATE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSSETLOCALVOLUMESTATE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 47: {
		struct srvsvc_NETRDFSSETSERVERINFO *r2 = (struct srvsvc_NETRDFSSETSERVERINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSSETSERVERINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSSETSERVERINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSSETSERVERINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 48: {
		struct srvsvc_NETRDFSCREATEEXITPOINT *r2 = (struct srvsvc_NETRDFSCREATEEXITPOINT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSCREATEEXITPOINT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSCREATEEXITPOINT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSCREATEEXITPOINT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 49: {
		struct srvsvc_NETRDFSDELETEEXITPOINT *r2 = (struct srvsvc_NETRDFSDELETEEXITPOINT *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSDELETEEXITPOINT replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSDELETEEXITPOINT, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSDELETEEXITPOINT\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 50: {
		struct srvsvc_NETRDFSMODIFYPREFIX *r2 = (struct srvsvc_NETRDFSMODIFYPREFIX *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSMODIFYPREFIX replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMODIFYPREFIX, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSMODIFYPREFIX\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 51: {
		struct srvsvc_NETRDFSFIXLOCALVOLUME *r2 = (struct srvsvc_NETRDFSFIXLOCALVOLUME *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSFIXLOCALVOLUME replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSFIXLOCALVOLUME, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSFIXLOCALVOLUME\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 52: {
		struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *r2 = (struct srvsvc_NETRDFSMANAGERREPORTSITEINFO *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRDFSMANAGERREPORTSITEINFO replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRDFSMANAGERREPORTSITEINFO, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRDFSMANAGERREPORTSITEINFO\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 53: {
		struct srvsvc_NETRSERVERTRANSPORTDELEX *r2 = (struct srvsvc_NETRSERVERTRANSPORTDELEX *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function srvsvc_NETRSERVERTRANSPORTDELEX replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(srvsvc_NETRSERVERTRANSPORTDELEX, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in srvsvc_NETRSERVERTRANSPORTDELEX\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_srvsvc, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS srvsvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_srvsvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_srvsvc_interface = {
	.name		= "srvsvc",
	.syntax_id  = {{0x4b324fc8,0x1670,0x01d3,{0x12,0x78},{0x5a,0x47,0xbf,0x6e,0xe1,0x88}},3.0},
	.bind		= srvsvc__op_bind,
	.unbind		= srvsvc__op_unbind,
	.ndr_pull	= srvsvc__op_ndr_pull,
	.dispatch	= srvsvc__op_dispatch,
	.reply		= srvsvc__op_reply,
	.ndr_push	= srvsvc__op_ndr_push
};


static NTSTATUS srvsvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_srvsvc.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_srvsvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_srvsvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("srvsvc_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool srvsvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_srvsvc_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_srvsvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_srvsvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool srvsvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_srvsvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_srvsvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_srvsvc_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "srvsvc";

	/* fill in all the operations */
	ep_server.init_server = srvsvc__op_init_server;

	ep_server.interface_by_uuid = srvsvc__op_interface_by_uuid;
	ep_server.interface_by_name = srvsvc__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'srvsvc' endpoint server!\n"));
		return ret;
	}

	return ret;
}

