#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-08-19 10:00:11 
# conf/config-smbconf.sh

### P A R A M S

MYNOSHARES=
if [ "$1" = "-noshares" ]; then
	MYNOSHARES="$1"
	shift
fi
MYREALM="$1"
MYDOMAIN="$2"
MYSERVER="$3"
MYADMIN="$4"
MYUSERS="$5"
MYHOSTALLOW="$6"
MYWINSSERVER="$7"

MYSEP='/'
MYUSEDEFAULTDOMAIN='yes'

### I N C L U D E S
. ./_include.sh

### M O D W H E T H E R   T O I E D   F I L E S ...
smbconffile=smb.conf
usermapconffile=user.map
datafolder=/data

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_MOD=644

### S T A R T

# D E T E R M I N E   S A M B A   V E R S I O N   F O R   S M B . C O N F   S Y N T A X
echo "+get current samba version for smb.conf syntax"
sambapkg="${SAMBAPKG}"
sambaversion=`${PACKAGEVERSION} ${sambapkg} | sed 's/^[^:]://'`
sambamajorversion=`echo "${sambaversion}" | sed 's/^\([0-9]\).*$/\1/g'`
sambaminorversion=`echo "${sambaversion}" | sed 's/^[0-9]*\.[0-9]*\.\([0-9]*\).*$/\1/g'`
echo "samba minor version is ${sambaminorversion}"

echo "+samba config switches"

# D E T E R M I N E   W H E T H E R   T O   U S E   I D M A P - R I D
useidmaprid=';'
useidmaprid2=';'
#if [ -d "${SAMBALIBDIR}" -a -e ${SAMBALIBDIR}/idmap/rid.so ];then
if ${PACKAGEHASFILE} ${RIDPACKAGE} 'rid.so';then
	if (( $((sambaminorversion)) < 25 )); then
		useidmaprid=' '
		useidmaprid2=';'
		echo "map id from rids using old syntax"
	else
		useidmaprid=';'
		useidmaprid2=' '
		echo "map id from rids using new syntax"
	fi
fi

# D E T E R M I N E   W H E T H E R   T O   W I N S   I S   E N A B L E D
usewins=';'
if [ "${MYWINSSERVER}" != "" ];then
	usewins=" "
	echo "use wins server"
fi

# D E T E R M I N E   W H E T H E R   T O   U S E   S H A R E S
conffiles="_smb.conf"
if [ -z "${MYNOSHARES}" ];then
	echo "include sample shares"
	conffiles="${conffiles} _shares.conf"
fi

# C U S T O M I Z E   S M B . C O N F
echo "+customize ${smbconffile}"
awkp='{
   	gsub("%REALM%","'${MYREALM}'");
	gsub("%DOMAIN%","'${MYDOMAIN}'");
	gsub("%SERVER%","'${MYSERVER}'");
	gsub("%ADMIN%","'"${MYADMIN}"'");
	gsub("%USERS%","'"${MYUSERS}"'");
	gsub("%HOSTALLOW%","'"${MYHOSTALLOW}"'");
	gsub("%WINSSERVER%","'"${MYWINSSERVER}"'");
	gsub("%SEP%","'"${MYSEP}"'");
	gsub("%USEDEFAULTDOMAIN%","'"${MYUSEDEFAULTDOMAIN}"'");
	gsub("%USEWINS%","'"${usewins}"'");
	gsub("%USEIDMAPRID%","'"${useidmaprid}"'");
	gsub("%USEIDMAPRID2%","'"${useidmaprid2}"'");
	print}'
cat ${conffiles} | awk "$awkp" - > ${TMPDIR}/${smbconffile}
#cat ${TMPDIR}/${smbconffile} | grep -v "^#" | grep -v "^;" | grep -v "^$"

echo "install new ${smbconffile} to ${SAMBADIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${smbconffile} ${SAMBADIR} > /dev/null

# C U S T O M I Z E   U S E R M A P
echo "+customize ${usermapconffile}"
awkp='{
	gsub("%DOMAIN%","'${MYDOMAIN}'");
	gsub("%ADMIN%","'"${MYADMIN}"'");
	gsub("%USERS%","'"${MYUSERS}"'");
	gsub("%SEP%","'"${MYSEP}"'");
	print}'
awk "${awkp}" _${usermapconffile} > ${TMPDIR}/${usermapconffile}
#cat ${TMPDIR}/${usermapconffile} | grep -v "^#" | grep -v "^;" | grep -v "^$"
echo "install new ${usermapconffile} to ${SAMBADIR}"
${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_MOD} ${TMPDIR}/${usermapconffile} ${SAMBADIR} > /dev/null

# C L E A N U P
rm -f ${TMPDIR}/${smbconffile}
rm -f ${TMPDIR}/${usermapconffile}

# D A T A   S H A R E
if [ -z "${MYNOSHARES}" ];then
	echo "+creating sample data folder in ${datafolder} shared as data"
	[ -d ${datafolder} ] || mkdir -p ${datafolder}
	chown root.root ${datafolder}
	chmod 777 ${datafolder}
	touch ${datafolder}/._sadms_
	chmod ugo=r ${datafolder}/._sadms_
	touch /home/._sadms_
fi

# S T A T U S
[ -d /var/lib/sadms ] || mkdir -p /var/lib/sadms
echo '1' > /var/lib/sadms/smb

# T E S T
testparm -sv > /dev/null 2>&1
if [ "$?" != "0" ]; then
	echo "testparm signalled error" >&2 
	testparm -sv >&2 
fi
exit $?
