/* rygel-video-item.c generated by valac 0.16.1, the Vala compiler
 * generated from rygel-video-item.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gst/gst.h>
#include <rygel-core.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_SUBTITLE_MANAGER (rygel_subtitle_manager_get_type ())
#define RYGEL_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManager))
#define RYGEL_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))
#define RYGEL_IS_SUBTITLE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_IS_SUBTITLE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE_MANAGER))
#define RYGEL_SUBTITLE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE_MANAGER, RygelSubtitleManagerClass))

typedef struct _RygelSubtitleManager RygelSubtitleManager;
typedef struct _RygelSubtitleManagerClass RygelSubtitleManagerClass;
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self, const gchar* host_ip);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelVideoItem {
	RygelAudioItem parent_instance;
	RygelVideoItemPrivate * priv;
	gchar* author;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelAudioItemClass parent_class;
};

struct _RygelVideoItemPrivate {
	gint _width;
	gint _height;
	gint _pixel_width;
	gint _pixel_height;
	gint _color_depth;
	GeeArrayList* _thumbnails;
};

struct _RygelSubtitle {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSubtitlePrivate * priv;
	gchar* uri;
	gchar* mime_type;
	gchar* caption_type;
	gint64 size;
};

struct _RygelSubtitleClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSubtitle *self);
};


static gpointer rygel_video_item_parent_class = NULL;
static RygelVisualItemIface* rygel_video_item_rygel_visual_item_parent_iface = NULL;

GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
gpointer rygel_subtitle_ref (gpointer instance);
void rygel_subtitle_unref (gpointer instance);
GParamSpec* rygel_param_spec_subtitle (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_subtitle (GValue* value, gpointer v_object);
void rygel_value_take_subtitle (GValue* value, gpointer v_object);
gpointer rygel_value_get_subtitle (const GValue* value);
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
#define RYGEL_VIDEO_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemPrivate))
enum  {
	RYGEL_VIDEO_ITEM_DUMMY_PROPERTY,
	RYGEL_VIDEO_ITEM_WIDTH,
	RYGEL_VIDEO_ITEM_HEIGHT,
	RYGEL_VIDEO_ITEM_PIXEL_WIDTH,
	RYGEL_VIDEO_ITEM_PIXEL_HEIGHT,
	RYGEL_VIDEO_ITEM_COLOR_DEPTH,
	RYGEL_VIDEO_ITEM_THUMBNAILS
};
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
RygelAudioItem* rygel_audio_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class);
void rygel_visual_item_set_thumbnails (RygelVisualItem* self, GeeArrayList* value);
static gboolean rygel_video_item_real_streamable (RygelMediaItem* base);
static void rygel_video_item_real_add_uri (RygelMediaItem* base, const gchar* uri);
void rygel_media_item_add_uri (RygelMediaItem* self, const gchar* uri);
void rygel_visual_item_add_thumbnail_for_uri (RygelVisualItem* self, const gchar* uri, const gchar* mime_type);
GType rygel_subtitle_manager_get_type (void) G_GNUC_CONST;
RygelSubtitleManager* rygel_subtitle_manager_get_default (void);
RygelSubtitle* rygel_subtitle_manager_get_subtitle (RygelSubtitleManager* self, const gchar* uri, GError** error);
static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
gchar* rygel_media_item_get_protocol_for_uri (RygelMediaItem* self, const gchar* uri, GError** error);
void rygel_subtitle_add_didl_node (RygelSubtitle* self, GUPnPDIDLLiteItem* didl_item);
void rygel_media_item_add_resources (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
void rygel_visual_item_add_thumbnail_resources (RygelVisualItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
void rygel_visual_item_add_visual_props (RygelVisualItem* self, GUPnPDIDLLiteResource* res);
static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property);
gint rygel_media_object_compare_string_props (RygelMediaObject* self, const gchar* prop1, const gchar* prop2);
gint rygel_media_object_compare_by_property (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
GUPnPDIDLLiteObject* rygel_media_object_serialize (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
gboolean rygel_media_item_get_place_holder (RygelMediaItem* self);
gboolean rygel_http_server_need_proxy (RygelHTTPServer* self, const gchar* uri);
gchar* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_media_item_add_proxy_resources (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
void rygel_visual_item_add_thumbnail_proxy_resources (RygelVisualItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
static void rygel_video_item_finalize (GObject* obj);
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
gint rygel_visual_item_get_color_depth (RygelVisualItem* self);
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void rygel_visual_item_set_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_width (RygelVisualItem* self, gint value);
void rygel_visual_item_set_pixel_height (RygelVisualItem* self, gint value);
void rygel_visual_item_set_color_depth (RygelVisualItem* self, gint value);
static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


RygelVideoItem* rygel_video_item_construct (GType object_type, const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	RygelVideoItem * self = NULL;
	const gchar* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (upnp_class != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = title;
	_tmp3_ = upnp_class;
	self = (RygelVideoItem*) rygel_audio_item_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_THUMBNAIL, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, NULL);
	_tmp5_ = _tmp4_;
	rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = gee_array_list_new (RYGEL_TYPE_SUBTITLE, (GBoxedCopyFunc) rygel_subtitle_ref, rygel_subtitle_unref, NULL);
	_g_object_unref0 (self->subtitles);
	self->subtitles = _tmp6_;
	return self;
}


RygelVideoItem* rygel_video_item_new (const gchar* id, RygelMediaContainer* parent, const gchar* title, const gchar* upnp_class) {
	return rygel_video_item_construct (RYGEL_TYPE_VIDEO_ITEM, id, parent, title, upnp_class);
}


static gboolean rygel_video_item_real_streamable (RygelMediaItem* base) {
	RygelVideoItem * self;
	gboolean result = FALSE;
	self = (RygelVideoItem*) base;
	result = TRUE;
	return result;
}


static void rygel_video_item_real_add_uri (RygelMediaItem* base, const gchar* uri) {
	RygelVideoItem * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelSubtitleManager* _tmp3_ = NULL;
	RygelSubtitleManager* subtitle_manager;
	RygelSubtitleManager* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_uri ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), _tmp0_);
	_tmp1_ = uri;
	_tmp2_ = ((RygelMediaItem*) self)->mime_type;
	rygel_visual_item_add_thumbnail_for_uri ((RygelVisualItem*) self, _tmp1_, _tmp2_);
	_tmp3_ = rygel_subtitle_manager_get_default ();
	subtitle_manager = _tmp3_;
	_tmp4_ = subtitle_manager;
	if (_tmp4_ != NULL) {
		{
			RygelSubtitleManager* _tmp5_;
			const gchar* _tmp6_;
			RygelSubtitle* _tmp7_ = NULL;
			RygelSubtitle* subtitle;
			GeeArrayList* _tmp8_;
			RygelSubtitle* _tmp9_;
			_tmp5_ = subtitle_manager;
			_tmp6_ = uri;
			_tmp7_ = rygel_subtitle_manager_get_subtitle (_tmp5_, _tmp6_, &_inner_error_);
			subtitle = _tmp7_;
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
			_tmp8_ = self->subtitles;
			_tmp9_ = subtitle;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
			_rygel_subtitle_unref0 (subtitle);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* err = NULL;
			err = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (err);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (subtitle_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (subtitle_manager);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_video_item_real_add_resources (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteItem* _tmp20_;
	gboolean _tmp21_;
	GUPnPDIDLLiteItem* _tmp22_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (didl_item != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _subtitle_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _subtitle_size;
		gint _subtitle_index;
		_tmp0_ = self->subtitles;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_subtitle_list = _tmp1_;
		_tmp2_ = _subtitle_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_subtitle_size = _tmp4_;
		_subtitle_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			RygelSubtitle* subtitle;
			RygelSubtitle* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* protocol;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_;
			gboolean _tmp17_;
			_tmp5_ = _subtitle_index;
			_subtitle_index = _tmp5_ + 1;
			_tmp6_ = _subtitle_index;
			_tmp7_ = _subtitle_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _subtitle_list;
			_tmp9_ = _subtitle_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			subtitle = (RygelSubtitle*) _tmp10_;
			_tmp11_ = subtitle;
			_tmp12_ = _tmp11_->uri;
			_tmp13_ = rygel_media_item_get_protocol_for_uri ((RygelMediaItem*) self, _tmp12_, &_inner_error_);
			protocol = _tmp13_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_rygel_subtitle_unref0 (subtitle);
				_g_object_unref0 (_subtitle_list);
				return;
			}
			_tmp15_ = allow_internal;
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = protocol;
				_tmp14_ = g_strcmp0 (_tmp16_, "internal") != 0;
			}
			_tmp17_ = _tmp14_;
			if (_tmp17_) {
				RygelSubtitle* _tmp18_;
				GUPnPDIDLLiteItem* _tmp19_;
				_tmp18_ = subtitle;
				_tmp19_ = didl_item;
				rygel_subtitle_add_didl_node (_tmp18_, _tmp19_);
			}
			_g_free0 (protocol);
			_rygel_subtitle_unref0 (subtitle);
		}
		_g_object_unref0 (_subtitle_list);
	}
	_tmp20_ = didl_item;
	_tmp21_ = allow_internal;
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), _tmp20_, _tmp21_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp22_ = didl_item;
	_tmp23_ = allow_internal;
	rygel_visual_item_add_thumbnail_resources ((RygelVisualItem*) self, _tmp22_, _tmp23_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static GUPnPDIDLLiteResource* rygel_video_item_real_add_resource (RygelMediaItem* base, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GUPnPDIDLLiteResource* _tmp4_ = NULL;
	GUPnPDIDLLiteResource* res;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (didl_item != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	_tmp0_ = didl_item;
	_tmp1_ = uri;
	_tmp2_ = protocol;
	_tmp3_ = import_uri;
	_tmp4_ = RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_resource ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), _tmp0_, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
	res = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	rygel_visual_item_add_visual_props ((RygelVisualItem*) self, res);
	result = res;
	return result;
}


static gint rygel_video_item_real_compare_by_property (RygelMediaObject* base, RygelMediaObject* media_object, const gchar* property) {
	RygelVideoItem * self;
	gint result = 0;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* _tmp1_;
	RygelVideoItem* _tmp2_;
	RygelVideoItem* item;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (media_object != NULL, 0);
	g_return_val_if_fail (property != NULL, 0);
	_tmp0_ = media_object;
	if (!RYGEL_IS_VIDEO_ITEM (_tmp0_)) {
		result = 1;
		return result;
	}
	_tmp1_ = media_object;
	_tmp2_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp1_) ? ((RygelVideoItem*) _tmp1_) : NULL);
	item = _tmp2_;
	_tmp3_ = property;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("dc:author")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				RygelVideoItem* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_ = 0;
				_tmp7_ = self->author;
				_tmp8_ = item;
				_tmp9_ = _tmp8_->author;
				_tmp10_ = rygel_media_object_compare_string_props ((RygelMediaObject*) self, _tmp7_, _tmp9_);
				result = _tmp10_;
				_g_object_unref0 (item);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				RygelVideoItem* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_ = 0;
				_tmp11_ = item;
				_tmp12_ = property;
				_tmp13_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->compare_by_property ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), (RygelMediaObject*) _tmp11_, _tmp12_);
				result = _tmp13_;
				_g_object_unref0 (item);
				return result;
			}
		}
	}
	_g_object_unref0 (item);
}


static GUPnPDIDLLiteObject* rygel_video_item_real_serialize (RygelMediaObject* base, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error) {
	RygelVideoItem * self;
	GUPnPDIDLLiteObject* result = NULL;
	GUPnPDIDLLiteWriter* _tmp0_;
	RygelHTTPServer* _tmp1_;
	GUPnPDIDLLiteObject* _tmp2_ = NULL;
	GUPnPDIDLLiteObject* didl_item;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_val_if_fail (writer != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	_tmp0_ = writer;
	_tmp1_ = http_server;
	_tmp2_ = RYGEL_MEDIA_OBJECT_CLASS (rygel_video_item_parent_class)->serialize ((RygelMediaObject*) RYGEL_AUDIO_ITEM (self), _tmp0_, _tmp1_, &_inner_error_);
	didl_item = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = self->author;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = self->author;
		_tmp3_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		GUPnPDIDLLiteContributor* _tmp7_ = NULL;
		GUPnPDIDLLiteContributor* contributor;
		GUPnPDIDLLiteContributor* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = gupnp_didl_lite_object_add_author (didl_item);
		contributor = _tmp7_;
		_tmp8_ = contributor;
		_tmp9_ = self->author;
		gupnp_didl_lite_contributor_set_name (_tmp8_, _tmp9_);
		_g_object_unref0 (contributor);
	}
	result = didl_item;
	return result;
}


static void rygel_video_item_real_add_proxy_resources (RygelMediaItem* base, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error) {
	RygelVideoItem * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	RygelHTTPServer* _tmp32_;
	GUPnPDIDLLiteItem* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	GError * _inner_error_ = NULL;
	self = (RygelVideoItem*) base;
	g_return_if_fail (server != NULL);
	g_return_if_fail (didl_item != NULL);
	_tmp0_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		{
			GeeArrayList* _tmp2_;
			GeeArrayList* _tmp3_;
			GeeArrayList* _subtitle_list;
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _subtitle_size;
			gint _subtitle_index;
			_tmp2_ = self->subtitles;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			_subtitle_list = _tmp3_;
			_tmp4_ = _subtitle_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_subtitle_size = _tmp6_;
			_subtitle_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_ = NULL;
				RygelSubtitle* subtitle;
				RygelHTTPServer* _tmp13_;
				RygelSubtitle* _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				RygelSubtitle* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* uri;
				GeeArrayList* _tmp20_;
				RygelSubtitle* _tmp21_;
				gint _tmp22_ = 0;
				gint index;
				RygelSubtitle* _tmp23_;
				RygelHTTPServer* _tmp24_;
				gint _tmp25_;
				gchar* _tmp26_ = NULL;
				RygelSubtitle* _tmp27_;
				GUPnPDIDLLiteItem* _tmp28_;
				RygelSubtitle* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp7_ = _subtitle_index;
				_subtitle_index = _tmp7_ + 1;
				_tmp8_ = _subtitle_index;
				_tmp9_ = _subtitle_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _subtitle_list;
				_tmp11_ = _subtitle_index;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
				subtitle = (RygelSubtitle*) _tmp12_;
				_tmp13_ = server;
				_tmp14_ = subtitle;
				_tmp15_ = _tmp14_->uri;
				_tmp16_ = rygel_http_server_need_proxy (_tmp13_, _tmp15_);
				if (!_tmp16_) {
					_rygel_subtitle_unref0 (subtitle);
					continue;
				}
				_tmp17_ = subtitle;
				_tmp18_ = _tmp17_->uri;
				_tmp19_ = g_strdup (_tmp18_);
				uri = _tmp19_;
				_tmp20_ = self->subtitles;
				_tmp21_ = subtitle;
				_tmp22_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp20_, _tmp21_);
				index = _tmp22_;
				_tmp23_ = subtitle;
				_tmp24_ = server;
				_tmp25_ = index;
				_tmp26_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) _tmp24_, (RygelMediaItem*) self, -1, _tmp25_, NULL);
				_g_free0 (_tmp23_->uri);
				_tmp23_->uri = _tmp26_;
				_tmp27_ = subtitle;
				_tmp28_ = didl_item;
				rygel_subtitle_add_didl_node (_tmp27_, _tmp28_);
				_tmp29_ = subtitle;
				_tmp30_ = uri;
				_tmp31_ = g_strdup (_tmp30_);
				_g_free0 (_tmp29_->uri);
				_tmp29_->uri = _tmp31_;
				_g_free0 (uri);
				_rygel_subtitle_unref0 (subtitle);
			}
			_g_object_unref0 (_subtitle_list);
		}
	}
	_tmp32_ = server;
	_tmp33_ = didl_item;
	RYGEL_MEDIA_ITEM_CLASS (rygel_video_item_parent_class)->add_proxy_resources ((RygelMediaItem*) RYGEL_AUDIO_ITEM (self), _tmp32_, _tmp33_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp34_ = rygel_media_item_get_place_holder ((RygelMediaItem*) self);
	_tmp35_ = _tmp34_;
	if (!_tmp35_) {
		RygelHTTPServer* _tmp36_;
		GUPnPDIDLLiteItem* _tmp37_;
		_tmp36_ = server;
		_tmp37_ = didl_item;
		rygel_visual_item_add_thumbnail_proxy_resources ((RygelVisualItem*) self, _tmp36_, _tmp37_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static gint rygel_video_item_real_get_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_width;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_width = _tmp0_;
	g_object_notify ((GObject *) self, "width");
}


static gint rygel_video_item_real_get_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_height;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_height = _tmp0_;
	g_object_notify ((GObject *) self, "height");
}


static gint rygel_video_item_real_get_pixel_width (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_pixel_width;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_pixel_width (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_pixel_width = _tmp0_;
	g_object_notify ((GObject *) self, "pixel-width");
}


static gint rygel_video_item_real_get_pixel_height (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_pixel_height;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_pixel_height (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_pixel_height = _tmp0_;
	g_object_notify ((GObject *) self, "pixel-height");
}


static gint rygel_video_item_real_get_color_depth (RygelVisualItem* base) {
	gint result;
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_color_depth;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_color_depth (RygelVisualItem* base, gint value) {
	RygelVideoItem* self;
	gint _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	self->priv->_color_depth = _tmp0_;
	g_object_notify ((GObject *) self, "color-depth");
}


static GeeArrayList* rygel_video_item_real_get_thumbnails (RygelVisualItem* base) {
	GeeArrayList* result;
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	self = (RygelVideoItem*) base;
	_tmp0_ = self->priv->_thumbnails;
	result = _tmp0_;
	return result;
}


static void rygel_video_item_real_set_thumbnails (RygelVisualItem* base, GeeArrayList* value) {
	RygelVideoItem* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	self = (RygelVideoItem*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_thumbnails);
	self->priv->_thumbnails = _tmp1_;
	g_object_notify ((GObject *) self, "thumbnails");
}


static void rygel_video_item_class_init (RygelVideoItemClass * klass) {
	rygel_video_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelVideoItemPrivate));
	RYGEL_MEDIA_ITEM_CLASS (klass)->streamable = rygel_video_item_real_streamable;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_uri = rygel_video_item_real_add_uri;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resources = rygel_video_item_real_add_resources;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_resource = rygel_video_item_real_add_resource;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->compare_by_property = rygel_video_item_real_compare_by_property;
	RYGEL_MEDIA_OBJECT_CLASS (klass)->serialize = rygel_video_item_real_serialize;
	RYGEL_MEDIA_ITEM_CLASS (klass)->add_proxy_resources = rygel_video_item_real_add_proxy_resources;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_video_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_video_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_video_item_finalize;
	/**
	     * The width of the item in pixels.
	     * A value of -1 means that the width is unknown and will not, or did not, appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The height of the item in pixels.
	     * A value of -1 means that the height is unknown and will not, or did not, appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_PIXEL_WIDTH, g_param_spec_int ("pixel-width", "pixel-width", "pixel-width", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_PIXEL_HEIGHT, g_param_spec_int ("pixel-height", "pixel-height", "pixel-height", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The number of bits per pixel used to represent the video resource.
	     * A value of -1 means that the color depth is unknown and will not, or did not, appear in DIDL-Lite XML.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_COLOR_DEPTH, g_param_spec_int ("color-depth", "color-depth", "color-depth", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_VIDEO_ITEM_THUMBNAILS, g_param_spec_object ("thumbnails", "thumbnails", "thumbnails", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_video_item_rygel_visual_item_interface_init (RygelVisualItemIface * iface) {
	rygel_video_item_rygel_visual_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_width = rygel_video_item_real_get_width;
	iface->set_width = rygel_video_item_real_set_width;
	iface->get_height = rygel_video_item_real_get_height;
	iface->set_height = rygel_video_item_real_set_height;
	iface->get_pixel_width = rygel_video_item_real_get_pixel_width;
	iface->set_pixel_width = rygel_video_item_real_set_pixel_width;
	iface->get_pixel_height = rygel_video_item_real_get_pixel_height;
	iface->set_pixel_height = rygel_video_item_real_set_pixel_height;
	iface->get_color_depth = rygel_video_item_real_get_color_depth;
	iface->set_color_depth = rygel_video_item_real_set_color_depth;
	iface->get_thumbnails = rygel_video_item_real_get_thumbnails;
	iface->set_thumbnails = rygel_video_item_real_set_thumbnails;
}


static void rygel_video_item_instance_init (RygelVideoItem * self) {
	self->priv = RYGEL_VIDEO_ITEM_GET_PRIVATE (self);
	self->priv->_width = -1;
	self->priv->_height = -1;
	self->priv->_pixel_width = -1;
	self->priv->_pixel_height = -1;
	self->priv->_color_depth = -1;
}


static void rygel_video_item_finalize (GObject* obj) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (obj);
	_g_free0 (self->author);
	_g_object_unref0 (self->priv->_thumbnails);
	_g_object_unref0 (self->subtitles);
	G_OBJECT_CLASS (rygel_video_item_parent_class)->finalize (obj);
}


/**
 * Represents a video item.
 */
GType rygel_video_item_get_type (void) {
	static volatile gsize rygel_video_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_video_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelVideoItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_video_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelVideoItem), 0, (GInstanceInitFunc) rygel_video_item_instance_init, NULL };
		static const GInterfaceInfo rygel_visual_item_info = { (GInterfaceInitFunc) rygel_video_item_rygel_visual_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_video_item_type_id;
		rygel_video_item_type_id = g_type_register_static (RYGEL_TYPE_AUDIO_ITEM, "RygelVideoItem", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_video_item_type_id, RYGEL_TYPE_VISUAL_ITEM, &rygel_visual_item_info);
		g_once_init_leave (&rygel_video_item_type_id__volatile, rygel_video_item_type_id);
	}
	return rygel_video_item_type_id__volatile;
}


static void _vala_rygel_video_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (object);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_WIDTH:
		g_value_set_int (value, rygel_visual_item_get_pixel_width ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_HEIGHT:
		g_value_set_int (value, rygel_visual_item_get_pixel_height ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
		g_value_set_int (value, rygel_visual_item_get_color_depth ((RygelVisualItem*) self));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
		g_value_set_object (value, rygel_visual_item_get_thumbnails ((RygelVisualItem*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_video_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelVideoItem * self;
	self = RYGEL_VIDEO_ITEM (object);
	switch (property_id) {
		case RYGEL_VIDEO_ITEM_WIDTH:
		rygel_visual_item_set_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_HEIGHT:
		rygel_visual_item_set_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_WIDTH:
		rygel_visual_item_set_pixel_width ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_PIXEL_HEIGHT:
		rygel_visual_item_set_pixel_height ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_COLOR_DEPTH:
		rygel_visual_item_set_color_depth ((RygelVisualItem*) self, g_value_get_int (value));
		break;
		case RYGEL_VIDEO_ITEM_THUMBNAILS:
		rygel_visual_item_set_thumbnails ((RygelVisualItem*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



