/* 
*  Copyright (C) Nicola Fragale <nicolafragale@gmail.com> 
*
*  This program is free software; you can redistribute it and/or modify 
*  it under the terms of the GNU General Public License as published by 
*  the Free Software Foundation; either version 2 of the License, or 
*  (at your option) any later version. 
*
*  This program is distributed in the hope that it will be useful, 
*  but WITHOUT ANY WARRANTY; without even the implied warranty of 
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
*  GNU General Public License for more details. 
*
*  You should have received a copy of the GNU General Public License 
*  along with this program; if not, write to the Free Software 
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
*/ 

#ifndef _CALENDAR_H__
#define _CALENDAR_H__


#include <gtk/gtk.h>
#include <time.h>

G_BEGIN_DECLS


#define RUBRICA_CALENDAR_TYPE           (rubrica_calendar_get_type())

#define RUBRICA_CALENDAR(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                         RUBRICA_CALENDAR_TYPE,            \
                                         RubricaCalendar))

#define RUBRICA_CALENDAR_CLASS(kls)     (G_TYPE_CHECK_CLASS_CAST((kls),    \
                                         RUBRICA_CALENDAR_TYPE,            \
                                         RubricaCalendarClass))

#define IS_RUBRICA_CALENDAR(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                         RUBRICA_CALENDAR_TYPE))

#define IS_RUBRICA_CALENDAR_CLASS(kls)  (G_TYPE_INSTANCE_GET_CLASS((kls),  \
                                         RUBRICA_CALENDAR_TYPE))

#define RUBRICA_CALENDAR_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS(kls),   \
                                         RUBRICA_CALENDAR_TYPE,            \
                                         RubricaCalendarClass)


typedef struct _RubricaCalendar        RubricaCalendar;
typedef struct _RubricaCalendarClass   RubricaCalendarClass;
typedef struct _RubricaCalendarPrivate RubricaCalendarPrivate;


struct _RubricaCalendar 
{
  GtkHBox parent;
  
  RubricaCalendarPrivate* priv;
};


struct _RubricaCalendarClass
{
  GtkHBoxClass parent_class;  

  void (*calendar_change)  (RubricaCalendar *cal, GDate* date);
};


GType      rubrica_calendar_get_type   (void);


GtkWidget* rubrica_calendar_new        (void);

GtkWidget* rubrica_calendar_get_button (RubricaCalendar *cal);

gboolean   rubrica_calendar_has_date   (RubricaCalendar *cal);
GDate*     rubrica_calendar_get_gdate  (RubricaCalendar *cal);
gchar*     rubrica_calendar_get_date   (RubricaCalendar *cal);

void       rubrica_calendar_clean      (RubricaCalendar* cal);

G_END_DECLS

#endif
