/*
 * $Id: openfiles.pike,v 1.10 2003/11/17 16:01:28 anders Exp $
 */
inherit "wizard";

// This file uses stuff from spider...
import spider;

#include <stat.h>
#include <roxen.h>
//<locale-token project="admin_tasks">LOCALE</locale-token>
#define LOCALE(X,Y)	_STR_LOCALE("admin_tasks",X,Y)


constant action="debug_info";


string name= LOCALE(21, "Open files");
string doc = LOCALE(22, 
		    "Show a list of all open files and network connections.");

// Debug functions.  List _all_ open filedescriptors

string fix_port(string p)
{
  array(string) a = p/" ";
  if (a[0] == "0.0.0.0") {
    a[0] = "*";
  }
  if (a[1] == "0") {
    a[1] = "ANY";
  }
  return a * ":";
}

string parse( RequestID id )
{
  return
    ("<font size='+1'><b>" +LOCALE(23, "Active filedescriptors")+ "</b></font>\n"+
     sprintf("<pre><b>%-5s  %-9s  %-10s   %-10s</b>\n\n",
	     "fd", "type", "mode", "details")+

     (Array.map(get_all_active_fd(),
	  lambda(int fd)
	  {
	    object f = Stdio.File(fd);
	    object stat = f->stat();

	    string type = ([
	      "reg":"File",
	      "dir":"Dir",
	      "lnk":"Link",
	      "chr":"Special",
	      "blk":"Device",
	      "fifo":"FIFO",
	      "sock":"Socket",
	      "unknown":"Unknown",
	    ])[stat->type] || "Unknown";

	    // Doors aren't standardized yet...
	    if ((type == "Unknown") &&
		((stat->mode & 0xf000) == 0xd000))
	      type = "Door";

	    string details = "-";

	    if (stat->isreg) {
	      if (stat->size == 1) {
		details = "1 byte";
	      } else {
		details = sprintf("%d bytes", stat->size);
	      }
	      if (stat->ino) {
		details += sprintf(", inode: %d", stat->ino);
	      }
	    } else if (stat->issock) {
	      string remote_port = f->query_address();
	      string local_port = f->query_address(1);
	      if (!remote_port) {
		if (local_port && (local_port != "0.0.0.0 0")) {
		  type = "Port";
		  details = fix_port(local_port);
		}
	      } else {
		details = sprintf("%s &lt;=&gt; %s",
				  local_port?fix_port(local_port):"-",
				  fix_port(remote_port));
	      }
	    }

	    return sprintf("%-5s  %-9s  %-10s   %-12s",
			   (string)fd,
			   type,
			   stat->mode_string,
			   details);
	  })*"\n")+
     "</pre><p><cf-ok/></p>");
}
