// globals

function preprocess () {
  

echo ('  require(ltm)\n');
}

function calculate () {
  
  spin_samples    = getValue("spin_samples");
  chk_standard    = getValue("chk_standard");
  chk_na          = getValue("chk_na");
  chk_bsci        = getValue("chk_bsci");
  spin_ci         = getValue("spin_ci");

  
  
  options = array() ;
  if(chk_standard == "standard")
    options[] = "standardized=TRUE" ;
  if(chk_bsci == "bsci")
    options[] = "CI=TRUE" ;
  if(spin_ci != ".95") {
    cilo = (1-spin_ci)/2 ;
    cihi = 1-cilo ;
    options[] = "probs=c($cilo, $cihi)" ;
    }
  if(spin_samples != "1000")
    options[] = "B=$spin_samples" ;
  if(chk_na == "rm")
    options[] = "na.rm=TRUE" ;


echo ('cronalpha.res <- cronbach.alpha(' + getValue("x"));
                  
                  if(options) echo (", "+join(", ", options));
 echo (')\n');
}

function printout () {
echo ('rk.header ("Cronbach\'s alpha (' + getValue("x") + ')")\n');
echo ('rk.print (cronalpha.res)\n');
}
