# ifndef _RHEO_CATCHMARK_H
# define _RHEO_CATCHMARK_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/iorheo.h"

namespace rheolef { 
bool scatch (std::istream& in, const std::string& ch);

/*Class:
NAME: @code{catchmark} - iostream manipulator
@clindex catchmark
@clindex field
DESCRIPTION:
    @noindent
    The @code{catchmark} is used for building labels used
    for input-output of vector-valued fields (see @ref{field class}):
    @example
    	cin  >> catchmark("f")   >> fh;
    	cout << catchmark("u")   << uh
    	     << catchmark("w")   << wh
    	     << catchmark("psi") << psih;
    @end example
    Assuming its value for output
    is @code{"u"}, the corresponding labels will be
    @code{"#u0"}, @code{"#u1"}, @code{"#u2"}, ...  
End: */

//<catchmark:
class catchmark {
    public:
	catchmark(const std::string& x);
	const std::string& mark() const { return _mark; }
	friend std::istream& operator >> (std::istream& is, const catchmark& m);
	friend std::ostream& operator << (std::ostream& os, const catchmark& m);
    protected:
	std::string _mark;
};
//>catchmark:

// ================== [ inlined ] ==================================================
inline
catchmark::catchmark(const std::string& x)
: _mark(x)
{
}
inline
std::istream&
operator >> (std::istream& is, const catchmark& m)
{
    is >> setmark(m._mark);
    std::string label = "#"+m._mark;
    if (!scatch(is,label)) {
       	warning_macro ("catchmark: label `"<< label <<"' not found on input");
    }
    return is;
}
inline
std::ostream&
operator << (std::ostream& os, const catchmark& m)
{
    os << setmark(m._mark);
    os << "#" << m._mark << std::endl;
    return os;
}
}// namespace rheolef
# endif // _RHEO_CATCHMARK_H
