#ifndef _RHEO_INTEGRATE_H
#define _RHEO_INTEGRATE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/riesz.h"
namespace rheolef { 

/*Class:integrate
NAME: @code{integrate} - integrate a function
@findex  integrate
DESCRIPTION:
  Integrate a function over a domain by using a quadrature formulae.
SYNOPSYS:
 template <class T, class M, class Function>
 T integrate (const geo_basic<T,M>& g, Function f, quadrature_option_type qopt)
EXAMPLE:
@noindent
@example
  Float f(const point& x);
  ...
  Float value = integrate (omega, f, quadrature_option);
@end example
 An optional argument specifies the quadrature formulae used
 for the computation of the integral.
End: */

//<integrate:
template <class T, class M, class Function>
T integrate (const geo_basic<T,M>& g, Function f, const quadrature_option_type& qopt)
{
    space_basic<T,M> Xh (g, "P0");
    field_basic<T,M> int_K_f_dx = riesz (Xh, f, qopt);
    return dot (1, int_K_f_dx);
}
//>integrate:

}// namespace rheolef
#endif // _RHEO_INTEGRATE_H
