#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "sinusprod.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  field uh;
  din >> uh;
  Float error_linf_expected = (argc > 1) ? atof(argv[1]) : 1e+38;
  space Xh = uh.get_space();
  size_t d = Xh.get_geo().dimension();
  field pi_h_u = interpolate(Xh, u(d));
  field eh = pi_h_u - uh;
  form m(Xh, Xh, "mass");
  form a(Xh, Xh, "grad_grad");
  dout << "error_l2  "  << sqrt(m(eh,eh)) << endl
       << "error_h1  "  << sqrt(a(eh,eh)) << endl
       << "error_linf  "  << eh.max_abs() << endl;
  return (eh.max_abs() <= error_linf_expected) ? 0 : 1;
}
