class p_laplacian {
public:
  typedef field value_type;
  typedef Float float_type;
  p_laplacian(Float p, const geo& omega_h, string approx = "P1");
  void reset(const geo& omega_h, string approx = "previous");
  field initial () const;
  field residue (const field& uh) const;
  void update_derivative (const field& uh) const;
  field derivative_solve (const field& mrh) const;
  field derivative_trans_mult (const field& mrh) const;
  Float norm (const field& uh) const;
  Float dual_norm (const field& Muh) const;
  Float dot (const field& uh, const field& vh) const;
  Float dual_dot (const field& Muh, const field& Mvh) const;
  field criteria(const field& uh) const;
  Float p;
  space Xh, Kh;
  field fh;
  form m, inv_mt, grad;
  solver sm;
  mutable form a1;
  mutable solver sa1;
};
#include "p_laplacian1.icc"
#include "p_laplacian2.icc"
