#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main(int argc, char** argv) {
  environment rheolef (argc, argv);
  Float inv_lambda;
  field uh, ph;
  din  >> catchmark("inv_lambda")  >> inv_lambda
       >> catchmark("u")  >> uh
       >> catchmark("p")  >> ph;
  const space& Xh = uh.get_space();
  const space& Qh = ph.get_space();
  size_t d = Xh.get_geo().dimension();
  point f (0,0,0);
  f [d-1] = -1;
  field lh = riesz (Xh, f);
  form mp (Qh, Qh, "mass");
  form a (Xh, Xh, "2D_D");
  form b (Xh, Qh, "div"); b = -b;
  form c = inv_lambda*mp;
  field m_ru = a*uh + b.trans_mult(ph) - lh;
  field m_rp = b*uh - c*ph;
  for (size_t i_comp = 0; i_comp < d; i_comp++) {
    m_ru[i_comp]["bottom"] = 0;
    m_ru[i_comp]["left"] = 0;
  }
  if (d == 3) {
    for (size_t i_comp = 0; i_comp < d; i_comp++) {
      m_ru[i_comp]["right"] = 0;
      m_ru[i_comp]["back"] = 0; 
    }
  }
  field rp (Qh);
  solver smp (mp.uu());
  rp.set_u() = smp.solve(m_rp.u());
  Float res_u = m_ru.u().max_abs();
  Float res_p = sqrt(mp(rp,rp));
  Float res = max(res_u, res_p);
  derr << "check: residue(uh) = " << res_u << endl 
       << "check: residue(ph) = " << res_p << endl;
  if (argc > 1) {
    dout << catchmark ("mru") << m_ru << endl
         << catchmark ("mrp") << m_rp << endl;
  }
  check_macro (res < 1e-6, "unexpected residue");
}
