#ifndef _RHEOLEF_GEO_CONNECTIVITY_H
#define _RHEOLEF_GEO_CONNECTIVITY_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

// ============================================================================
//  connectivity manipulations
// ============================================================================

#include "rheolef/config.h"

namespace rheolef { 

// a := a inter b
// NOTE: could be in O(a.size + b.size) since a and b are sorted
template<class Set>
static
void
in_place_set_intersection (Set& a, const Set& b)
{
    // c := a inter b
    Set c;
    set_intersection (a.begin(), a.end(), b.begin(), b.end(), 
	inserter(c, c.end()));

    // a := c
    a.erase (a.begin(), a.end());
    copy (c.begin(), c.end(), inserter(a, a.end()));
}
// a := a union b
// NOTE: could be in O(a.size + b.size) since a and b are sorted
template<class Set>
static
void
in_place_set_union (Set& a, const Set& b)
{
    // c := a inter b
    Set c;
    set_union (a.begin(), a.end(), b.begin(), b.end(), 
	inserter(c, c.end()));

    // a := c
    a.erase(a.begin(), a.end());
    copy (c.begin(), c.end(), inserter(a, a.end()));
}
template<class Iterator, class SetRandomIterator>
static 
void
build_point_to_element_sets (
  // input
	Iterator           iter,	// elements
	Iterator           last,
  // output
	SetRandomIterator  ball)	// point-to-element-set
{
    typedef typename geo_element::size_type size_type;

    for (size_type idx = 0; iter != last; iter++, idx++) {
	const geo_element& E = *iter;
	for (size_type i = 0; i < E.size(); i++) {
	    ball [E[i]].insert (ball [E[i]].end(), idx);
        }
    }
}
/// @brief builds a set of elements that all contain S.
template<class Element, class SetRandomIterator, class Set>
void
build_set_that_contains_S (
	const Element&       S,
	SetRandomIterator    ball,
	Set&                 contains_S)
{
    typedef geo_element::size_type size_type;

    contains_S.erase (contains_S.begin(), contains_S.end());
    if (S.size() == 0) {
	return;
    }
    copy (ball[S[0]].begin(), ball[S[0]].end(),
	inserter (contains_S, contains_S.end()));

    for (size_type i = 1; i < S.size(); i++) {
        in_place_set_intersection (contains_S, ball[S[i]]);
    }
}

}// namespace rheolef
#endif // _RHEOLEF_GEO_CONNECTIVITY_H
