///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// P2 approximation
//
#include "basis_symbolic.h"
using namespace rheolef;
using namespace std;

class P2_symbolic : public basis_symbolic_nodal
{
public:
    P2_symbolic ();
};
P2_symbolic::P2_symbolic ()
: basis_symbolic_nodal("P2",2)
{
  on('p') << node(0) << poly (1) << end;
  on('e') << node (0)
	  << node (1)
	  << node (0.5)
	  << poly (1)
	  << poly (x)
	  << poly (x*x)
	  << end;
  on('t') << node (0, 0)
          << node (1, 0)
          << node (0, 1)
          << node (0.5, 0)
          << node (0.5, 0.5)
          << node (0,   0.5)
          << poly (1)
          << poly (x)
          << poly (y)
          << poly (x*x)
          << poly (x*y)
          << poly (y*y)
	  << end;
  on('q') << node (-1, -1)
          << node ( 1, -1)
          << node ( 1,  1)
          << node (-1,  1)
          << node ( 0, -1)
          << node ( 1,  0)
          << node ( 0,  1)
          << node (-1,  0)
          << node ( 0,  0)
          << poly (1)
          << poly (x)
          << poly (y)
          << poly (x*y)
          << poly (x*x)
          << poly (y*y)
          << poly (x*x*y)
          << poly (x*y*y)
          << poly (x*x*y*y)
	  << end;
  on('T') << node (0, 0, 0)
          << node (1, 0, 0)
          << node (0, 1, 0)
          << node (0, 0, 1)
          << node (0.5, 0,   0)
          << node (0.5, 0.5, 0)
          << node (0,   0.5, 0)
          << node (0,   0,   0.5)
          << node (0.5, 0,   0.5)
          << node (0,   0.5, 0.5)
          << poly (1)
          << poly (x)
          << poly (y)
          << poly (z)
          << poly (x*x)
          << poly (y*y)
          << poly (z*z)
          << poly (x*y)
          << poly (y*z)
          << poly (z*x)
          << end;
}
int main (int argc, char **argv) {
	P2_symbolic P2;
	P2.put_cxx_main (argc,argv);
}
