dnl
dnl This file is part of Rheolef.
dnl
dnl Copyright (C) 2000-2009 Pierre Saramito 
dnl
dnl Rheolef is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl Rheolef is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with Rheolef; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
dnl 
dnl -----------------------------------------------------------------------------
dnl
dnl NOTE: lines starting with 'dnl #' are filetered for documentation
dnl
dnl -----------------------------------------------------------------------------
dnl #F:acinclude
dnl #NAME: @code{acinclude} -- autoconf macros
dnl #@cindex porting the code
dnl #@toindex @code{autoconf}
dnl #DESCRIPTION:
dnl #    These macros test for particular system featutres that 
dnl #    rheolef uses. These tests print the messages telling
dnl #    the user which feature they are looking for and what
dnl #    they find. They cache their results for future
dnl #    @code{configure} runs.
dnl #    Some of these macros
dnl #    @dfn{set} some shell variable,
dnl #    @dfn{defines} some output variables for the @file{config.h} header,
dnl #    or performs Makefile macros @dfn{subsitutions}.
dnl #    See @code{autoconf} documentation for how to use such
dnl #    variables.
dnl #SYNOPSIS:
dnl #  Follows a list of particular check required for a
dnl #  successfull installation.
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_GINAC}
dnl #
dnl #    Check to see if GiNaC library exists.
dnl #    If so, set the shell variable @code{rheo_have_ginac}
dnl #    to "yes", defines HAVE_GINAC and
dnl #    substitues INCLUDES_GINAC and LADD_GINAC
dnl #    for adding in CFLAGS and LDFLAGS, respectively,
dnl #    If not, set the shell variable rheo_have_ginac to "no".
dnl #
AC_DEFUN([RHEO_CHECK_GINAC],
    rheo_have_ginac=no
    [AH_TEMPLATE([HAVE_GINAC], Defines if you have ginac library)]
    [AC_SUBST(INCLUDES_GINAC)]
    [AC_SUBST(LDADD_GINAC)]
    [AC_PATH_PROG(PKG_CONFIG, pkg-config, no)]
    if test x"$PKG_CONFIG" != x"no" ; then
      GINAC_VERSION=`pkg-config ginac --modversion 2>/dev/null`
      if test x"$GINAC_VERSION" != x""; then
        LDADD_GINAC=`pkg-config ginac --libs 2>/dev/null`
        INCLUDES_GINAC=`pkg-config ginac --cflags 2>/dev/null`
        rheo_have_ginac=yes
      fi
    fi
    if test x"$rheo_have_ginac" != x"yes" ; then
      [AC_PATH_PROG(GINACLIB_CONFIG, ginac-config, no)]
      if test x"$GINACLIB_CONFIG" != x"no" ; then
        LDADD_GINAC=`ginac-config --cppflags`
        INCLUDES_GINAC=`ginac-config --libs`
        rheo_have_ginac=yes
      fi
    fi
    [AC_MSG_CHECKING(for GiNaC)]
    if test x"$rheo_have_ginac" != x"no" ; then
      [AC_DEFINE(HAVE_GINAC)]
    fi
    [AC_MSG_RESULT($rheo_have_ginac)]
)
dnl #
dnl #    @code{RHEO_CHECK_CLN}
dnl #
dnl #    Check to see if library @code{-lcln} exists.
dnl #    If so, set the shell variable @code{rheo_have_cln}
dnl #    to "yes", defines HAVE_CLN and
dnl #    substitues INCLUDES_CLN and LADD_CLN
dnl #    for adding in CFLAGS and LDFLAGS, respectively,
dnl #    If not, set the shell variable no "no".
dnl #    Includes and libraries path are searched from a
dnl #    given shell variable @code{rheo_dir_cln}.
dnl #    This shell variable could be set for instance
dnl #    by an appropriate @code{--with-cln}=@var{value_dir_cln} option.
dnl #    The default value is @code{/usr/local/math}.
dnl #
AC_DEFUN([RHEO_CHECK_CLN],
    [AC_MSG_CHECKING(for libcln)]
    [AH_TEMPLATE([HAVE_CLN], Defines if you have cln library)]
    if test -f ${rheo_dir_cln}/lib/libcln.la; then
        rheo_have_cln=yes
        [AC_DEFINE(HAVE_CLN)]
        [AC_SUBST(INCLUDES_CLN)]
        [AC_SUBST(LDADD_CLN)]
        INCLUDES_CLN="-I${rheo_dir_cln}/include"
        LDADD_CLN="${rheo_dir_cln}/lib/libcln.la"
        echo ${ac_n} "${LDADD_CLN}${ac_c}... "
    else
        rheo_have_cln=no
    fi
    [AC_MSG_RESULT(${rheo_have_cln})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_SPOOLES_2_0}
dnl #
dnl #    Check to see if spooles library has old version 2.0
dnl #    since @code{FrontMtx_factorInpMtx} profile has changed
dnl #    in version 2.2.
dnl #    If so, defines HAVE_SPOOLES_2_0.
dnl #    This macro is called by RHEO_CHECK_SPOOLES.
dnl #
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_SPOOLES_2_0],
    [AC_MSG_CHECKING(for libspooles version 2.0)]
    [AH_TEMPLATE([HAVE_SPOOLES_2_0], Defines if you have spooles library)]
    [AC_SUBST(INCLUDES_SPOOLES_2_0)]
    PREV_CXXFLAGS=$CXXFLAGS
    CXXFLAGS="$CXXFLAGS -I${rheo_incdir_spooles}"
    [AC_TRY_COMPILE(
	    changequote(%%, %%)dnl
	    %%
		extern "C" {
		#include <misc.h>
		#include <FrontMtx.h>
		#include <SymbFac.h>
		}
	    %%,
	    %%
		FrontMtx      *frontmtx;
		InpMtx *mtxA = InpMtx_new() ;
		double tau = 100;
		ChvManager *chvmanager = ChvManager_new() ;
		double cpus[10] ;
		int stats[20] ;
		int msglvl = 1;
		FILE *msgFile = stdout;
		Chv *rootchv = FrontMtx_factorInpMtx(
			frontmtx, mtxA, tau, 0.0, chvmanager,
			cpus, stats, msglvl, msgFile) ;
	    %%,
	    changequote([, ])dnl
	    rheo_have_spooles_2_0=yes,
	    rheo_have_spooles_2_0=no
        )]
    CXXFLAGS=$PREV_CXXFLAGS
    if test x"${rheo_have_spooles_2_0}" = x"yes"; then
	[AC_DEFINE(HAVE_SPOOLES_2_0)]
    fi
    [AC_MSG_RESULT(${rheo_have_spooles_2_0})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_TAUCS}
dnl #
dnl #    Check to see if taucs library and headers exists.
dnl #    If so, set the shell variable "rheo_have_taucs"
dnl #    to "yes", defines HAVE_TAUCS and
dnl #    substitues INCLUDES_TAUCS and LADD_TAUCS
dnl #    for adding in CXXFLAGS and LDFLAGS, respectively,
dnl #    If not, set the shell variable to "no".
dnl #    Includes and libraries options are
dnl #    given shell variable $rheo_ldadd_taucs and $rheo_incdir_taucs.
dnl #    These shell variables could be set for instance
dnl #    by appropriates "--with-taucs-ldadd="'rheo_ldadd_taucs' and
dnl #    "--with-taucs-includes="'rheo_incdir_taucs' options.
dnl #
AC_DEFUN([RHEO_CHECK_TAUCS],
    [AH_TEMPLATE([HAVE_TAUCS], Defines if you have taucs library)]
    [AC_SUBST(INCLUDES_TAUCS)]
    [AC_SUBST(LDADD_TAUCS)]
    [AC_SUBST(LIBS_TAUCS)]

    rheo_have_taucs=yes
    PREV_CPPFLAGS=$CPPFLAGS
    PREV_LDFLAGS=$LDFLAGS
    INCLUDES_TAUCS=${rheo_incdir_taucs}
    CPPFLAGS="${CPPFLAGS} ${INCLUDES_TAUCS}"
    [AC_CHECK_HEADER(taucs.h, true, rheo_have_taucs=no)]

    if test x"$rheo_have_taucs" = x"yes"; then
        LDADD_TAUCS=${rheo_ldadd_taucs}
        LIBS_TAUCS=${rheo_ldadd_taucs}
        LDFLAGS="${LDFLAGS} ${LDADD_TAUCS}"
        [AC_MSG_CHECKING(for libtaucs)]
        [AC_TRY_COMPILE(
	    changequote(%%, %%)dnl
	    %%
	        extern "C" {
		#include <taucs.h>
		}
	    %%,
	    %%
	        taucs_dccs_create(1,1,1);
	    %%,
	    changequote([, ])dnl
	    true,
	    rheo_have_taucs=no
        )]
        [AC_MSG_RESULT(${rheo_have_taucs})]
    fi
    if test x"$rheo_have_taucs" = x"yes"; then
        [AC_DEFINE(HAVE_TAUCS)]
    else
        INCLUDES_TAUCS=""
        LDADD_TAUCS=""
        LIBS_TAUCS=""
    fi
    CPPFLAGS=$PREV_CPPFLAGS
    LDFLAGS=$PREV_LDFLAGS
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_BOOST}
dnl #
dnl #    Check to see if boost headers exists.
dnl #    If so, set the shell variable "rheo_have_boost"
dnl #    to "yes", defines HAVE_BOOST and
dnl #    substitues INCLUDES_BOOST for adding in CXXFLAGS,
dnl #    and LDADD_BOOST for adding in LIBS.
dnl #    If not, set the shell variable to "no".
dnl #    Includes options are
dnl #    given in the shell variables $rheo_incdir_boost and $rheo_libdir_boost.
dnl #    These shell variables could be set for instance
dnl #    by appropriates "--with-boost-includes="'rheo_incdir_boost'
dnl #    and "--with-boost-libdir="'rheo_libdir_boost' options.
dnl #
AC_DEFUN([RHEO_CHECK_BOOST],
    [AH_TEMPLATE([HAVE_BOOST], Defines if you have boost library)]
    [AC_SUBST(INCLUDES_BOOST)]
    [AC_SUBST(LDADD_BOOST)]
    PREV_CPPFLAGS=$CPPFLAGS

    rheo_have_boost=no
    [AC_CHECK_HEADER(boost/numeric/ublas/matrix.hpp, rheo_have_boost=yes)]
    if test x"$rheo_have_boost" = x"no"; then
      # MAC OS 10 : fink install boost1.33
      # -> /sw/include/boost-1_33_1/boost/numeric/ublas/matrix.hpp
      macdir="/sw/include"
      if test -d $macdir; then
        f=`find $macdir -name matrix.hpp 2>/dev/null`
        if test x"$f" = x""; then
          macincdir=""
        else
          macincdir=`expr $f : '\(.*\)/boost/numeric/ublas/matrix.hpp'`
        fi
      fi
      inc_path_boost="${rheo_incdir_boost} /usr/include ${macdir} ${prefix}/include /usr/local/include"
      for dir in ${inc_path_boost}; do
        [AC_MSG_CHECKING(for boost/numeric/ublas/matrix.hpp presence in $dir...)]
        if test -f $dir/boost/numeric/ublas/matrix.hpp; then
	  [AC_MSG_RESULT(yes)]
	  rheo_have_boost=yes
          if test "$dir" != "/usr/include"; then
              INCLUDES_BOOST="-I${dir}"
          fi
          if test x"${rheo_libdir_boost}" != x""; then
              LDADD_BOOST="-L${rheo_libdir_boost}"
          fi
	  CPPFLAGS="$CPPFLAGS $INCLUDES_BOOST"
	  break
        else
	  [AC_MSG_RESULT(no)]
	fi
      done
    fi
    if test x"$rheo_have_boost" = x"yes"; then
        [AC_MSG_CHECKING(for boost/numeric/ublas/matrix.hpp usability...)]
        [AC_TRY_COMPILE(
	    changequote(%%, %%)dnl
	    %%
		#include <boost/numeric/ublas/matrix.hpp>
	        namespace ublas = boost::numeric::ublas;
	    %%,
	    %%
		ublas::matrix<double> a (2,2);
	    %%,
	    changequote([, ])dnl
	    true,
	    rheo_have_boost=no
        )]
        [AC_MSG_RESULT(${rheo_have_boost})]
    fi
    if test x"$rheo_have_boost" = x"yes"; then
        [AC_DEFINE(HAVE_BOOST)]
    else
        INCLUDES_BOOST=""
    fi
    CPPFLAGS=$PREV_CPPFLAGS
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_ZLIB}
dnl #
dnl #    Check to see if zlib library and headers exists.
dnl #    If so, set the shell variable "rheo_have_zlib"
dnl #    to "yes", defines HAVE_ZLIB and
dnl #    substitues INCLUDES_ZLIB and LADD_ZLIB
dnl #    for adding in CXXFLAGS and LDFLAGS, respectively,
dnl #    If not, set the shell variable to "no".
dnl #    Includes and libraries path are searched from
dnl #    given shell variable $rheo_dir_zlib/lib and $rheo_incdir_zlib.
dnl #    Default value for $rheo_incdir_zlib is $rheo_dir_zlib/include.
dnl #    These shell variables could be set for instance
dnl #    by appropriates "--with-zlib="'dir_zlib' and
dnl #    "--with-zlib-includes="'incdir_zlib' options.
dnl #
AC_DEFUN([RHEO_CHECK_ZLIB],
    [AH_TEMPLATE([HAVE_ZLIB], Defines if you have zlib library)]
    [AC_SUBST(INCLUDES_ZLIB)]
    [AC_SUBST(LDADD_ZLIB)]

    rheo_have_zlib=yes
    if test x"${rheo_dir_zlib}" != x""; then
        rheo_libdir_zlib="$rheo_dir_zlib/lib"
    fi
    if test x"${rheo_dir_zlib}" != x"" -a x"${rheo_incdir_zlib}" = x""; then
        rheo_incdir_zlib="${rheo_dir_zlib}/include"
    fi
    PREV_CPPFLAGS=$CPPFLAGS
    PREV_LDFLAGS=$LDFLAGS
    if test x"${rheo_incdir_zlib}" != x""; then
        INCLUDES_ZLIB="-I${rheo_incdir_zlib}"
        CPPFLAGS="${CPPFLAGS} ${INCLUDES_ZLIB}"
    else
        INCLUDES_ZLIB=""
    fi
    [AC_CHECK_HEADER(zlib.h, true, rheo_have_zlib=no)]

    if test x"$rheo_have_zlib" = x"yes"; then
        if test x"${rheo_libdir_zlib}" != x""; then
            LDADD_ZLIB="-L${rheo_libdir_zlib} -lz"
        else
            LDADD_ZLIB="-lz"
        fi
        LDFLAGS="${LDFLAGS} ${LDADD_ZLIB}"
        [AC_MSG_CHECKING(for -lz)]
        [AC_TRY_COMPILE(
	    changequote(%%, %%)dnl
	    %%
	        extern "C" {
		#include <zlib.h>
		}
	    %%,
	    %%
	        deflate(0,0);
	    %%,
	    changequote([, ])dnl
	    true,
	    rheo_have_zlib=no
        )]
        [AC_MSG_RESULT(${rheo_have_zlib})]
    fi
    if test x"$rheo_have_zlib" = x"yes"; then
        [AC_DEFINE(HAVE_ZLIB)]
    else
        INCLUDES_ZLIB=""
        LDADD_ZLIB=""
    fi
    CPPFLAGS=$PREV_CPPFLAGS
    LDFLAGS=$PREV_LDFLAGS
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_SPOOLES}
dnl #
dnl #    Check to see if spooles library and headers exists.
dnl #    If so, set the shell variable "rheo_have_spooles"
dnl #    to "yes", defines HAVE_SPOOLES and
dnl #    substitues INCLUDES_SPOOLES and LADD_SPOOLES
dnl #    for adding in CXXFLAGS and LDFLAGS, respectively,
dnl #    If not, set the shell variable to "no".
dnl #    Includes and libraries path are searched from
dnl #    given shell variable "rheo_libdir_spooles" and "rheo_incdir_spooles".
dnl #    These shell variables could be set for instance
dnl #    by appropriates "--with-spooles="'libdir_spooles' and
dnl #    "--with-spooles-includes="'incdir_spooles' options.
dnl #
AC_DEFUN([RHEO_CHECK_SPOOLES],
    [AC_MSG_CHECKING(for libspooles)]
    [AH_TEMPLATE([HAVE_SPOOLES], Defines if you have spooles library)]
    [AC_SUBST(INCLUDES_SPOOLES)]
    [AC_SUBST(LDADD_SPOOLES)]
    [AC_SUBST(LIBS_SPOOLES)]
    # get absolute path name:
    path_spooles="${prefix} /usr/local/math /usr/local /usr /"
    if test x"${rheo_libdir_spooles}" != x""; then
        dir="`expr ${rheo_libdir_spooles} : '\./\(.*\)' \| ${rheo_libdir_spooles}`"
        path_spooles="${dir} ${path_spooles}"
    fi
    default_rheo_libdir_spooles=${rheo_libdir_spooles-"/usr/local/math"}
    rheo_libdir_spooles=""
    for sym_dir in ${path_spooles}; do
        dir=`eval "echo ${sym_dir}"`
	for lib in libspooles.so libspooles.sl libspooles.a spooles.a; do
          if test -f "${dir}/${lib}" -o -f "${dir}/lib/${lib}"; then
	    rheo_dir_spooles=${dir}
            if test -f "${dir}/${lib}"; then
	      rheo_libdir_spooles=${dir}
	    else
	      rheo_libdir_spooles=${dir}/lib
	    fi
            [AC_MSG_RESULT(${rheo_libdir_spooles}/${lib})]
            LDADD_SPOOLES=${rheo_libdir_spooles}/${lib}
            LIBS_SPOOLES=${rheo_libdir_spooles}/${lib}
    	    rheo_have_spooles=yes
	    break
	  fi
	done
	if test x"${rheo_libdir_spooles}" != x""; then
	    break
        fi
    done
    if test x"${rheo_have_spooles}" = x"yes"; then
        [AC_MSG_CHECKING(for spooles/FrontMtx.h)]
        if test x"${rheo_dir_spooles}" != x""; then
     	    if test -f "${rheo_dir_spooles}/FrontMtx.h"; then
                rheo_incdir_spooles="${rheo_dir_spooles}"
	    elif test -f "${rheo_dir_spooles}/include/FrontMtx.h"; then
                rheo_incdir_spooles="${rheo_dir_spooles}/include"
	    elif test -f "${rheo_dir_spooles}/include/spooles/FrontMtx.h"; then
                rheo_incdir_spooles="${rheo_dir_spooles}/include/spooles"
	    fi
        fi
     	if test -f "${rheo_incdir_spooles}/FrontMtx.h"; then
            [AC_MSG_RESULT(${rheo_incdir_spooles}/FrontMtx.h)]
	    INCLUDES_SPOOLES="-I${rheo_incdir_spooles}"
	else
    	    rheo_have_spooles=no
        fi
    fi
    if test x"${rheo_have_spooles}" != x"yes"; then
	INCLUDES_SPOOLES=""
	LDADD_SPOOLES=""
	LIBS_SPOOLES=""
        [AC_MSG_RESULT($rheo_have_spooles)]
	[AC_MSG_RESULT(** WARNING: recommended spooles library not found)]
    else
	[AC_DEFINE(HAVE_SPOOLES)]
	[RHEO_CHECK_SPOOLES_2_0]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_UMFPACK}
dnl #
dnl #    Check to see if umfpack library and headers exists.
dnl #    If so, set the shell variable "rheo_have_umfpack"
dnl #    to "yes", defines HAVE_UMFPACK and
dnl #    substitues INCLUDES_UMFPACK and LADD_UMFPACK
dnl #    for adding in CXXFLAGS and LDFLAGS, respectively,
dnl #    If not, set the shell variable to "no".
dnl #    Includes and libraries path are searched from
dnl #    given shell variable "rheo_libdir_umfpack" and "rheo_incdir_umfpack".
dnl #    These shell variables could be set for instance
dnl #    by appropriates "--with-umfpack="'libdir_umfpack' and
dnl #    "--with-umfpack-includes="'incdir_umfpack' options.
dnl #
AC_DEFUN([RHEO_CHECK_UMFPACK],
    [AC_MSG_CHECKING(for libumfpack)]
    [AH_TEMPLATE([HAVE_UMFPACK], Defines if you have umfpack library)]
    [AC_SUBST(INCLUDES_UMFPACK)]
    [AC_SUBST(LDADD_UMFPACK)]
    [AC_SUBST(LIBS_UMFPACK)]
   
    # assume debian style :
    rheo_have_umfpack=yes
    rheo_libdir_umfpack=/usr/lib
    dnl dependencies: amd blas
    lib="-lumfpack -lamd -lblas"
    [AC_MSG_RESULT($lib)]
    LDADD_UMFPACK="$lib"
    LIBS_UMFPACK="${LDADD_UMFPACK}"
    incdir_list="/usr/include/umfpack /usr/include/ufsparse /usr/include/suitesparse"
    if test x"${rheo_incdir_umfpack}" != x""; then
      incdir_list="${rheo_incdir_umfpack} ${incdir_list}"
    fi
    [AC_MSG_CHECKING(for umfpack.h)]
    rheo_incdir_umfpack=""
    for d in ${incdir_list}; do
      if test -f "${d}/umfpack.h"; then
        rheo_incdir_umfpack="${d}"; break
      fi
    done
    if test -f "${rheo_incdir_umfpack}/umfpack.h"; then
            [AC_MSG_RESULT(${rheo_incdir_umfpack}/umfpack.h)]
            INCLUDES_UMFPACK="-I${rheo_incdir_umfpack}"
    else
    	    rheo_have_umfpack=no
    fi
    if test x"${rheo_have_umfpack}" != x"yes"; then
	INCLUDES_UMFPACK=""
	LDADD_UMFPACK=""
	LIBS_UMFPACK=""
        [AC_MSG_RESULT($rheo_have_umfpack)]
	[AC_MSG_RESULT(** WARNING: recommended umfpack library not found)]
        [AC_MSG_RESULT(${rheo_have_umfpack})]
    else
	[AC_DEFINE(HAVE_UMFPACK)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_MALLOC_DBG}
dnl #
dnl #    Check to see if malloc debug library -lmalloc_dbg
dnl #    and corresponding header <malloc_dbg.h> exists.
dnl #    If so, set the shell variable @code{rheo_have_malloc_dbg}
dnl #    to "yes", defines HAVE_MALLOC_DBG,
dnl #    add @code{-I}@var{dir_malloc_dbg}@code{/include} to CFLAGS,
dnl #    add @var{dir_malloc_dbg}@code{/lib/libmalloc_dbg.a} to LDFLAGS.
dnl #    Here, @var{dir_malloc_dbg} is the directory such that
dnl #    @var{dir_malloc_dbg}@code{/bin} appears in PATH and
dnl #    the command @var{dir_malloc_dbg}@code{/bin/malloc_dbg} exists.
dnl #    If not, set the variable to "no".
dnl #	 Set also LIBS_MALLOC_DBG to these flags.
AC_DEFUN([RHEO_CHECK_MALLOC_DBG],
    rheo_have_malloc_dbg=no
    [AC_PATH_PROG(malloc_dbg, malloc_dbg)]
    [AC_SUBST(LIBS_MALLOC_DBG)]
    if test x${malloc_dbg} != x; then
        [AC_MSG_CHECKING(for libmalloc_dbg)]
	[AH_TEMPLATE([HAVE_MALLOC_DBG], Defines if you have malloc_dbg library)]
        rheo_bindir_malloc_dbg=`expr ${malloc_dbg} : '\(.*\)/[/]*malloc_dbg' `
        rheo_dir_malloc_dbg=`expr ${rheo_bindir_malloc_dbg} : '\(.*\)/.*' `
        PREC_CFLAGS="$CFLAGS"
        CFLAGS="$CFLAGS -I${rheo_dir_malloc_dbg}/include"
        PREC_LDFLAGS=${LDFLAGS}
        LIBS_MALLOC_DBG="-L${rheo_dir_malloc_dbg}/lib -lmalloc_dbg"
        LDFLAGS="${LDFLAGS} ${LIBS_MALLOC_DBG}"
        [AC_TRY_COMPILE(
	    changequote(%%, %%)dnl
	    %%
	        extern "C" {
		#include <malloc_dbg.h>
		}
	    %%,
	    %%
	        malloc_verify(0);
	    %%,
	    changequote([, ])dnl
	    rheo_have_malloc_dbg=yes,
	    rheo_have_malloc_dbg=no
        )]
        if test x"${rheo_have_malloc_dbg}" != x"yes"; then
	    CFLAGS=${PREC_CFLAGS}
	    LDFLAGS=${PREC_LDFLAGS}
            LIBS_MALLOC_DBG=""
	else
	    rheo_have_malloc_dbg=yes
	    [AC_DEFINE(HAVE_MALLOC_DBG)]
	fi
        [AC_MSG_RESULT($rheo_have_malloc_dbg)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_DMALLOC}
dnl #
dnl #    @pindex dmalloc
dnl #    @toindex dmalloc, debug runtime library
dnl #    @cindex  debugging
dnl #
dnl #    Check whether the dmalloc
dnl #    package exists and set the corresponding
dnl #    shell value "rheo_have_dmalloc" and 
dnl #    HAVE_DMALLOC (in Makefile.am and config.h) accordingly,
dnl #    create LDADD_DMALLOC and LDADD_DMALLOCXX Makefile.am variables.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_DMALLOC], [
    AH_TEMPLATE([HAVE_DMALLOC], Defines if you use dmalloc library)
    rheo_have_dmalloc=no
    AC_CHECK_PROGS(DMALLOC, dmalloc)
    if test x"${DMALLOC}" != x""; then
      rheo_have_dmalloc=yes
    fi
    if test x"${rheo_have_dmalloc}" = xyes; then
      AC_DEFINE(HAVE_DMALLOC)
      AC_SUBST(LDADD_DMALLOCXX)
      AC_SUBST(LDADD_DMALLOC)
      LDADD_DMALLOCXX="\${top_builddir}/util/dmallocxx/libdmallocxx.la"
      LDADD_DMALLOC="-ldmalloc"
    fi
])
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_NAMESPACE}
dnl #
dnl #    Check whether the namespace feature
dnl #    is supported by the C++ compiler.
dnl #    value. So, try to compile
dnl #    the following code:
dnl #    @example
dnl #	   namespace computers @{
dnl #  	      struct keyboard @{ int getkey() const @{ return 0; @} @};
dnl #	   @}
dnl #	   namespace music @{
dnl #  	      struct keyboard @{ void playNote(int note); @};
dnl #	   @}
dnl #	   namespace music @{
dnl #  	      void keyboard::playNote(int note) @{ @}
dnl #	   @}
dnl #	   using namespace computers;
dnl #      int main() @{
dnl #         keyboard x;
dnl #         int z = x.getkey();
dnl #         music::keyboard y;
dnl #         y.playNote(z);
dnl #         return 0;
dnl #      @}
dnl #    @end example
dnl #    If it compile, set the corresponding 
dnl #    shell variable "rheo_have_namespace"
dnl #    to "yes" and defines HAVE_NAMESPACE.
dnl #    If not, set the variable no "no".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_NAMESPACE],
    [AC_MSG_CHECKING(for namespace)]
    [AH_TEMPLATE([HAVE_NAMESPACE], Defines if you have C++ namespace)]
    [AC_TRY_COMPILE(
	changequote(%%, %%)dnl
	%%
	    namespace computers {
  	        struct keyboard { int getkey() const { return 0; } };
	    }
	    namespace music {
  	        struct keyboard { void playNote(int note); };
	    }
	    namespace music {
  		void keyboard::playNote(int note) { }
	    }
	    using namespace computers;
	%%,
	%%
    	    keyboard x;
    	    int z = x.getkey();
    	    music::keyboard y;
    	    y.playNote(z);
    	    return 0;
	%%,
	changequote([, ])dnl
	rheo_have_namespace=yes
	AC_DEFINE(HAVE_NAMESPACE),
	rheo_have_namespace=no
    )]
    [AC_MSG_RESULT($rheo_have_namespace)]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_STD_NAMESPACE}
dnl #
dnl #    Some compilers (e.g. GNU C++ 2.7.2) does not support
dnl #    the full namespace feature. Nevertheless, they support
dnl #    the "std:" namespace for the C++ library.
dnl #    is supported by the C++ compiler. The following code
dnl #    is submitted to the compiler:
dnl #    @example
dnl #         #include<vector.h>
dnl #         extern "C" void exit(int);
dnl #         int main() @{
dnl #             std::vector<int> x(3);
dnl #         	  return 0;
dnl #         @}
dnl #    @end example
dnl #    If it compile, set the corresponding 
dnl #    shell variable "rheo_have_std_namespace"
dnl #    to "yes" and defines HAVE_STD_NAMESPACE.
dnl #    If not, set the variable no "no".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_STD_NAMESPACE],
    [AC_MSG_CHECKING(for namespace std::)]
    [AH_TEMPLATE([HAVE_STD_NAMESPACE], Defines if you have namespace std::)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
	%%
	    #include<vector.h>
	    extern "C" void exit(int);
	%%,
	%%
    	    std::vector<int> x(3);
    	    return 0;
	%%,
	changequote([, ])dnl
	rheo_have_std_namespace=yes
	[AC_DEFINE(HAVE_STD_NAMESPACE)],
	rheo_have_std_namespace=no
    )]
    [AC_MSG_RESULT($rheo_have_std_namespace)]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_PROG_GNU_MAKE}
dnl #
dnl #    Find command make and check whether make is GNU make.
dnl #    If so, set the corresponding 
dnl #    shell variable "rheo_prog_gnu_make"
dnl #    to "yes" and substitues no_print_directory_option
dnl #    to "--no-print-directory".
dnl #    If not, set the shell variable no "no".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_PROG_GNU_MAKE],
    [AC_CHECK_PROGS(MAKE, make gmake gnumake, make)]
    [AC_MSG_CHECKING(whether make is GNU make)]
    echo "all:" > conftest.mk
    if $MAKE --no-print-directory -f conftest.mk 2>/dev/null 1>/dev/null; then
       rheo_prog_gnu_make=yes
       [AC_SUBST([no_print_directory_option])]
       no_print_directory_option="--no-print-directory"
    else
        rheo_prog_gnu_make=no
    fi
    /bin/rm -f conftest.mk
    [AC_MSG_RESULT(${rheo_prog_gnu_make})]
    if test x"${rheo_prog_gnu_make}" != x"yes"; then
       [AC_MSG_ERROR(rheolef requires gnu make)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_ISTREAM_RDBUF}
dnl #
dnl #    @code{RHEO_CHECK_IOS_BP}
dnl #
dnl #    Check to see if "iostream::rdbuf(void*)"
dnl #    function exists, that set the "ios" buffer
dnl #    of a stream. Despite this function is standard,
dnl #    numerous compilers does not furnish it. 
dnl #    a common implementation is to set directly
dnl #    the buffer variable. For instance, the CRAY C++
dnl #    compiler implements this variable as "ios::bp".
dnl #    These two functions set the shell variables
dnl #    "rheo_have_istream_rdbuf" and "rheo_have_ios_bp"
dnl #    and define HAVE_ISTREAM_RDBUF and HAVE_IOS_BP
dnl #    respectively.
dnl -----------------------------------------------------------------------------
dnl istream::rdbuf(ptr)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_ISTREAM_RDBUF],
    [AC_MSG_CHECKING(for iostream::rdbuf(void*))]
    [AH_TEMPLATE([HAVE_ISTREAM_RDBUF], Defines if you have iostream::rdbuf(void*) in <iostream.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <iostream.h>
            extern "C" void exit(int);
            struct A : istream {
                A() : istream(0) { rdbuf(0); }
            };  
        %%,
        %%
            A a();
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_ISTREAM_RDBUF)]
        rheo_have_istream_rdbuf=yes, 
        rheo_have_istream_rdbuf=no,
        rheo_have_istream_rdbuf=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_istream_rdbuf})]
)
dnl -----------------------------------------------------------------------------
dnl istream::bp when ios::rdbuf() failed
dnl (non-standard: e.g. CRAY C++)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_IOS_BP],
    [AC_MSG_CHECKING(for ios::bp)]
    [AH_TEMPLATE([HAVE_IOS_BP], Defines if you have ios::bp in <iostream.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            extern "C" void exit(int);
            #include <iostream.h>
            struct A : istream {
            A() : istream(0) { bp = 0; }
            };  
        %%,
        %%
            A a();
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_IOS_BP)]
        rheo_have_ios_bp=yes, 
        rheo_have_ios_bp=no,
        rheo_have_ios_bp=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_ios_bp})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_IOS_SETSTATE}
dnl #
dnl #    Check to see if "ios::setstate(long)"
dnl #    function exists, that set the "ios" state variable
dnl #    of a stream. Despite this function is standard,
dnl #    numerous compilers does not furnish it. 
dnl #    a common implementation is to set directly
dnl #    the buffer variable. For instance, the CRAY C++
dnl #    compiler does not implements it.
dnl #    This function set the shell variables
dnl #    "rheo_have_ios_setstate"
dnl #    and define HAVE_IOS_SETSTATE.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_IOS_SETSTATE],
    [AC_MSG_CHECKING(for ios::setstate(long))]
    [AH_TEMPLATE([HAVE_IOS_SETSTATE], Defines if you have ios::setstate(long) in <iostream.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            extern "C" void exit(int);
            #include <iostream.h>
        %%,
        %%
            cout.setstate(ios::goodbit);
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_IOS_SETSTATE)]
        rheo_have_ios_setstate=yes, 
        rheo_have_ios_setstate=no,
        rheo_have_ios_setstate=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_ios_setstate})]
)
dnl -----------------------------------------------------------------------------
dnl ios::bitalloc() when ios::pwords() failed
dnl (non-standard: e.g. CRAY C++)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_IOS_BITALLOC],
    [AC_MSG_CHECKING(for ios::bitalloc())]
    [AH_TEMPLATE([HAVE_IOS_BITALLOC], Defines if you have ios::bitalloc() in <iostream.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <iostream.h>
            extern "C" void exit(int);
        %%,
        %%
            long b = ios::bitalloc();
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_IOS_BITALLOC)]
        have_ios_bitalloc=yes, 
	have_ios_bitalloc=no,
	have_ios_bitalloc=undef
	false
    )]
    [AC_MSG_RESULT(${have_ios_bitalloc})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_FILEBUF_INT}
dnl #
dnl #    @code{RHEO_CHECK_FILEBUF_FILE}
dnl #
dnl #    @code{RHEO_CHECK_FILEBUF_FILE_MODE}
dnl #
dnl #    Check wheter "filebuf::filebuf(int fileno)",
dnl #    "filebuf::filebuf(FILE* fd)" exist,
dnl #    or "filebuf::filebuf(FILE* fd, ios::openmode)" exist,
dnl #    respectively.
dnl #    If so, set the corresponding 
dnl #    shell variable "rheo_have_filebuf_int"
dnl #    (resp. "rheo_have_filebuf_file")
dnl #    to "yes" and defines HAVE_FILEBUF_INT,
dnl #    (resp. HAVE_FILEBUF_FILE).
dnl #    If not, set the variable no "no".
dnl #    Notes that there is no standardisation 
dnl #    of this function in the "c++" library.
dnl #    Nevertheless, this fonctionality is
dnl #    usefull to open a pipe stream class,
dnl #    as "pstream(3)".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_FILEBUF_INT],
    [AC_MSG_CHECKING(for filebuf::filebuf(int))]
    [AH_TEMPLATE([HAVE_FILEBUF_INT], Defines if you have filebuf(int*) in <fstream.h>)]
    [AC_TRY_COMPILE(
	changequote(%%, %%)dnl
	%%
	    #include <stdio.h>
	    #include <fstream.h>
	    extern "C" void exit(int);
	    extern "C" int open(const char*, const char*);
	%%,
	%%
	    int fileno = open("/dev/null", "r");
	    filebuf fbuf(fileno);
	%%,
	changequote([, ])dnl
	[AC_DEFINE(HAVE_FILEBUF_INT)]
	rheo_have_filebuf_int=yes, 
	rheo_have_filebuf_int=no,
	rheo_have_filebuf_int=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_filebuf_int})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_FILEBUF_FILE],
    [AC_MSG_CHECKING(for filebuf::filebuf(FILE*))]
    [AH_TEMPLATE([HAVE_FILEBUF_FILE], Defines if you have filebuf(FILE*) in <fstream.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <stdio.h>
            #include <fstream.h>
            extern "C" void exit(int);
        %%,
        %%
            FILE* fd = fopen("/dev/null", "r");
            filebuf fbuf(fd);
        %%,
        changequote([, ])dnl
	[AC_DEFINE(HAVE_FILEBUF_FILE)]
	rheo_have_filebuf_file=yes, 
	rheo_have_filebuf_file=no,
	rheo_have_filebuf_file=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_filebuf_file})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_FILEBUF_FILE_MODE],
    [AC_MSG_CHECKING(for filebuf::filebuf(FILE*,ios::openmode))]
    [AH_TEMPLATE([HAVE_FILEBUF_FILE_MODE], Defines if you have filebuf(FILE*,ios::openmode) in <fstream.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <stdio.h>
            #include <fstream.h>
            extern "C" void exit(int);
        %%,
        %%
            FILE* fd = fopen("/dev/null", "r");
            filebuf fbuf(fd,std::ios::in);
        %%,
        changequote([, ])dnl
	[AC_DEFINE(HAVE_FILEBUF_FILE_MODE)]
	rheo_have_filebuf_file_mode=yes, 
	rheo_have_filebuf_file_mode=no,
	rheo_have_filebuf_file_mode=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_filebuf_file_mode})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_GETTIMEOFDAY}
dnl #
dnl #    Check whether the "gettimeofday(timeval*, timezone*)"
dnl #    function exists and set the corresponding
dnl #    shell value "rheo_have_gettimeofday" and 
dnl #    define HAVE_GETTIMEOFDAY accordingly.
dnl --------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_GETTIMEOFDAY],
    [AC_MSG_CHECKING(for gettimeofday(timeval*, timezone*))]
    [AH_TEMPLATE([HAVE_GETTIMEOFDAY], Defines if you have gettimeofday(timeval*, timezone*) in <sys/time.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <sys/types.h>
            #include <sys/time.h>
        %%,
        %%
            struct timeval tp;
            struct timezone tzp;
            gettimeofday(&tp,&tzp);
            double x = ((double) tp.tv_sec + .000001 * (double) tp.tv_usec);
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_GETTIMEOFDAY)]
        rheo_have_gettimeofday=yes, 
        rheo_have_gettimeofday=no,
        rheo_have_gettimeofday=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_gettimeofday})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_WIERDGETTIMEOFDAY}
dnl #
dnl #    This is for Solaris, where they decided 
dnl #    to change the CALLING SEQUENCE OF gettimeofday!
dnl #    Check whether the "gettimeofday(timeval*)"
dnl #    function exists and set the corresponding
dnl #    shell value "rheo_have_wierdgettimeofday" and 
dnl #    define HAVE_WIERDGETTIMEOFDAY accordingly.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_WIERDGETTIMEOFDAY],
    [AC_MSG_CHECKING(for solaris gettimeofday(timeval*))]
    [AH_TEMPLATE([HAVE_WIERDGETTIMEOFDAY], Defines if you have solaris gettimeofday(timeval*) in <sys/time.h>"")]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <sys/types.h>
            #include <sys/time.h>
        %%,
        %%
       	    struct timeval tp;
            gettimeofday(&tp);
            double x = ((double) tp.tv_sec + .000001 * (double) tp.tv_usec);
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_WIERDGETTIMEOFDAY)]
        rheo_have_wierdgettimeofday=yes, 
        rheo_have_wierdgettimeofday=no,
        rheo_have_wierdgettimeofday=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_wierdgettimeofday})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_BSDGETTIMEOFDAY}
dnl #
dnl #    For BSD systems,
dnl #    check whether the "BSDgettimeofday(timeval*, timezone*)"
dnl #    function exists and set the corresponding
dnl #    shell value "rheo_have_bsdgettimeofday" and 
dnl #    define HAVE_BSDGETTIMEOFDAY accordingly.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_BSDGETTIMEOFDAY],
    [AC_MSG_CHECKING(for BSDgettimeofday(timeval*, timezone*))]
    [AH_TEMPLATE([HAVE_BSDGETTIMEOFDAY], Defines if you have BSDgettimeofday(timeval*, timezone*) in <sys/time.h>)]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
            #include <sys/types.h>
            #include <sys/time.h>
        %%,
        %%
    	    struct timeval tp;
	    struct timezone tzp;
	    BSDgettimeofday(&tp,&tzp);
	    double x = ((double) tp.tv_sec + .000001 * (double) tp.tv_usec);
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_BSDGETTIMEOFDAY)]
        rheo_have_bsdgettimeofday=yes, 
        rheo_have_bsdgettimeofday=no,
        rheo_have_bsdgettimeofday=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_bsdgettimeofday})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_AMICCLK}
dnl #
dnl #    Check whether the clock "amicclk()"
dnl #    function exists and set the corresponding
dnl #    shell value "rheo_have_amicclk" and 
dnl #    define HAVE_AMICCLK accordingly.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_AMICCLK],
    [AC_MSG_CHECKING(for amicclk)]
    [AH_TEMPLATE([HAVE_AMICCLK], Defines if you have amicclk() in <sys/time.h>)]
    [AC_TRY_RUN(
        changequote(%%, %%)dnl
        %%
            #include <sys/types.h>
            #include <sys/time.h>
	    int main() {
	        double x = amicclk()*1.0e-6;
	        return 0;
	    }
        %%,
        changequote([, ])dnl
        [AC_DEFINE(HAVE_AMICCLK)]
        rheo_have_amicclk=yes, 
        rheo_have_amicclk=no,
        rheo_have_amicclk=undef
        false
    )]
    [AC_MSG_RESULT(${rheo_have_amicclk})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_TEMPLATE_FULL_SPECIALIZATION}
dnl #
dnl #    Check whether the template specialization syntax "template<>"
dnl #    is supported by the compiler
dnl #    value. So, try to compile, run
dnl #    and check the return value for the following code:
dnl #    @example
dnl #      template<class T> struct toto @{
dnl #          int tutu() const @{ return 1; @}
dnl #      @};
dnl #      template<> struct toto<float> @{
dnl #          int tutu() const @{ return 0; @}
dnl #      @};
dnl #      main() @{
dnl #       toto<float> x;
dnl #       return x.tutu();
dnl #      @}
dnl #    @end example
dnl #    If so, set the corresponding 
dnl #    shell variable "rheo_have_template_full_specialization"
dnl #    to "yes" and defines HAVE_TEMPLATE_FULL_SPECIALIZATION.
dnl #    If not, set the variable no "no".
dnl --------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_TEMPLATE_FULL_SPECIALIZATION],
    [AC_MSG_CHECKING(for template<> full specialization syntax)]
    [AH_TEMPLATE([HAVE_TEMPLATE_FULL_SPECIALIZATION], Defines if you have template<> full specialization syntax")]
    [AC_TRY_COMPILE(
        changequote(%%, %%)dnl
        %%
   	    template<class T> struct toto {
       	        int tutu() const { return 1; }
   	    };
   	    template<> struct toto<float> {
       	        int tutu() const { return 0; }
   	    };
        %%,
        %%
	    toto<float> x;
	    return x.tutu();
        %%,
        changequote([, ])dnl
        rheo_have_template_full_specialization=yes
        [AC_DEFINE(HAVE_TEMPLATE_FULL_SPECIALIZATION)],
        rheo_have_template_full_specialization=no
    )]
    [AC_MSG_RESULT(${rheo_have_template_full_specialization})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_ISNAN_DOUBLE}
dnl #
dnl #    @code{RHEO_CHECK_ISINF_DOUBLE}
dnl #
dnl #    @code{RHEO_CHECK_FINITE_DOUBLE}
dnl #
dnl #    @code{RHEO_CHECK_INFINITY}
dnl #
dnl #    @code{RHEO_CHECK_ABS_DOUBLE}
dnl #
dnl #    @code{RHEO_CHECK_SQR_DOUBLE}
dnl #
dnl #    Check whether the funtions 
dnl #    @example
dnl #            bool isnan(double);
dnl #            bool isinf(double);
dnl #            bool finite(double);
dnl #            double infinity();
dnl #            double abs();
dnl #            double sqr();
dnl #    @end example
dnl #    are supported by the compiler, respectively.
dnl #    If so, set the corresponding 
dnl #    shell variable "rheo_have_xxx"
dnl #    to "yes" and defines HAVE_XXX.
dnl #    If not, set the variable no "no".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_ISNAN_DOUBLE],
    [AC_MSG_CHECKING(for isnan(double))]
    [AC_TRY_RUN(
	[
	    #include <math.h>
	    extern "C" void exit(int);
	    int main() { exit (!isnan(log(-1))); }
	],
	[AC_DEFINE(HAVE_ISNAN_DOUBLE)]
	rheo_have_isnan_double=yes, 
	rheo_have_isnan_double=no,
	rheo_have_isnan_double=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_isnan_double})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_ISINF_DOUBLE],
    [AC_MSG_CHECKING(for isinf(double))]
    [AH_TEMPLATE([HAVE_ISINF_DOUBLE], Defines if you have isinf(double) in <math.h>)]
    [AC_TRY_RUN(
	[
	    #include <math.h>
	    extern "C" void exit(int);
	    int main() { exit (!isinf(1/log(1))); }
	],
	[AC_DEFINE(HAVE_ISINF_DOUBLE)]
	rheo_have_isinf_double=yes, 
	rheo_have_isinf_double=no,
	rheo_have_isinf_double=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_isinf_double})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_FINITE_DOUBLE],
    [AC_MSG_CHECKING(for finite(double))]
    [AH_TEMPLATE([HAVE_FINITE_DOUBLE], Defines if you have finite(double) in <fstream.h>)]
    [AC_TRY_RUN(
	[
	    #include <math.h>
	    extern "C" void exit(int);
	    int main() { exit (finite(0) && !finite(1/log(1))); }
	],
	[AC_DEFINE(HAVE_FINITE_DOUBLE)]
	rheo_have_finite_double=yes, 
	rheo_have_finite_double=no,
	rheo_have_finite_double=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_finite_double})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_INFINITY],
    [AC_MSG_CHECKING(for infinity())]
    [AC_TRY_RUN(
	[
	    #include <math.h>
	    extern "C" void exit(int);
	    int main() { double x = infinity(); exit(0); }
	],
	[AC_DEFINE(HAVE_INFINITY)]
	rheo_have_infinity=yes, 
	rheo_have_infinity=no,
	rheo_have_infinity=undef
	false
    )]
    [AC_MSG_RESULT(${rheo_have_infinity})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_ABS_DOUBLE],
    [AC_MSG_CHECKING(for abs(double))]
    [AH_TEMPLATE([HAVE_ABS_DOUBLE], Defines if you have abs(double))]
    [AC_TRY_RUN(
	[
	    #include <math.h>
	    extern "C" void exit(int);
	    int main() { exit (abs(double(1.2)) != 1.2); }
	],
	[AC_DEFINE(HAVE_ABS_DOUBLE)]
	rheo_have_abs_double=yes, 
	rheo_have_abs_double=no,
	rheo_have_abs_double=undef
	false
     )]
     [AC_MSG_RESULT(${rheo_have_abs_double})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_SQR_DOUBLE],
    [AC_MSG_CHECKING(for sqr(double))]
    [AH_TEMPLATE([HAVE_SQR_DOUBLE], Defines if you have sqr(double) in <math.h>)]
    [AC_TRY_RUN(
	[
	    #include <math.h>
	    extern "C" void exit(int);
	    int main() { exit (sqr(double(1.2)) != 1.2*1.2); }
	],
	[AC_DEFINE(HAVE_SQR_DOUBLE)]
	rheo_have_sqr_double=yes, 
	rheo_have_sqr_double=no,
	rheo_have_sqr_double=undef
	false
     )]
     [AC_MSG_RESULT(${rheo_have_sqr_double})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_FLEX}
dnl #
dnl #    Check to see if the "flex" command and the
dnl #    corresponding header "FlexLexer.h" are available.
dnl #    If so, set the shell variable "rheo_have_flex"
dnl #    to "yes" and substitues FLEX to "flex"
dnl #    and FLEXLEXER_H to the full path for FlexLexer.h
dnl #    If not, set the shell variable no "no".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_FLEX],
    rheo_have_flex=no
    [AC_SUBST(FLEX)]
    [AC_SUBST(FLEXLEXER_H)]
    FLEX=""
    FLEXLEXER_H=""
    [AC_PATH_PROG(PATH_FLEX, flex)]
    if test x"${PATH_FLEX}" != x""; then
        rheo_bindir_flex=`expr ${PATH_FLEX} : '\(.*\)/[/]*flex' `
        rheo_dir_flex=`expr ${rheo_bindir_flex} : '\(.*\)/.*' `
        [AC_MSG_CHECKING(for FlexLexer.h)]
    	FLEXLEXER_H="${rheo_dir_flex}/include/FlexLexer.h"
	if test -f "$FLEXLEXER_H"; then
    	    [AC_MSG_RESULT(${FLEXLEXER_H})]
	    FLEX=`expr ${PATH_FLEX} : '.*/\(.*\)' \| ${PATH_FLEX}`
	    rheo_have_flex=yes
        else
    	    [AC_MSG_RESULT("no")]
	fi
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_PROG_CC_KAI}
dnl #
dnl #    Check wheter we are using KAI C++ compiler.
dnl #    If so, set the shell variable "ac_cv_prog_kcc"
dnl #    to "yes".
dnl #    If not, set the shell variable no "no".
dnl #    The shell variable is also exported for sub-shells,
dnl #    such as ltconfig from libtool.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_PROG_CC_KAI],
    [AC_CACHE_CHECK(whether we are using KAI C, 
	ac_cv_prog_kcc,
        [dnl The semicolon is to pacify NeXT's syntax-checking cpp.
        cat > conftest.C <<EOF
        #ifdef __KCC
            yes;
        #endif
EOF
        dnl export variable for ltconfig (libtool) facility
        export ac_cv_prog_kcc
        if AC_TRY_COMMAND(${CXX-KCC} -E conftest.C) | egrep yes >/dev/null 2>&1; then
            ac_cv_prog_kcc=yes
        else
            ac_cv_prog_kcc=no
        fi]
	/bin/rm -f conftest.C
    )]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_PROG_CC_CRAY}
dnl #
dnl #    Check wheter we are using CRAY C++ compiler.
dnl #    If so, set the shell variable "ac_cv_prog_cray_cc"
dnl #    to "yes" and defines HAVE_CRAY_CXX.
dnl #    If not, set the shell variable no "no".
dnl #    The shell variable is also exported for sub-shells.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_PROG_CC_CRAY],
    dnl Since gcc defines also cray, we use CC -V information line
    [AH_TEMPLATE([HAVE_CRAY_CXX], Defines if you have CRAY C++ compiler)]
    [AC_CACHE_CHECK(whether we are using CRAY C, 
	ac_cv_prog_cray_cc,
        [export ac_cv_prog_cray_cc
        if ${CC-cc} -V 2>&1 | egrep "Cray C" >/dev/null 2>/dev/null; then
            ac_cv_prog_cray_cc=yes
        else
            ac_cv_prog_cray_cc=no
        fi]
    )]
    if test x"${ac_cv_prog_cray_cc}" = x"yes"; then
	    [AC_DEFINE(HAVE_CRAY_CXX)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_PROG_CC_DEC}
dnl #
dnl #    Check wheter we are using DEC C++ compiler.
dnl #    If so, set the shell variable "ac_cv_prog_dec_cc"
dnl #    to "yes".
dnl #    If not, set the shell variable no "no".
dnl #    The shell variable is also exported for sub-shells,
dnl #    such as ltconfig from libtool.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_PROG_CC_DEC],
    [AC_CACHE_CHECK(whether we are using DEC C, 
	ac_cv_prog_dec_cc,
        [dnl The semicolon is to pacify NeXT's syntax-checking cpp.
        cat > conftest.cc <<EOF
        #ifdef __DECCXX
            yes;
        #endif
EOF
        dnl export variable for ltconfig (libtool) facility
        export ac_cv_prog_dec_cc
        if AC_TRY_COMMAND(${CC-cc} -E conftest.cc) | egrep yes >/dev/null 2>&1; then
            ac_cv_prog_dec_cc=yes
        else
            ac_cv_prog_dec_cc=no
        fi]
    )]
)
dnl -----------------------------------------------------------------------------
dnl recognize C++
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_RECOGNIZE_CXX}
dnl #
dnl #    Check wheter we are able to recognize the C++ compiler.
dnl #    Tested compilers:
dnl #    @example
dnl #         The KAI  C++ compiler that defines: __KCC     (KCC-3.2b)
dnl #         The GNU  C++ compiler that defines: __GNUC__  (egcs-1.1.1)
dnl #         The CRAY C++ compiler that defines: cray
dnl #         The DEC  C++ compiler that defines: __DECCXX
dnl #    @end example
dnl #
dnl #    If so, substitue RECOGNIZED_CXX to a specific
dnl #    compiler's rule file, e.g, "${top_srcdir}/config/gnu_cxx.mk",
dnl #    for a subsequent Makefile include.
dnl #    If not, substitue to "/dev/null".
dnl #    Substitutes also EXTRA_LDFLAGS.
dnl #    Raw cc is the C compiler associated to the C++ one. By this way
dnl #    C and C++ files are handled with a .c suffix. Special C files that requiere
dnl #    the cc compiler, such as "alloca.c" use some specific makefile rule.
dnl #
dnl # usage example:
dnl # @example
dnl #    AC_PROG_CC(gcc cc cl)
dnl #    AC_PROG_CXX(c++ g++ cxx KCC CC CC cc++ xlC aCC)
dnl #    RHEO_RECOGNIZE_CXX
dnl # @end example
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_RECOGNIZE_CXX],
    [AC_SUBST(RECOGNIZED_CXX)]
    [AC_SUBST(EXTRA_LDFLAGS)]
    [AC_SUBST(OPTIMIZE_CFLAGS)]
    RECOGNIZED_CXX="/dev/null"
    rheo_cxx=other
    if test x"${GXX}" = x"yes"; then
	RECOGNIZED_CXX='${top_srcdir}/config/gnu_cxx.mk'
	rheo_cxx=gnu
    else
        [RHEO_PROG_CC_KAI]
        if test x"${ac_cv_prog_kcc}" = x"yes"; then
            [CXXFLAGS="${CXXFLAGS} --no_implicit_include --abstract_pointer"]
	    RECOGNIZED_CXX='${top_srcdir}/config/kai_cxx.mk'
	    rheo_cxx=kai
        else
            [RHEO_PROG_CC_CRAY]
            if test x"${ac_cv_prog_cray_cc}" = x"yes"; then
                [CXXFLAGS="${CXXFLAGS} -h noimplicitinclude -h new_for_init -h instantiate=used"]
		RECOGNIZED_CXX='${top_srcdir}/config/cray_cxx.mk'
	        rheo_cxx=cray
		[EXTRA_LDFLAGS="${EXTRA_LDFLAGS} -Wl,-D,permok=yes"]
            else
                [RHEO_PROG_CC_DEC]
            	if test x"${ac_cv_prog_dec_cc}" = x"yes"; then
dnl		    smaller libraries sizes: use -tweak and -std gnu
                    [CPPFLAGS="${CPPFLAGS} -D__USE_STD_IOSTREAM"]
                    [CXXFLAGS="${CXXFLAGS} -O2 -w -timplicit_local -std ansi"]
                    [CFLAGS="${CFLAGS} -O2 -w"]
                    [LDFLAGS="${LDFLAGS} -lm"]
	    	    RECOGNIZED_CXX='${top_srcdir}/config/dec_cxx.mk'
	    	    rheo_cxx=dec
	        else
        	    [AC_MSG_RESULT(	WARNING: unknown C++ compiler)]
                fi
            fi
        fi
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_OPTIMIZE_CXX}
dnl #
dnl #    Set some optimization flags associated to the recognized C++ compiler
dnl #    and platform.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_OPTIMIZE_CXX],
    [case x"${rheo_cxx}" in
	x"gnu") 
        	[CXXFLAGS="${CXXFLAGS} -O2"]
		[OPTIMIZE_CFLAGS="-O9"]
		;;
	x"kai")
                [CXXFLAGS="${CXXFLAGS} +K1 -O"]
	    	[OPTIMIZE_CFLAGS="+K3 -O3"]
		;;
	x"cray")
                [CXXFLAGS="${CXXFLAGS} -O"]
	        [OPTIMIZE_CFLAGS="-h inline1,vector3,scalar3,task3 -h ivdep -h restrict=a"]
		;;
	*)
	        [OPTIMIZE_CFLAGS=""]
		;;
     esac]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_LATEX_HYPEREF}
dnl #    @pindex latex
dnl #
dnl #    Check whether the hyperref LaTeX
dnl #    package exists and set the corresponding
dnl #    shell value "rheo_have_latex_hyperref" and 
dnl #    HAVE_LATEX_HYPEREF (for Makefiles) accordingly.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_LATEX_HYPEREF],

    [AC_MSG_CHECKING(for hyperref LaTeX package)]
    [AC_SUBST(HAVE_LATEX_HYPEREF)]

    TEMPDIR=${TEMPDIR-"/tmp"}
    basetmp=$TEMPDIR/conftest$$
    textmp=$basetmp.tex

    cat > $textmp << EOF 
	\batchmode
	\documentclass{article}
	\usepackage{hyperref}
	\begin{document}
	  a
	\end{document}
EOF
	test x"$LATEX" != x"" && $LATEX $textmp >/dev/null 2>/dev/null
	status=$?
	/bin/rm -f $basetmp.tex $basetmp.dvi $basetmp.aux $basetmp.log

	if test $status -eq 0; then 
	    rheo_have_latex_hyperref=yes
	    HAVE_LATEX_HYPEREF=YES
	else
	    rheo_have_latex_hyperref=no
	    HAVE_LATEX_HYPEREF=NO
	fi
        [AC_MSG_RESULT(${rheo_have_latex_hyperref})]
)
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CXX_FLAGS_IEEE],

    if test x"${ac_cv_cxx_compiler_gnu=yes}" = x"yes"; then
        [AC_MSG_CHECKING(for c++ ieee flag)]
        [AC_SUBST(CXXFLAGS_IEEE)]
        [CXXFLAGS_IEEE=""]
        mach="`uname -m`"
        [case $mach in
          i*86|*86_64)
             [CXXFLAGS_IEEE="-ffloat-store -mieee-fp"]
             ;;
        esac]
        [AC_MSG_RESULT(${CXXFLAGS_IEEE})]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #  
dnl #    @code{RHEO_CHECK_MPI}
dnl #
dnl #    Check for the "mpirun" command, the
dnl #    corresponding header "mpi.h" and library "-lmpi" are available.
dnl #    If so, set the shell variable "rheo_have_mpi"
dnl #    to "yes", defines HAVE_MPI and substitues MPIRUN to "mpirun" and
dnl #    RUN to "mpirun -np 2",
dnl #    INCLUDES_MPI and LDADD_MPI.
dnl #    If not, set the shell variable no "no".
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_MPI],
    [AH_TEMPLATE([HAVE_MPI], Defines if you have mpi library)]
    [AC_SUBST(MPIRUN)]
    [AC_SUBST(RUN)]
    [AC_SUBST(INCLUDES_MPI)]
    [AC_SUBST(LDADD_MPI)]
    [AC_SUBST(INCLUDES_BOOST_MPI)]
    [AC_SUBST(LDADD_BOOST_MPI)]
    rheo_have_mpi=yes
    [AC_PATH_PROG(PATH_MPIRUN, mpirun)]
    if test x"${PATH_MPIRUN}" = x""; then
        rheo_have_mpi=no
    else
        MPIRUN="mpirun"
    fi
    if test x"${rheo_have_mpi}" = x"yes"; then
        [AC_MSG_CHECKING(for mpi style)]
        rheo_recognized_mpi=no
        if test `$MPIRUN --help 2>&1 | grep OpenRTE | wc -l` -ge 1; then
          rheo_recognized_mpi=openmpi
        elif test `$MPIRUN --help 2>&1 | grep 'MPICH1 compat' | wc -l` -ge 1; then
          rheo_recognized_mpi=mpich2
        elif test `$MPIRUN -h 2>&1 | grep 'mpich/bin' | wc -l` -ge 1; then
          rheo_recognized_mpi=mpich1
	elif test `$MPIRUN -h 2>&1 | grep 'LAM/MPI' | wc -l` -ge 1; then
  	  rheo_recognized_mpi=lam
        fi
        [AC_MSG_RESULT(${rheo_recognized_mpi})]
	[case ${rheo_recognized_mpi} in
          mpich1)
	    INCLUDES_MPI="-I/usr/lib/mpich/include"
	    LDADD_MPI="-L/usr/lib/mpich/lib -lpmpich++ -lmpich -lpthread -lrt"
	    ;;
          mpich2)
	    INCLUDES_MPI="-I/usr/include/mpich2"
	    LDADD_MPI="-lmpichcxx -lmpich -lpthread -lrt"
	    ;;
          openmpi)
	    if test x"${rheo_libdir_mpi}" = x""; then
	        rheo_libdir_mpi="/usr/lib/openmpi/lib"
  	    fi
	    if test x"${rheo_incdir_mpi}" = x""; then
	        rheo_incdir_mpi="/usr/lib/openmpi/include"
	    fi
	    INCLUDES_MPI="-pthread -I${rheo_incdir_mpi}"
	    LDADD_MPI="-pthread -L${rheo_libdir_mpi} -lmpi_cxx -lmpi -lopen-rte -lopen-pal"
	    ;;
          lam)
	    INCLUDES_MPI="-I/usr/include/lam"
	    LDADD_MPI="-llam++ -llam -llamio"
	    ;;
          *)
	    INCLUDES_MPI=""
	    LDADD_MPI="-lmpi"
	    ;;
	esac]
        [AC_MSG_CHECKING(for mpi includes)]
        [AC_MSG_RESULT(${INCLUDES_MPI})]
        [AC_MSG_CHECKING(for libmpi)]
        [AC_MSG_RESULT(${LDADD_MPI})]
        PREV_LIBS="$LIBS"
        LIBS="${LIBS} ${LDADD_MPI}"
        PREV_CXXFLAGS="$CXXFLAGS"
        CXXFLAGS="${CXXFLAGS} ${INCLUDES_MPI} ${INCLUDES_BOOST}"
        PREV_CPPFLAGS="$CPPFLAGS"
        CPPFLAGS="${CPPFLAGS} ${INCLUDES_MPI} ${INCLUDES_BOOST}"
        [AC_CHECK_HEADERS(mpi.h, [true], [rheo_have_mpi=no])]
        [AC_CHECK_HEADERS(boost/mpi.hpp, [true], [rheo_have_boost_mpi=no])]
        if test x"${rheo_have_boost_mpi}" != x"no"; then
	    INCLUDE_BOOST_MPI="${INCLUDES_BOOST}"
	    LDADD_BOOST_MPI="${LDADD_BOOST} -lboost_mpi -lboost_serialization"
            [AC_MSG_CHECKING(for boost::mpi)]
            [AC_MSG_RESULT(${LDADD_BOOST_MPI})]
        fi
        LIBS="$PREV_LIBS"
        CXXFLAGS="$PREV_CXXFLAGS"
        CPPFLAGS="$PREV_CPPFLAGS"
    fi
    if test x"${rheo_have_mpi}" = x"yes"; then
        [AC_MSG_CHECKING(if programs compile with mpi)]
        /bin/rm -f core; touch core; chmod a-w core
        PREV_LIBS="$LIBS"
        LIBS="${LIBS} ${LDADD_MPI}"
        PREV_CXXFLAGS="$CXXFLAGS"
        CXXFLAGS="${CXXFLAGS} ${INCLUDES_MPI}"
        [AC_TRY_COMPILE(
	    changequote(%%, %%)dnl
	    %%
                #include <mpi.h>
	    %%,
	    %%
     		    MPI_Init(0,0);
     		    MPI_Finalize();
	    %%,
	    changequote([, ])dnl
	    rheo_have_mpi=yes,
	    rheo_have_mpi=no
        )]
        [AC_MSG_RESULT($rheo_have_mpi)]
        /bin/rm -f core
        LIBS="$PREV_LIBS"
        CXXFLAGS="$PREV_CXXFLAGS"
    fi
    if test x"${rheo_have_mpi}" = x"yes"; then
	[AC_DEFINE(HAVE_MPI)]
    else
	# MPIRUN=""
	# INCLUDES_MPI=""
	# LDADD_MPI=""
	# defines it despite, for hand-made debug of config.mk file:
	[AC_DEFINE(HAVE_MPI)]
        [AC_MSG_ERROR(prheolef requires MPI and boost::mpi)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_PARMETIS}
dnl #
dnl #    Check for the "parmetis" and "metis" libraries.
dnl #    Defines HAVE_PARMETIS and substitues 
dnl #    INCLUDES_MPI and LDADD_MPI.
dnl #	 Requires the MPI library.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_PARMETIS],
    [AH_TEMPLATE([HAVE_PARMETIS], Defines if you have parmetis and metis mesh partitionner libraries)]
    [AC_SUBST(INCLUDES_PARMETIS)]
    [AC_SUBST(LDADD_PARMETIS)]
    [AC_MSG_CHECKING(for parmetis library)]
    rheo_have_parmetis=yes
    if test x"${rheo_libdir_parmetis}" != x"yes" -a x"${rheo_libdir_parmetis}" != x""; then
       libpath="${rheo_libdir_parmetis} ${rheo_libdir_parmetis}/lib"
    else
       libpath="/usr/lib /lib"
    fi
    rheo_libdir_parmetis=""
    for d in ${libpath}; do
        if test -f $d/libparmetis.so -a -f $d/libmetis.so || test -f $d/libparmetis.a -a -f $d/libmetis.a; then
          rheo_libdir_parmetis=$d
	  break
        fi
    done
    if test x"${rheo_libdir_parmetis}" = x""; then
        rheo_have_parmetis="no"
    fi
    if test x"${rheo_have_parmetis}" = x"yes"; then
	[AC_DEFINE(HAVE_PARMETIS)]
        INCLUDES_PARMETIS=""
        LDADD_PARMETIS="-lparmetis -lmetis"
        if test "${rheo_libdir_parmetis}" != "/lib" -a "${rheo_libdir_parmetis}" != "/usr/lib"; then
          LDADD_PARMETIS="-L${rheo_libdir_parmetis} ${LDADD_PARMETIS}"
        fi
	rheo_have_parmetis=yes
        [AC_MSG_RESULT(${LDADD_PARMETIS})]
    else
	rheo_have_parmetis=no
        [AC_MSG_RESULT(no)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_SCOTCH}
dnl #
dnl #    Check for the "scotch" distributed mesh partitionner libraries.
dnl #    Defines HAVE_SCOTCH and substitues 
dnl #    INCLUDES_SCOTCH and LDADD_SCOTCH.
dnl #	 Requires the MPI library.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_SCOTCH],
    [AH_TEMPLATE([HAVE_SCOTCH], Defines if you have the scotch distributed mesh partitionner libraries)]
    [AC_SUBST(INCLUDES_SCOTCH)]
    [AC_SUBST(LDADD_SCOTCH)]
    [AC_MSG_CHECKING(for scotch library)]
    rheo_have_scotch=yes
    if test x"${rheo_libdir_scotch}" != x"yes" -a x"${rheo_libdir_scotch}" != x""; then
       libpath="${rheo_libdir_scotch} ${rheo_libdir_scotch}/lib"
    else
       libpath="/usr/lib /lib"
    fi
    rheo_libdir_scotch=""
    for d in ${libpath}; do
        founded=false
        # sequential libs:
        if test -f $d/libscotch.so -a -f $d/libscotcherrexit.so || test -f $d/libscotch.a -a -f $d/libscotcherrexit.a ; then
	    founded=true
        fi
        # distributed libs:
        if $founded && test x"${rheo_have_mpi}" = x"yes"; then
          if test -f $d/libptscotchparmetis.so -a -f $d/libptscotch.so -a -f $d/libptscotcherrexit.so || test -f $d/libptscotchparmetis.a -a -f $d/libptscotch.a -a -f $d/libptscotcherrexit.a ; then
	    true
          else
	    founded=true
          fi
        fi
        if $founded; then
          rheo_libdir_scotch=$d
          break
	fi
    done
    if test x"${rheo_libdir_scotch}" = x""; then
        rheo_have_scotch="no"
    fi
    if test x"${rheo_have_scotch}" = x"yes"; then
	[AC_DEFINE(HAVE_SCOTCH)]
        INCLUDES_SCOTCH=""
        LDADD_SCOTCH=""
        if test x"${rheo_have_mpi}" = x"yes"; then
          LDADD_SCOTCH="-lptscotchparmetis -lptscotch -lptscotcherrexit"
        fi
        LDADD_SCOTCH="$LDADD_SCOTCH -lscotch -lscotcherrexit"
        if test "${rheo_libdir_scotch}" != "/lib" -a "${rheo_libdir_scotch}" != "/usr/lib"; then
          LDADD_SCOTCH="-L${rheo_libdir_scotch} ${LDADD_SCOTCH}"
        fi
	rheo_have_scotch=yes
        [AC_MSG_RESULT(${LDADD_SCOTCH})]
    else
	rheo_have_scotch=no
        [AC_MSG_RESULT(no)]
    fi
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_BLAS}
dnl #
dnl #    Check for the "blas" basic linear algebra subroutines library.
dnl #    Defines HAVE_BLAS and substitues LDADD_BLAS and INCLUDES_BLAS.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_BLAS],
    [AH_TEMPLATE([HAVE_BLAS], Defines if you have the basic linea algebra subroutines libraries)]
    [AC_SUBST(INCLUDES_BLAS)]
    [AC_SUBST(LDADD_BLAS)]
    [AC_MSG_CHECKING(for blas library)]
    rheo_have_blas=yes
    INCLUDES_BLAS=""
    if test x"${rheo_ldadd_blas}" != x"yes" -a x"${rheo_ldadd_blas}" != x""; then
      LDADD_BLAS="${rheo_ldadd_blas}"
    elif test x"${rheo_libdir_blas}" != x"yes" -a x"${rheo_libdir_blas}" != x""; then
      LDADD_BLAS="-L${rheo_libdir_blas} -lblas"
    else
      LDADD_BLAS="-lblas"
    fi
    [AC_DEFINE(HAVE_BLAS)]
    [AC_MSG_RESULT(${LDADD_BLAS})]
)
dnl -----------------------------------------------------------------------------
dnl #
dnl #    @code{RHEO_CHECK_PASTIX}
dnl #
dnl #    Check for the "pastix" distributed direct solver libraries.
dnl #    Defines HAVE_PASTIX and substitues 
dnl #    INCLUDES_PASTIX and LDADD_PASTIX.
dnl #	 Requires the MPI and SCOTCH libraries.
dnl -----------------------------------------------------------------------------
AC_DEFUN([RHEO_CHECK_PASTIX],
    [AH_TEMPLATE([HAVE_PASTIX], Defines if you have the pastix distributed direct solver libraries)]
    [AC_SUBST(INCLUDES_PASTIX)]
    [AC_SUBST(LDADD_PASTIX)]
    [AC_MSG_CHECKING(for pastix library)]
    rheo_have_pastix=yes
    if test x"${rheo_libdir_pastix}" = x"yes" -o x"${rheo_libdir_pastix}" = x""; then
      rheo_libdir_pastix="\${HOME}/lib"
    fi
    if test x"${rheo_have_mpi}" = x"yes"; then
      LDADD_PASTIX="-L${rheo_libdir_pastix} -lpastix -lrt \${LDADD_BLAS}"
    else
      LDADD_PASTIX="-L${rheo_libdir_pastix} -lpastix_32bit_nompi_smp_int_double_real_scotch_i686_pc_linux -lrt -lpthread ${LDADD_BLAS}"
    fi
    if test x"${rheo_incdir_pastix}" = x"yes" -o x"${rheo_incdir_pastix}" = x""; then
      rheo_incdir_pastix="\${HOME}/include/pastix"
    fi
    INCLUDES_PASTIX="-I${rheo_incdir_pastix}"
    [AC_DEFINE(HAVE_PASTIX)]
    [AC_MSG_RESULT(${LDADD_PASTIX})]
)
dnl -----------------------------------------------------------------------------
dnl #SEE ALSO:
dnl #    "autoconf"(1), "automake"(1), 
dnl #    "libtool"(1), "make"(1)
dnl #AUTHOR:
dnl #      Pierre Saramito
dnl #	 | Pierre.Saramito@imag.fr
dnl #    LMC-IMAG,
dnl #    38041 Grenoble cedex 9, France
dnl #
dnl #DATE: 15 january 1999
dnl #END:
dnl -----------------------------------------------------------------------------
