///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/vec_expr.h"
#include "rheolef/parstream.h"
using namespace rheolef;
using namespace std;

struct phi : unary_function<Float,Float> {
  Float operator() (const Float& x) { return 2*x; }
};
int main(int argc, char**argv) {
    environment parallel(argc, argv);
    size_t n = (argc < 2) ? 5 : atoi(argv[1]);
    vec<Float> x(n, 2.);
    vec<Float> y(n, 3.);

    // set size and then assign:
    vec<Float> z(n); 
    z = 2.*x - y;
    pcout << "z = " << z.par_size() << endl;
    z.put (pcout);
    
    // size is zero and then assign:
    vec<Float> z1; 
    z1 = 2.*x - y;
    pcout << "z1 = " << z1.par_size() << endl;
    z1.put (pcout);
    
    // copy cstor:
    vec<Float> z2 = 2.*x - y;
    pcout << "z2 = " << z2.par_size() << endl;
    z2.put (pcout);

#ifdef TO_CLEAN    
    // set bad size and then assign:
    vec<Float> z3(n+1); 
    z3 = 2*x - y;
    pcout << "z3 = " << z3.size() << endl;
    z3.put (pcout);
#endif // TO_CLEAN    
}
