#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#
# bug: des que n<np : vecteur localement nul et ca plante
#  mais T=geo_element tandisque T=double est ok (vec_io_tst)
#
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
NPROC_MAX=${NPROC_MAX-"7"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

loop_mpirun "./polymorphic_array_element_io_tst < bielle.dat 2>/dev/null | diff -B -w - bielle.dat >/dev/null"
if test $? -ne 0; then status=1; fi

for i in 101 5 4 3 2 1; do
  run "echo | LANG=C awk -v n=${i} -f ${SRCDIR}/gen_array_element.awk > array_element-${i}.dat"
  if test $? -ne 0; then status=1; break; fi

  loop_mpirun "./polymorphic_array_element_io_tst < array_element-${i}.dat 2>/dev/null | diff -B -w - array_element-${i}.dat >/dev/null"
  if test $? -ne 0; then status=1; fi

  run "rm -f array_element-${i}.dat"
  if test $? -ne 0; then status=1; break; fi
  i=`expr ${i} - 1`
done

exit $status
