///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// authors: Nicolas.Roquet@imag.fr
//
// date: 11 dec 1998
//
// ============================================================================
//  Includes
// ============================================================================

#include "rheolef/trace.h"
#include "rheolef/field.h"
#include "rheolef/blas2.h"
#include "rheolef/tiny_matvec.h"
using namespace std;
namespace rheolef { 

// ============================================================================
//  Cstors
// ============================================================================

extern void form_trace_assembly (form&, const domain&);

trace::trace (const space& V, const space& W)
  : form()
{
  V.freeze();
  W.freeze();
  X_ = V;
  Y_ = W;
  if (!W.is_on_boundary_domain ()) {
    error_macro ("usage: trace(space, domain_space)");
  }
  const domain& d = W.get_boundary_domain();
  form_trace_assembly(*this, d);
}
}// namespace rheolef
