// file automatically generated by "basis_symbolic_cxx.cc"
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P2.h"
using namespace rheolef;
using namespace std;
class basis_P2_p {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_e {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_t {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_q {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
class basis_P2_T {
public:
  typedef size_t size_type;
  static basis_rep::dof_family_type dof_family(
    size_type    i_dof_local);
  static Float eval(
    size_type    i_dof_local,
    const point& hat_x);
  static point grad_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static basic_point<point> hessian_eval(
    size_type    i_dof_local,
    const point& hat_x);
  static void eval(
    const point&   hat_x,
    vector<Float>& values);
  static void grad_eval(
    const point&   hat_x,
    vector<point>& values);
  static void hessian_eval(
    const point&   hat_x,
    vector<basic_point<point> >& values);
  static void hat_node(
    vector<point>& hat_node);
};
basis_rep::dof_family_type
basis_P2_p::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P2_p::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val = 1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_p::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P2_p::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_p::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(1);
  typedef Float T;
  values[0] = 1.0;
}
void
basis_P2_p::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(1);
  typedef Float T;
}
void
basis_P2_p::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(1,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_p::hat_node(
  vector<point>& x)
{
  x.resize(1);
  x[0] = point();
}
basis_rep::dof_family_type
basis_P2_e::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P2_e::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-3.0000000000000000e+00*hat_x[0]+1.0;
      return val;
    }
    case 1: {
      val = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 2: {
      val =  -4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_e::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
      return val;
    }
    case 1: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
      return val;
    }
    case 2: {
      val[0] =  -8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P2_e::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_e::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(3);
  typedef Float T;
  values[0] =  -3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+1.0;
  values[1] =  2.0000000000000000e+00*(hat_x[0]*hat_x[0])-hat_x[0];
  values[2] =  4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]);
}
void
basis_P2_e::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(3);
  typedef Float T;
  values[0][0] =  4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[1][0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[2][0] =  -8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
}
void
basis_P2_e::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(3,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_e::hat_node(
  vector<point>& x)
{
  x.resize(3);
  x[0] = point(0.0);
  x[1] = point(1.0);
  x[2] = point(5.0000000000000000e-01);
}
basis_rep::dof_family_type
basis_P2_t::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P2_t::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  -3.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+2.0000000000000000e+00*(hat_x[1]*hat_x[1])+-3.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]*hat_x[0]+1.0;
      return val;
    }
    case 1: {
      val = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 2: {
      val = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 3: {
      val =  -4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]*hat_x[0];
      return val;
    }
    case 4: {
      val = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
      return val;
    }
    case 5: {
      val =  -4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_t::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
      val[1] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      return val;
    }
    case 1: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
      val[1] = 0.0;
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
      return val;
    }
    case 3: {
      val[0] =  -4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      val[1] = -4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 4: {
      val[0] = 4.0000000000000000e+00*hat_x[1];
      val[1] = 4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 5: {
      val[0] = -4.0000000000000000e+00*hat_x[1];
      val[1] =  -8.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P2_t::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_t::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(6);
  typedef Float T;
  values[0] =  2.0000000000000000e+00*(hat_x[1]*hat_x[1])+4.0000000000000000e+00*hat_x[0]*hat_x[1]+-3.0000000000000000e+00*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-3.0000000000000000e+00*hat_x[1]+1.0;
  values[1] = -hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0]);
  values[2] = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
  values[3] =  -4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0])+4.0000000000000000e+00*hat_x[0];
  values[4] = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
  values[5] =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+-4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[1];
}
void
basis_P2_t::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(6);
  typedef Float T;
  values[0][0] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
  values[0][1] =  4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[0]-3.0000000000000000e+00;
  values[1][0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[1][1] = 0.0;
  values[2][0] = 0.0;
  values[2][1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
  values[3][0] =  -4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
  values[3][1] = -4.0000000000000000e+00*hat_x[0];
  values[4][0] = 4.0000000000000000e+00*hat_x[1];
  values[4][1] = 4.0000000000000000e+00*hat_x[0];
  values[5][0] = -4.0000000000000000e+00*hat_x[1];
  values[5][1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00;
}
void
basis_P2_t::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(6,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_t::hat_node(
  vector<point>& x)
{
  x.resize(6);
  x[0] = point(0.0, 0.0);
  x[1] = point(1.0, 0.0);
  x[2] = point(0.0, 1.0);
  x[3] = point(5.0000000000000000e-01, 0.0);
  x[4] = point(5.0000000000000000e-01, 5.0000000000000000e-01);
  x[5] = point(0.0, 5.0000000000000000e-01);
}
basis_rep::dof_family_type
basis_P2_q::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P2_q::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  (hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/4.0-(hat_x[0]*hat_x[0])*hat_x[1]/4.0+hat_x[0]*hat_x[1]/4.0-hat_x[0]*(hat_x[1]*hat_x[1])/4.0;
      return val;
    }
    case 1: {
      val =  hat_x[0]*(hat_x[1]*hat_x[1])/4.0-hat_x[0]*hat_x[1]/4.0-(hat_x[0]*hat_x[0])*hat_x[1]/4.0+(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/4.0;
      return val;
    }
    case 2: {
      val =  hat_x[1]*hat_x[0]/4.0+hat_x[1]*(hat_x[0]*hat_x[0])/4.0+(hat_x[1]*hat_x[1])*(hat_x[0]*hat_x[0])/4.0+(hat_x[1]*hat_x[1])*hat_x[0]/4.0;
      return val;
    }
    case 3: {
      val = -hat_x[0]*hat_x[1]/4.0-hat_x[0]*(hat_x[1]*hat_x[1])/4.0+(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/4.0+(hat_x[0]*hat_x[0])*hat_x[1]/4.0;
      return val;
    }
    case 4: {
      val =  (hat_x[1]*hat_x[1])/2.0-hat_x[1]/2.0+(hat_x[0]*hat_x[0])*hat_x[1]/2.0-(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0;
      return val;
    }
    case 5: {
      val = -(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0+hat_x[0]/2.0-hat_x[0]*(hat_x[1]*hat_x[1])/2.0+(hat_x[0]*hat_x[0])/2.0;
      return val;
    }
    case 6: {
      val = -(hat_x[0]*hat_x[0])*hat_x[1]/2.0-(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0+hat_x[1]/2.0+(hat_x[1]*hat_x[1])/2.0;
      return val;
    }
    case 7: {
      val =  (hat_x[1]*hat_x[1])*hat_x[0]/2.0-(hat_x[1]*hat_x[1])*(hat_x[0]*hat_x[0])/2.0+(hat_x[0]*hat_x[0])/2.0-hat_x[0]/2.0;
      return val;
    }
    case 8: {
      val = -(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])+1.0;
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_q::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] = -(hat_x[1]*hat_x[1])/4.0+hat_x[1]/4.0+hat_x[0]*(hat_x[1]*hat_x[1])/2.0-hat_x[0]*hat_x[1]/2.0;
      val[1] =  (hat_x[0]*hat_x[0])*hat_x[1]/2.0-hat_x[0]*hat_x[1]/2.0+hat_x[0]/4.0-(hat_x[0]*hat_x[0])/4.0;
      return val;
    }
    case 1: {
      val[0] = -hat_x[0]*hat_x[1]/2.0+hat_x[0]*(hat_x[1]*hat_x[1])/2.0-hat_x[1]/4.0+(hat_x[1]*hat_x[1])/4.0;
      val[1] = -(hat_x[0]*hat_x[0])/4.0+hat_x[1]*(hat_x[0]*hat_x[0])/2.0-hat_x[0]/4.0+hat_x[1]*hat_x[0]/2.0;
      return val;
    }
    case 2: {
      val[0] =  (hat_x[1]*hat_x[1])/4.0+hat_x[0]*hat_x[1]/2.0+hat_x[1]/4.0+hat_x[0]*(hat_x[1]*hat_x[1])/2.0;
      val[1] =  hat_x[0]/4.0+hat_x[0]*hat_x[1]/2.0+(hat_x[0]*hat_x[0])/4.0+(hat_x[0]*hat_x[0])*hat_x[1]/2.0;
      return val;
    }
    case 3: {
      val[0] = -hat_x[1]/4.0+(hat_x[1]*hat_x[1])*hat_x[0]/2.0+hat_x[1]*hat_x[0]/2.0-(hat_x[1]*hat_x[1])/4.0;
      val[1] =  (hat_x[0]*hat_x[0])*hat_x[1]/2.0+(hat_x[0]*hat_x[0])/4.0-hat_x[0]/4.0-hat_x[0]*hat_x[1]/2.0;
      return val;
    }
    case 4: {
      val[0] = -(hat_x[1]*hat_x[1])*hat_x[0]+hat_x[1]*hat_x[0];
      val[1] = -(hat_x[0]*hat_x[0])*hat_x[1]+(hat_x[0]*hat_x[0])/2.0+hat_x[1]-(1.0/2.0);
      return val;
    }
    case 5: {
      val[0] =  hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1])-(hat_x[1]*hat_x[1])/2.0+(1.0/2.0);
      val[1] = -hat_x[1]*(hat_x[0]*hat_x[0])-hat_x[1]*hat_x[0];
      return val;
    }
    case 6: {
      val[0] = -hat_x[0]*(hat_x[1]*hat_x[1])-hat_x[0]*hat_x[1];
      val[1] = -(hat_x[0]*hat_x[0])*hat_x[1]+hat_x[1]-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
      return val;
    }
    case 7: {
      val[0] =  (hat_x[1]*hat_x[1])/2.0+hat_x[0]-(hat_x[1]*hat_x[1])*hat_x[0]-(1.0/2.0);
      val[1] =  hat_x[0]*hat_x[1]-(hat_x[0]*hat_x[0])*hat_x[1];
      return val;
    }
    case 8: {
      val[0] =  -2.0*hat_x[0]+2.0*hat_x[0]*(hat_x[1]*hat_x[1]);
      val[1] =  -2.0*hat_x[1]+2.0*hat_x[1]*(hat_x[0]*hat_x[0]);
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P2_q::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_q::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(9);
  typedef Float T;
  values[0] = -hat_x[0]*(hat_x[1]*hat_x[1])/4.0+hat_x[0]*hat_x[1]/4.0-(hat_x[0]*hat_x[0])*hat_x[1]/4.0+(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/4.0;
  values[1] = -hat_x[0]*hat_x[1]/4.0+hat_x[0]*(hat_x[1]*hat_x[1])/4.0+(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/4.0-(hat_x[0]*hat_x[0])*hat_x[1]/4.0;
  values[2] =  (hat_x[1]*hat_x[1])*hat_x[0]/4.0+(hat_x[1]*hat_x[1])*(hat_x[0]*hat_x[0])/4.0+hat_x[1]*(hat_x[0]*hat_x[0])/4.0+hat_x[1]*hat_x[0]/4.0;
  values[3] = -hat_x[0]*(hat_x[1]*hat_x[1])/4.0-hat_x[0]*hat_x[1]/4.0+(hat_x[0]*hat_x[0])*hat_x[1]/4.0+(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/4.0;
  values[4] =  (hat_x[1]*hat_x[1])/2.0-hat_x[1]/2.0+(hat_x[0]*hat_x[0])*hat_x[1]/2.0-(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0;
  values[5] = -(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0+hat_x[0]/2.0-hat_x[0]*(hat_x[1]*hat_x[1])/2.0+(hat_x[0]*hat_x[0])/2.0;
  values[6] = -(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0-(hat_x[0]*hat_x[0])*hat_x[1]/2.0+hat_x[1]/2.0+(hat_x[1]*hat_x[1])/2.0;
  values[7] = -hat_x[0]/2.0+hat_x[0]*(hat_x[1]*hat_x[1])/2.0+(hat_x[0]*hat_x[0])/2.0-(hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])/2.0;
  values[8] =  (hat_x[0]*hat_x[0])*(hat_x[1]*hat_x[1])-(hat_x[1]*hat_x[1])-(hat_x[0]*hat_x[0])+1.0;
}
void
basis_P2_q::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(9);
  typedef Float T;
  values[0][0] =  hat_x[1]/4.0-(hat_x[1]*hat_x[1])/4.0+hat_x[0]*(hat_x[1]*hat_x[1])/2.0-hat_x[0]*hat_x[1]/2.0;
  values[0][1] = -(hat_x[0]*hat_x[0])/4.0-hat_x[1]*hat_x[0]/2.0+hat_x[0]/4.0+hat_x[1]*(hat_x[0]*hat_x[0])/2.0;
  values[1][0] =  (hat_x[1]*hat_x[1])/4.0-hat_x[0]*hat_x[1]/2.0-hat_x[1]/4.0+hat_x[0]*(hat_x[1]*hat_x[1])/2.0;
  values[1][1] = -hat_x[0]/4.0+hat_x[0]*hat_x[1]/2.0-(hat_x[0]*hat_x[0])/4.0+(hat_x[0]*hat_x[0])*hat_x[1]/2.0;
  values[2][0] =  hat_x[1]/4.0+(hat_x[1]*hat_x[1])*hat_x[0]/2.0+(hat_x[1]*hat_x[1])/4.0+hat_x[1]*hat_x[0]/2.0;
  values[2][1] =  (hat_x[0]*hat_x[0])/4.0+hat_x[0]/4.0+(hat_x[0]*hat_x[0])*hat_x[1]/2.0+hat_x[0]*hat_x[1]/2.0;
  values[3][0] =  (hat_x[1]*hat_x[1])*hat_x[0]/2.0-hat_x[1]/4.0-(hat_x[1]*hat_x[1])/4.0+hat_x[1]*hat_x[0]/2.0;
  values[3][1] =  (hat_x[0]*hat_x[0])/4.0+(hat_x[0]*hat_x[0])*hat_x[1]/2.0-hat_x[0]/4.0-hat_x[0]*hat_x[1]/2.0;
  values[4][0] = -hat_x[0]*(hat_x[1]*hat_x[1])+hat_x[0]*hat_x[1];
  values[4][1] =  hat_x[1]+(hat_x[0]*hat_x[0])/2.0-hat_x[1]*(hat_x[0]*hat_x[0])-(1.0/2.0);
  values[5][0] =  hat_x[0]-hat_x[0]*(hat_x[1]*hat_x[1])-(hat_x[1]*hat_x[1])/2.0+(1.0/2.0);
  values[5][1] = -hat_x[1]*hat_x[0]-hat_x[1]*(hat_x[0]*hat_x[0]);
  values[6][0] = -hat_x[0]*hat_x[1]-hat_x[0]*(hat_x[1]*hat_x[1]);
  values[6][1] =  hat_x[1]-(hat_x[0]*hat_x[0])*hat_x[1]-(hat_x[0]*hat_x[0])/2.0+(1.0/2.0);
  values[7][0] = -(hat_x[1]*hat_x[1])*hat_x[0]+(hat_x[1]*hat_x[1])/2.0+hat_x[0]-(1.0/2.0);
  values[7][1] =  hat_x[0]*hat_x[1]-(hat_x[0]*hat_x[0])*hat_x[1];
  values[8][0] =  -2.0*hat_x[0]+2.0*hat_x[0]*(hat_x[1]*hat_x[1]);
  values[8][1] =  -2.0*hat_x[1]+2.0*hat_x[1]*(hat_x[0]*hat_x[0]);
}
void
basis_P2_q::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(9,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_q::hat_node(
  vector<point>& x)
{
  x.resize(9);
  x[0] = point(-1.0, -1.0);
  x[1] = point(1.0, -1.0);
  x[2] = point(1.0, 1.0);
  x[3] = point(-1.0, 1.0);
  x[4] = point(0.0, -1.0);
  x[5] = point(1.0, 0.0);
  x[6] = point(0.0, 1.0);
  x[7] = point(-1.0, 0.0);
  x[8] = point(0.0, 0.0);
}
basis_rep::dof_family_type
basis_P2_T::dof_family(
  size_type    i_dof_local)
{
  return reference_element::Lagrange;
}
Float
basis_P2_T::eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  T val = 0;
  switch (i_dof_local) {
    case 0: {
      val =  4.0000000000000000e+00*hat_x[1]*hat_x[0]+2.0000000000000000e+00*(hat_x[1]*hat_x[1])+-3.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]*hat_x[0]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-3.0000000000000000e+00*hat_x[2]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])+4.0000000000000000e+00*hat_x[1]*hat_x[2]+-3.0000000000000000e+00*hat_x[0]+1.0;
      return val;
    }
    case 1: {
      val =  2.0000000000000000e+00*(hat_x[0]*hat_x[0])-hat_x[0];
      return val;
    }
    case 2: {
      val = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
      return val;
    }
    case 3: {
      val = -hat_x[2]+2.0000000000000000e+00*(hat_x[2]*hat_x[2]);
      return val;
    }
    case 4: {
      val =  -4.0000000000000000e+00*hat_x[2]*hat_x[0]+-4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]);
      return val;
    }
    case 5: {
      val = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
      return val;
    }
    case 6: {
      val =  -4.0000000000000000e+00*(hat_x[1]*hat_x[1])+-4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]*hat_x[1];
      return val;
    }
    case 7: {
      val =  4.0000000000000000e+00*hat_x[2]+-4.0000000000000000e+00*hat_x[2]*hat_x[0]+-4.0000000000000000e+00*hat_x[2]*hat_x[1]+-4.0000000000000000e+00*(hat_x[2]*hat_x[2]);
      return val;
    }
    case 8: {
      val = 4.0000000000000000e+00*hat_x[0]*hat_x[2];
      return val;
    }
    case 9: {
      val = 4.0000000000000000e+00*hat_x[1]*hat_x[2];
      return val;
    }
    default : {
      error_macro ("eval: invalid i_dof_local = " << i_dof_local);
      return 0;
    }
  }
}
point
basis_P2_T::grad_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point val;
  switch (i_dof_local) {
    case 0: {
      val[0] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]-3.0000000000000000e+00;
      val[1] =  4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      val[2] =  4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]-3.0000000000000000e+00;
      return val;
    }
    case 1: {
      val[0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
      val[1] = 0.0;
      val[2] = 0.0;
      return val;
    }
    case 2: {
      val[0] = 0.0;
      val[1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
      val[2] = 0.0;
      return val;
    }
    case 3: {
      val[0] = 0.0;
      val[1] = 0.0;
      val[2] =  4.0000000000000000e+00*hat_x[2]-1.0000000000000000e+00;
      return val;
    }
    case 4: {
      val[0] =  -4.0000000000000000e+00*hat_x[2]+-8.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00;
      val[1] = -4.0000000000000000e+00*hat_x[0];
      val[2] = -4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 5: {
      val[0] = 4.0000000000000000e+00*hat_x[1];
      val[1] = 4.0000000000000000e+00*hat_x[0];
      val[2] = 0.0;
      return val;
    }
    case 6: {
      val[0] = -4.0000000000000000e+00*hat_x[1];
      val[1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00;
      val[2] = -4.0000000000000000e+00*hat_x[1];
      return val;
    }
    case 7: {
      val[0] = -4.0000000000000000e+00*hat_x[2];
      val[1] = -4.0000000000000000e+00*hat_x[2];
      val[2] =  -4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00;
      return val;
    }
    case 8: {
      val[0] = 4.0000000000000000e+00*hat_x[2];
      val[1] = 0.0;
      val[2] = 4.0000000000000000e+00*hat_x[0];
      return val;
    }
    case 9: {
      val[0] = 0.0;
      val[1] = 4.0000000000000000e+00*hat_x[2];
      val[2] = 4.0000000000000000e+00*hat_x[1];
      return val;
    }
    default : {
      error_macro ("grad_eval: invalid i_dof_local = " << i_dof_local);
      return point();
    }
  }
}
basic_point<point>
basis_P2_T::hessian_eval(
  size_type    i_dof_local,
  const point& hat_x)
{
  typedef Float T;
  point ini_p(0);
  basic_point<point> val(ini_p,ini_p,ini_p);
  error_macro ("hessian_eval: invalid basis P2");
  return val;
}
void
basis_P2_T::eval(
  const point&   hat_x,
  vector<Float>& values)
{
  values.resize(10);
  typedef Float T;
  values[0] =  4.0000000000000000e+00*hat_x[2]*hat_x[0]+4.0000000000000000e+00*hat_x[1]*hat_x[2]+-3.0000000000000000e+00*hat_x[1]+2.0000000000000000e+00*(hat_x[0]*hat_x[0])+-3.0000000000000000e+00*hat_x[2]+2.0000000000000000e+00*(hat_x[2]*hat_x[2])+2.0000000000000000e+00*(hat_x[1]*hat_x[1])+4.0000000000000000e+00*hat_x[1]*hat_x[0]+-3.0000000000000000e+00*hat_x[0]+1.0;
  values[1] =  2.0000000000000000e+00*(hat_x[0]*hat_x[0])-hat_x[0];
  values[2] = -hat_x[1]+2.0000000000000000e+00*(hat_x[1]*hat_x[1]);
  values[3] = -hat_x[2]+2.0000000000000000e+00*(hat_x[2]*hat_x[2]);
  values[4] =  -4.0000000000000000e+00*hat_x[0]*hat_x[1]+-4.0000000000000000e+00*hat_x[2]*hat_x[0]+4.0000000000000000e+00*hat_x[0]+-4.0000000000000000e+00*(hat_x[0]*hat_x[0]);
  values[5] = 4.0000000000000000e+00*hat_x[0]*hat_x[1];
  values[6] =  -4.0000000000000000e+00*hat_x[0]*hat_x[1]+4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[1]*hat_x[2]+-4.0000000000000000e+00*(hat_x[1]*hat_x[1]);
  values[7] =  -4.0000000000000000e+00*hat_x[0]*hat_x[2]+-4.0000000000000000e+00*hat_x[1]*hat_x[2]+-4.0000000000000000e+00*(hat_x[2]*hat_x[2])+4.0000000000000000e+00*hat_x[2];
  values[8] = 4.0000000000000000e+00*hat_x[0]*hat_x[2];
  values[9] = 4.0000000000000000e+00*hat_x[1]*hat_x[2];
}
void
basis_P2_T::grad_eval(
  const point&   hat_x,
  vector<point>& values)
{
  values.resize(10);
  typedef Float T;
  values[0][0] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]-3.0000000000000000e+00;
  values[0][1] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]-3.0000000000000000e+00;
  values[0][2] =  4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00*hat_x[1]+4.0000000000000000e+00*hat_x[2]-3.0000000000000000e+00;
  values[1][0] =  4.0000000000000000e+00*hat_x[0]-1.0000000000000000e+00;
  values[1][1] = 0.0;
  values[1][2] = 0.0;
  values[2][0] = 0.0;
  values[2][1] =  4.0000000000000000e+00*hat_x[1]-1.0000000000000000e+00;
  values[2][2] = 0.0;
  values[3][0] = 0.0;
  values[3][1] = 0.0;
  values[3][2] =  4.0000000000000000e+00*hat_x[2]-1.0000000000000000e+00;
  values[4][0] =  -4.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+-8.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
  values[4][1] = -4.0000000000000000e+00*hat_x[0];
  values[4][2] = -4.0000000000000000e+00*hat_x[0];
  values[5][0] = 4.0000000000000000e+00*hat_x[1];
  values[5][1] = 4.0000000000000000e+00*hat_x[0];
  values[5][2] = 0.0;
  values[6][0] = -4.0000000000000000e+00*hat_x[1];
  values[6][1] =  -4.0000000000000000e+00*hat_x[0]+-8.0000000000000000e+00*hat_x[1]+-4.0000000000000000e+00*hat_x[2]+4.0000000000000000e+00;
  values[6][2] = -4.0000000000000000e+00*hat_x[1];
  values[7][0] = -4.0000000000000000e+00*hat_x[2];
  values[7][1] = -4.0000000000000000e+00*hat_x[2];
  values[7][2] =  -4.0000000000000000e+00*hat_x[1]+-8.0000000000000000e+00*hat_x[2]+-4.0000000000000000e+00*hat_x[0]+4.0000000000000000e+00;
  values[8][0] = 4.0000000000000000e+00*hat_x[2];
  values[8][1] = 0.0;
  values[8][2] = 4.0000000000000000e+00*hat_x[0];
  values[9][0] = 0.0;
  values[9][1] = 4.0000000000000000e+00*hat_x[2];
  values[9][2] = 4.0000000000000000e+00*hat_x[1];
}
void
basis_P2_T::hessian_eval(
  const point&   hat_x,
  vector<basic_point<point> >& values)
{
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  values.resize(10,ini_val);
  typedef Float T;
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2_T::hat_node(
  vector<point>& x)
{
  x.resize(10);
  x[0] = point(0.0, 0.0, 0.0);
  x[1] = point(1.0, 0.0, 0.0);
  x[2] = point(0.0, 1.0, 0.0);
  x[3] = point(0.0, 0.0, 1.0);
  x[4] = point(5.0000000000000000e-01, 0.0, 0.0);
  x[5] = point(5.0000000000000000e-01, 5.0000000000000000e-01, 0.0);
  x[6] = point(0.0, 5.0000000000000000e-01, 0.0);
  x[7] = point(0.0, 0.0, 5.0000000000000000e-01);
  x[8] = point(5.0000000000000000e-01, 0.0, 5.0000000000000000e-01);
  x[9] = point(0.0, 5.0000000000000000e-01, 5.0000000000000000e-01);
}
basis_P2::~basis_P2()
{
}
basis_P2::size_type
basis_P2::degree () const
{
    return 2;
}
basis_P2::size_type
basis_P2::size (
    reference_element hat_K, basis_rep::dof_family_type family) const
{
    if (family!=reference_element::Lagrange && family!=reference_element::dof_family_max) return 0;
    switch (hat_K.type()) {
      case reference_element::p: {
        return 1;
      }
      case reference_element::e: {
        return 3;
      }
      case reference_element::t: {
        return 6;
      }
      case reference_element::q: {
        return 9;
      }
      case reference_element::T: {
        return 10;
      }
      default : {
        error_macro ("size: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
basis_rep::dof_family_type
basis_P2::dof_family(
    reference_element hat_K,
    size_type         i_dof_local) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P2_p::dof_family (i_dof_local);
      }
      case reference_element::e: {
      return basis_P2_e::dof_family (i_dof_local);
      }
      case reference_element::t: {
      return basis_P2_t::dof_family (i_dof_local);
      }
      case reference_element::q: {
      return basis_P2_q::dof_family (i_dof_local);
      }
      case reference_element::T: {
      return basis_P2_T::dof_family (i_dof_local);
      }
      default : {
        error_macro ("dof_family: unsupported `" << hat_K.name() << "' element type");
        return reference_element::dof_family_max;
      }
    }
}
Float
basis_P2::eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P2_p::eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_P2_e::eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_P2_t::eval (i_dof_local,hat_x);
      }
      case reference_element::q: {
      return basis_P2_q::eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_P2_T::eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
        return 0;
      }
    }
}
point
basis_P2::grad_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P2_p::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::e: {
      return basis_P2_e::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::t: {
      return basis_P2_t::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::q: {
      return basis_P2_q::grad_eval (i_dof_local,hat_x);
      }
      case reference_element::T: {
      return basis_P2_T::grad_eval (i_dof_local,hat_x);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
        return point();
      }
    }
}
basic_point<point>
basis_P2::hessian_eval(
    reference_element hat_K,
    size_type         i_dof_local,
    const point&      hat_x) const
{
  error_macro ("hessian_eval: invalid basis P2");
  point ini_p(0);
  basic_point<point> ini_val(ini_p,ini_p,ini_p);
  return ini_val;
}
void
basis_P2::eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<Float>&    values) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P2_p::eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P2_e::eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P2_t::eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P2_q::eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P2_T::eval (hat_x, values);
      }
      default : {
        error_macro ("eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_P2::grad_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<point>&    values) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P2_p::grad_eval (hat_x, values);
      }
      case reference_element::e: {
      return basis_P2_e::grad_eval (hat_x, values);
      }
      case reference_element::t: {
      return basis_P2_t::grad_eval (hat_x, values);
      }
      case reference_element::q: {
      return basis_P2_q::grad_eval (hat_x, values);
      }
      case reference_element::T: {
      return basis_P2_T::grad_eval (hat_x, values);
      }
      default : {
        error_macro ("grad_eval: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
void
basis_P2::hessian_eval(
    reference_element hat_K,
    const point&      hat_x,
    vector<basic_point<point> >&    values) const
{
  error_macro ("hessian_eval: invalid basis P2");
}
void
basis_P2::hat_node(
    reference_element hat_K,
    vector<point>&    hat_node) const
{
    switch (hat_K.type()) {
      case reference_element::p: {
      return basis_P2_p::hat_node (hat_node);
      }
      case reference_element::e: {
      return basis_P2_e::hat_node (hat_node);
      }
      case reference_element::t: {
      return basis_P2_t::hat_node (hat_node);
      }
      case reference_element::q: {
      return basis_P2_q::hat_node (hat_node);
      }
      case reference_element::T: {
      return basis_P2_T::hat_node (hat_node);
      }
      default : {
        error_macro ("hat_node: unsupported `" << hat_K.name() << "' element type");
      }
    }
}
basis_rep* make_P2(void) { return new_macro(basis_P2); }
