#ifndef _RHEOLEF_P1PW_NUMBERING_H
#define _RHEOLEF_P1PW_NUMBERING_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/numbering.h"
#include "rheolef/tiny_matvec.h"

namespace rheolef { 
class numbering_P1pw : public numbering_rep {
public:

   // constructor

    numbering_P1pw();

   // modifier
    void
    initialize(size_type _nb_interface_nodes,
        std::map<size_type,tiny_vector<size_type> > special_elements) const;
   
   // accessors 
    std::string name() const;
    size_type ndof (
              size_type  mesh_map_dimension,
        const size_type* mesh_n_geo,
        const size_type* mesh_n_element) const;

    size_type idof (   
        const size_type*      mesh_n_geo,
        const size_type*      mesh_n_element,
        const geo_element&    K, 
        size_type             i_dof_local) const;

    void idof (   
        const size_type*        mesh_n_geo,
        const size_type*        mesh_n_element,
        const geo_element&      K, 
	std::vector<size_type>& i_dof) const;

protected:
    mutable bool has_K_special;
    mutable size_type nb_interface_nodes;
    mutable std::map<size_type,tiny_vector<size_type> > K_special;
};
}// namespace rheolef
#endif // _RHEO_P1PW_NUMBERING_H
