///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "P1_numbering.h"
using namespace rheolef;
using namespace std;

std::string
numbering_P1::name() const
{
  return "P1";
}
numbering_P1::size_type
numbering_P1::idof (
	const size_type*      mesh_n_geo,
	const size_type*      mesh_n_element,
	const geo_element&    K, 
	size_type             i_dof_local) const
{
	return K [i_dof_local];
}
void
numbering_P1::idof (
	const size_type*      mesh_n_geo,
	const size_type*      mesh_n_element,
	const geo_element&    K, 
	vector<size_type>&    i_dof) const
{
  for (size_type i_dof_local = 0; i_dof_local < K.size(); i_dof_local++)
    i_dof[i_dof_local] 
     = numbering_P1::idof (mesh_n_geo, mesh_n_element, K, i_dof_local);
}
numbering_P1::size_type
numbering_P1::ndof (
              size_type  mesh_map_dimension,
        const size_type* mesh_n_geo,
        const size_type* mesh_n_element) const
{
        // number of vertices 
	return mesh_n_geo[0];
}
