Name: resiprocate
Version: 1.8.2
Release: 1
Summary: Resiprocate SIP Stack
License: Vovida Software License http://opensource.org/licenses/vovidapl.php
Group: Productivity/Telephony/SIP/Servers
Vendor: resiprocate.org
Packager: Daniel Pocock <daniel@pocock.com.au>
Url: http://www.resiprocate.org
Source: %name-%version.tar.gz
BuildRequires: openssl-devel >= 0.9.7
BuildRequires: popt
BuildRequires: boost-devel
Requires: openssl >= 0.9.7
Requires: chkconfig
Prefix: %_prefix
BuildRoot: %{_tmppath}/%name-%version-root

%description
The reSIProcate components, particularly the SIP stack, are in use in both
commercial and open-source products. The project is dedicated to maintaining
a complete, correct, and commercially usable implementation of SIP and a few
related protocols.

%package devel
Summary: Resiprocate development files
Group: Development/Libraries
Requires: %{name} = %{version}

%description devel
Resiprocate SIP Stack development files.

%prep
%setup -q

%build
%configure
make

%install
make DESTDIR=%buildroot install

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(644,root,root,755)
%{_libdir}/librutil.so
%{_libdir}/libresip.so
%{_libdir}/libdum.so
%{_libdir}/librepro.so
%{_bindir}/repro

%files devel
%defattr(644,root,root,755)
%{_includedir}/rutil/*.hxx
%{_includedir}/rutil/dns/*.hxx
%{_includedir}/rutil/stun/*.hxx
%{_includedir}/resip/stack/*.hxx
%{_includedir}/resip/stack/config.hxx.in
%{_includedir}/resip/dum/*.hxx
#%{_libdir}/librutil.a
#%{_libdir}/libresip.a
%{_libdir}/libares.a
#%{_mandir}/man3/ares*gz
/usr/man/man3/ares*.gz

%changelog
* Sun Aug  7 2011 Daniel Pocock <daniel@pocock.com.au> -
- Initial build based on autotools

