from workerThread import WorkerThread
from sfurls import *
from sfregex import *
from constants import SF_COOKIE_FILENAME, SF_FTP_SERVER, SF_FTP_DIRECTORY

from ProjectVO import ProjectVO
from PackageVO import PackageVO
from urllib import urlencode, quote_plus
try:
    # python2.4 standard
    from urllib2 import build_opener, HTTPCookieProcessor, ProxyHandler
except:
    # python2.3 compatibility
    from python24.urllib2 import build_opener, HTTPCookieProcessor, ProxyHandler
import logging
from messageQueue import mainMessageQueue, progressMessageQueue, ftpProgressQueue
import os, sys
from ftp import FTP_
import time
from constants import SF_RESPONSE_CHUNK_SIZE

debug = logging.getLogger("sfcomm").debug
error = logging.getLogger("sfcomm").error
exception = logging.getLogger("sfcomm").exception

# disable debug level logging in the cookielib module
logging.getLogger("cookielib").setLevel(logging.WARN)

try:
    import cookielib            
except ImportError:
    try:
        import python24.cookielib as cookielib
    except:
        print "Missing cookielib (requires python 2.4)"
        sys.exit(1)

try:
    set = set
except:
    from sets import Set
    set = Set

TRUNCATE_POST = 1024

class SFComm:
    def __init__(self, data_path, proxy=None):
        self.cookie_file = os.path.join(data_path, SF_COOKIE_FILENAME)
        self.proxy = proxy

    def set_proxy(self, proxy):
        self.proxy = proxy

    def remove_cookie(self):
        try:
            os.remove(self.cookie_file)
        except:
            pass
        

    def fetch_url(self,
                  url,
                  post_encoded=None,
                  queue=progressMessageQueue,
                  addl_headers=None,
                  ok_status=None,
                  dbg=None):
        #
        # parameters:
        # url: url to retrieve
        # post_encoded: the encoded query string sent to SF
        # queue: the python Queue that status information will be sent to
        # addl_headers: any additional headers that need to be passed to SF
        # ok_status: a string as described below.
        #
        # returns a tuple containing the data returned from SF and the status.
        #
        # If ok_status is provided, the status returned is True if the
        # string ok_status is found, False otherwise. additionally, the data
        # returned will be truncated as soon as ok_status is found.
        #
        # If ok_status is None, status is always True and data will not be truncated
        #
        # return tuple form: (data, status)
        #
        data = ""
        ok = True
        try:
            debug("Fetching: %s", url)
            if post_encoded:
                if len(post_encoded) > TRUNCATE_POST: truncated = "..."
                else: truncated = ""
                debug("posted: %s%s", post_encoded[:TRUNCATE_POST], truncated)

            queue.put("Fetching: %s" % url)
            
            cj = cookielib.MozillaCookieJar()
            cj.load(self.cookie_file, True)
            opener = build_opener(HTTPCookieProcessor(cj))
            if addl_headers:
                opener.addheaders = addl_headers
                
            r = opener.open(url, post_encoded)
#            debug("r methods: %s", dir(r))
#            cj.save(self.cookie_file, True)
            if not ok_status: 
                # fetch entire response
                data = r.read()
            else:
                # chunk through the response... searching for ok_status
                # if found, return true, otherwise false
                while True:
                    chunk = r.read(SF_RESPONSE_CHUNK_SIZE)
                    
                    if not chunk:
                        debug("read chunk returned no data? %s", type(chunk))
                        ok = False 
                        break
                    data = "%s%s" % (data, chunk)
                    if dbg: debug("fetched: %d bytes", len(data))

                    if data.find(ok_status) != -1:
                        break
                if ok:
                    debug("found '%s' in response", ok_status)
                else:
                    debug("did not find '%s' in response", ok_status)

            r.close()
            if dbg: debug("Done")
            #debug("length: %ld  -  url: %s", len(data), url)
        except Exception, e:
            print e

        if dbg: debug("DATA: %s", data)
        return data, ok



    def login(self, username, password, return_to=None):
        # returns a set of projects for the given username/password
        # or None
        debug("Attempting to login to SourceForge")
        form = {'form_loginname': username,
                'form_pw': password,
                'stay_in_ssl': '1',
                'persistent_login': '1',
                'login': 'Login With SSL'}
        url = LOGIN_URL

        if return_to: url += "?return_to=%s" % quote_plus(return_to)
        #if return_to: url += "?return_to=%s" % urlencode(return_to)
        
        cj = cookielib.MozillaCookieJar()

##        proxy_handler = None
##        if self.proxy:
##            proxy_handler = ProxyHandler(self.proxy)
##            opener = build_opener(proxy_handler, HTTPCookieProcessor(cj))

        opener = build_opener(HTTPCookieProcessor(cj))

        try:
            r = opener.open(url, urlencode(form))
        except Exception, e:
            error(e)
            return set()

        cj.save(self.cookie_file, True, True) # ignore discard! ignore expires
        
        data = r.read()
        idx = data.find("Invalid Password or User Name")
        if idx != -1:
            debug("Could not login")
            return projects

        projects = set()
        #debug(data)
        project_tuples = PROJECTS_FROM_MY_PROJECTS.findall(data)
        for pt in project_tuples:
            projects.add(ProjectVO(pt[2], pt[1], pt[0]))
        #debug("login - projects fetched: %d" % len(projects))

        #print "projects:", projects
        #print "data:", data
        return projects



    def get_packages(self, group_id):
        url = "%s=%s" % (EDIT_PACKAGE_BASE_URL, group_id)
        packages = set()
        data = self.fetch_url(url, queue=mainMessageQueue)[0]
        debug("data: %s", data)
        #forms = PACKAGE_FORMS.findall(data)[:-1]  # -1 = New package name
            
        fullaccess = "True"
        package_tuples = PACKAGES_FULL_ACCESS.findall(data)
        if not package_tuples and self.can_create_releases(group_id):           
            # access is limited
            fullaccess = "False"
            url = "%s=%s" % (GET_PACKAGES, group_id)
            data = self.fetch_url(url, queue=mainMessageQueue)[0]
            debug("data: %s", data)
            package_tuples = PACKAGES_LIMITED_ACCESS.findall(data)
        for package_tuple in package_tuples:
            try:
                status = package_tuple[2]
            except:
                status = 'Active'
            packages.add(PackageVO(package_tuple[1],
                                   package_tuple[0],
                                   status,
                                   fullaccess))
        debug("Found %d packages for group_id %s", len(packages), group_id)
        return packages


    def add_package(self, group_id, package_name):
        url = ADD_PACKAGE_URL
        form = {'group_id': group_id,
                'func': "add_package",
                "package_name": package_name,
                'submit': "Create This Package"}
        data, ok  = self.fetch_url(url, 
                                   urlencode(form), 
                                   mainMessageQueue,
                                   ok_status="Added Package")
        return ok


    def can_create_releases(self, group_id):
        url = "%s?group_id=%s" % (NEW_RELEASE_URL,
                                  group_id)
        data, ok = self.fetch_url(url, ok_status=">Permission denied<")
        if ok:
            mainMessageQueue.put("You do not have the proper permissions")
            return False
        else: return True
        

    def add_release(self, group_id, package_id, name):
        url = "%s?package_id=%s&group_id=%s" % (NEW_RELEASE_URL,
                                                package_id,
                                                group_id)
        form = {'package_id': package_id,
                'group_id': group_id,
                'release_name': name,
                'newrelease': 'yes',
                'submit': 'Create This Release'}

        data = self.fetch_url(url, urlencode(form))[0]
        #print url
        m = GET_RELEASE_ID.search(data)
        if m:
            return m.group("releaseid")
        else:
            if data.find("Error creating Project object") != -1:
                progressMessageQueue.put("Error creating Project object")
            elif data.find("Login to SourceForge.net") != -1:
                progressMessageQueue.put("Login required?")
                #print data
            else:
                progressMessageQueue.put("Error creating new release")
            return None

    def get_releases(self, group_id, package_id):
        url = "%s?group_id=%s&package_id=%s" % (EDIT_RELEASE_URL,
                                                group_id,
                                                package_id)
        
        data = self.fetch_url(url, queue=mainMessageQueue)[0]

        matches = GET_RELEASES.findall(data)
        return matches
        #if data.find("Added Package") != -1: return 1
        #else: return 0

    def get_release(self, group_id, package_id, release_id):
        url = "%s?group_id=%s&package_id=%s&release_id=%s" % (EDIT_RELEASE_URL,
                                                              group_id,
                                                              package_id,
                                                              release_id)
        
        data = self.fetch_url(url, queue=mainMessageQueue)[0]
        idx = data.find("Edit Existing Release")
        if idx == -1: return None

        data = data[idx:] # remove the meaningless html
        release_notes = ""
        change_log = ""
        files = []
        
        m = GET_NOTES_AND_LOG.search(data)        
        if m:
            release_notes = m.group("releasenotes")
            change_log = m.group("changelog")

        filedata = GET_FILE_NAMES_ETC.findall(data)
        files = []
        for f in filedata:
            fileid = f[0]
            filename = f[1]
            processor = ""
            filetype = ""
            m = GET_SELECTED_VALUE.search(f[2])
            if m:
                processor = m.group('value')
            m = GET_SELECTED_VALUE.search(f[3])
            if m:
                filetype = m.group('value')
            files.append( (fileid, filename, processor, filetype) )
            debug("file: %s - %s - %s - %s", fileid, filename, processor, filetype)
        
        debug("edit release - files: %s", files)
        return (release_notes, change_log, files)


    def update_package(self, group_id, package_id, package_name, package_status):
        # returns -1 if package status could not be changed
        # returns 1 if package was updated successfully
        # returns 0 on failure
        url = UPDATE_PACKAGE_URL
        if package_status.lower() == 'active': status_id = '1'
        else: status_id = '3'
        form = {'group_id': group_id,
                'package_id': package_id,
                'func': 'update_package',
                'package_name': package_name,
                'status_id': status_id,
                'submit': 'Update'}
        data = self.fetch_url(url, urlencode(form), mainMessageQueue)[0]

        if data.find("Sorry - you cannot hide a package that contains active releases") != -1:
            result = -1
        elif data.find("Updated Package") != -1: result = 1
        else: result = 0
        return result
    



    def add_release(self, group_id, package_id, name):
        url = "%s?package_id=%s&group_id=%s" % (NEW_RELEASE_URL,
                                                package_id,
                                                group_id)
        form = {'package_id': package_id,
                'group_id': group_id,
                'release_name': name,
                'newrelease': 'yes',
                'submit': 'Create This Release'}

        data = self.fetch_url(url, urlencode(form))[0]
        #print url
        m = GET_RELEASE_ID.search(data)
        if m:
            return m.group("releaseid")
        else:
            if data.find("Error creating Project object") != -1:
                progressMessageQueue.put("Error creating Project object")
            elif data.find("Login to SourceForge.net") != -1:
                progressMessageQueue.put("Login required?")
                #print data
            else:
                progressMessageQueue.put("Error creating new release")
            return None



    def edit_release_step1(self, group_id, package_id, release_id,
                           name, release_notes, change_log, status='active'):
        url = EDIT_RELEASE_URL
        if status.lower() == 'active': status_id = '1'
        else: status_id = '3'
        
        form = {'package_id': package_id,
                'new_package_id': package_id,
                'group_id': group_id,
                'release_id': release_id,
                'release_name': name,
                'release_date': time.strftime("%Y-%m-%d"),
                'step1': '1',
                'status_id': status_id,
                'uploaded_notes': '',
                'uploaded_changes': '',
                'release_notes': release_notes,
                'release_changes': change_log,
                'preformatted': '1',
                'submit': 'Submit/Refresh'
                }
        ok = self.fetch_url(url,
                            urlencode(form),
                            ok_status="Data Saved")[1]
        return ok
        #if data.find("Data Saved") != -1: return True
        #else: return False



    def edit_release_step2(self, group_id, package_id, release_id, fileVOs):
        url = EDIT_RELEASE_URL
        form = {'package_id': package_id,
                'group_id': group_id,
                'release_id': release_id,
                'step2': '1',
                'submit': 'Add Files and/or Refresh View'}
        enc = urlencode(form)
        for fileVO in fileVOs:
            filename = fileVO.getFilename()
            enc += "&file_list%s=%s" % (quote_plus("[]"), quote_plus(filename))
            
        #data, ok = self.fetch_url(url, enc, ok_status="File(s) Added", dbg=True)
        data, ok = self.fetch_url(url, enc)

        warnings = GET_FILE_WARNINGS.findall(data)
        debug("step2 warnings: %s", str(warnings))

        if data.find("File(s) Added") != -1: ok = True

        if not ok:
            error("Error selecting %s for inclusion", filename)
            #debug("dumping data: %s", data)  # remove me...
            ok = False
        
        matches = GET_FILE_ID.findall(data)
        lookup = {}
        for match in matches:
            # map each filename to fileid
            lookup[match[1]] = match[0]
        return lookup, warnings, ok


    def edit_release_step3(self, group_id, package_id, release_id, fileVOs, lookup_dict):
        url = EDIT_RELEASE_URL
        
        form = {'package_id': package_id,
                'group_id': group_id,
                'release_id': release_id,
                'new_release_id': release_id,
                'step3': '1',
                'release_time': time.strftime("%Y-%m-%d"),
                'submit': 'Update/Refresh'}

        ok = True
        for fileVO in fileVOs:
            form['processor_id'] = fileVO.getProcessorId()
            form['type_id'] = fileVO.getFileTypeId()
            try:
                #debug("filename: %s", fileVO.getFilename() )
                #debug("dict: %s", str(lookup_dict))
                
                form['file_id'] = lookup_dict[fileVO.getFilename()]
                ok &= self.fetch_url(url, urlencode(form), ok_status="File Updated")[1]
            except Exception, e:
                exception(e)
                ok &= False
        return ok
    

    def edit_release_step4(self, group_id, package_id, release_id):
        url = EDIT_RELEASE_URL
        
        form = {'package_id': package_id,
                'group_id': group_id,
                'release_id': release_id,
                'step4': 'Email Release',
                'sure': '1',
                'submit': 'Send Notice'}
        
        data = self.fetch_url(url, urlencode(form))[0]
        # notification status?!?!
        return data

    
    def delete_files(self, group_id, package_id, release_id, file_ids):
        url = EDIT_RELEASE_URL
        
        form = {'package_id': package_id,
                'group_id': group_id,
                'release_id': release_id,
                'step3': 'Delete File',
                'im_sure': '1',
                'submit': 'Delete File'}

        ok = True
        for file_id in file_ids:
            form['file_id'] = file_id
            ok &= self.fetch_url(url, urlencode(form), ok_status="File Deleted")[1]
#            if data.find("File Deleted") != -1: ok &= True
#            else: ok &= False
        return ok


    def update_release(self, group_id, package_id, release_id,
                       release_name, status):

        release_tuple = self.get_release(group_id,
                                         package_id,
                                         release_id)
        if not release_tuple: return False
        
        release_notes, change_log, files = release_tuple

        return self.edit_release_step1(group_id,
                                       package_id,
                                       release_id,
                                       release_name,
                                       release_notes,
                                       change_log,
                                       status)


    def upload_files(self, parent, fileVOs):
        ftp = FTP_()

        try:
            ftp.connect(SF_FTP_SERVER)
            ftp.getwelcome()

            ftp.login("ftp", "releaseforge")
            ftp.cwd(SF_FTP_DIRECTORY)
            num_uploaded = 0

            for fileVO in fileVOs:
                fullpath = fileVO.getFullPath()
                filename = fileVO.getFilename()
                debug("uploading %s (%s)", filename, fullpath)
                progressMessageQueue.put("Uploading: %s" % filename)
                f = open(fullpath, "rb")
                
                ftp.storbinary('STOR ' + filename,
                               f,
                               callback=self.update_ftp_progress)
                f.close()

                num_uploaded += 1
                if parent.isCancelled(): break

            if num_uploaded < len(fileVOs):
                msg = "File upload operation cancelled"
            else:
                msg = "Successfully uploaded %d files" % num_uploaded
        except Exception, e:
            msg = str(e)
            progressMessageQueue.put("FTP error: %s" % msg)
        debug(msg)
        try:
            ftp.close()
        except: pass

        ftpProgressQueue.clear()
        ftpProgressQueue.put( (True, True) )
        return msg


    def update_ftp_progress(self, progress):
        #debug("progress: %s", progress)
        ftpProgressQueue.clear()
        ftpProgressQueue.put(progress)


    def submit_news(self, group_id, subject, message):
        url = SUBMIT_NEWS_URL
        form = {'group_id': group_id,
                'post_changes': 'y',
                'summary': subject,
                'submit': 'SUBMIT'}

        encoded = urlencode(form)        
        escaped_message = quote_plus(message)
        
        # replace each #0A in the message textarea with a newline
        encoded += '&details=%s' % escaped_message.replace("%0A", "\n")

        return self.fetch_url(url, encoded, mainMessageQueue, ok_status="News Added.")[1]
                
#        if data.find("News Added.") != -1: return 1
#        else: return 0


if __name__ == '__main__':
    pass

    
    
