/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsusertester.h"

REGISTER_TEST(RdsUserTester);

RdsUserTester::RdsUserTester(QObject *parent)
		: QObject(parent)
{
}


RdsUserTester::~RdsUserTester()
{
}

void RdsUserTester::initTestCase()
{
	rdsLdapSession()->remove("cn=testuser1,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=differentCn,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=testuser2,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=testgroup,cn=Users,dc=resara,dc=local");

	TEST_FUNCTION(RdsUser::createUser("cn=testuser1,cn=Users,dc=resara,dc=local", "testaccount1"));
	TEST_FUNCTION(RdsUser::createUser("cn=testuser2,cn=Users,dc=resara,dc=local", "testaccount2"));

	TEST_FUNCTION(RdsGroup::createGroup("cn=testgroup,cn=Users,dc=resara,dc=local"));
}

void RdsUserTester::cleanupTestCase()
{
	rdsLdapSession()->remove("cn=testuser1,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=differentCn,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=testuser2,cn=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("cn=testgroup,cn=Users,dc=resara,dc=local");
}

void RdsUserTester::constructorTest()
{
	RdsUser user;
	RdsUser user1(user), user2("cn=testuser1,cn=Users,dc=resara,dc=local");

	RdsUser testuser1("CN=testuser1,cn=Users,dc=resara,dc=local"), testuser2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << testuser1;
	}
	{
		QDataStream stream(ar);
		stream >> testuser2;
	}
	QCOMPARE(testuser2.dn(), testuser1.dn());

	RdsUser::UserStates state = RdsUser::MustChangePassword | RdsUser::CannotChangePassword;
	RdsUser::UserStates state2;
	QByteArray ary;
	{
		QDataStream stream(&ary, QIODevice::WriteOnly);
		stream << state;
	}
	{
		QDataStream stream(ary);
		stream >> state2;
	}
	QCOMPARE(state, state2);
}

void RdsUserTester::flagsTest()
{
	RdsUser user("cn=testuser1,cn=Users,dc=resara,dc=local");
	ReturnValue ret = TEST_FUNCTION(user.flags());
	RdsUser::UserStates state = ret.value<RdsUser::UserStates>();
	
	///check that changing setting the password removes MustChangePassword flag
	state = RdsUser::MustChangePassword;
	TEST_FUNCTION(user.setFlags(state));

	ret = TEST_FUNCTION(user.flags());
	state = ret.value<RdsUser::UserStates>();
	QCOMPARE(state, RdsUser::MustChangePassword);

	TEST_FUNCTION(user.setPassword("hey1!thissisapassword1234"));

	ret = TEST_FUNCTION(user.flags());
	state = ret.value<RdsUser::UserStates>();
	QCOMPARE(state, RdsUser::NoState);

	///check setFlags()
	state = RdsUser::CannotChangePassword | RdsUser::PasswordNeverExpires;
	TEST_FUNCTION(user.setFlags(state));

	ret = TEST_FUNCTION(user.flags());
	state = ret.value<RdsUser::UserStates>();
	QCOMPARE(state, RdsUser::CannotChangePassword | RdsUser::PasswordNeverExpires);

	state = RdsUser::NoState;
	TEST_FUNCTION(user.setFlags(state));

	ret = TEST_FUNCTION(user.flags());
	state = ret.value<RdsUser::UserStates>();
	QCOMPARE(state, RdsUser::NoState);

	///check setFlag()
	TEST_FUNCTION(user.setFlag(RdsUser::CannotChangePassword));
	TEST_FUNCTION(user.setFlag(RdsUser::PasswordNeverExpires));

	ret = TEST_FUNCTION(user.flags());
	state = ret.value<RdsUser::UserStates>();
	QCOMPARE(state, RdsUser::CannotChangePassword | RdsUser::PasswordNeverExpires);

	///check unsetFlag()
	TEST_FUNCTION(user.unsetFlag(RdsUser::CannotChangePassword));
	TEST_FUNCTION(user.unsetFlag(RdsUser::PasswordNeverExpires));

	ret = TEST_FUNCTION(user.flags());
	state = ret.value<RdsUser::UserStates>();
	QCOMPARE(state, RdsUser::NoState);

	///check that setting CannotChangePassword flag prevents password change
	TEST_FUNCTION(user.setFlag(RdsUser::CannotChangePassword));

	TEST_FUNCTION_ERROR(user.setPassword("goF*@#yourself32"));
}

void RdsUserTester::cnTest()
{
	RdsUser user("CN=testuser1,cn=Users,dc=resara,dc=local");

	ReturnValue ret = TEST_FUNCTION(user.cn());
	QCOMPARE(ret.toString(), QString("testuser1"));

	TEST_FUNCTION_ERROR(user.setCn("testuser2"));
	ret = TEST_FUNCTION(user.setCn("differentCn"));
	QCOMPARE(ret.toString(), QString("cn=differentCn,cn=Users,dc=resara,dc=local"));

	TEST_FUNCTION(user.setCn("testuser1"));
}

void RdsUserTester::groupTest()
{
	RdsUser user("cn=testuser1,cn=Users,dc=resara,dc=local");
	ReturnValue ret = TEST_FUNCTION(user.groups());
	QStringList list = ret.toStringList();
	QCOMPARE(list.size(), 1);
	QVERIFY(list.contains("CN=Domain Users,CN=Users,DC=resara,DC=local"));

	TEST_FUNCTION(user.joinGroup("cn=testgroup,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION_ERROR(user.joinGroup("cn=testgroup,cn=Users,dc=resara,dc=local"));

	ret = TEST_FUNCTION(user.groups());
	list = ret.toStringList();
	QCOMPARE(list.size(), 2);
	QVERIFY(list.contains("CN=testgroup,CN=Users,DC=resara,DC=local"));
	QVERIFY(list.contains("CN=Domain Users,CN=Users,DC=resara,DC=local"));

	TEST_FUNCTION(user.leaveGroup("cn=testgroup,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION_ERROR(user.leaveGroup("cn=testgroup,cn=Users,dc=resara,dc=local"));

	ret = TEST_FUNCTION(user.groups());
	list = ret.toStringList();
	QCOMPARE(list.size(), 1);
	QVERIFY(list.contains("CN=Domain Users,CN=Users,DC=resara,DC=local"));

	TEST_FUNCTION(user.setPrimaryGroup("cn=testgroup,cn=Users,dc=resara,dc=local"));
	ret = TEST_FUNCTION(user.primaryGroup());
	QCOMPARE(ret.toString(), QString("CN=testgroup,CN=Users,DC=resara,DC=local"));
}

void RdsUserTester::genralInfoTest()
{
	RdsUser user("cn=testuser1,cn=Users,dc=resara,dc=local");

	TEST_FUNCTION(user.setUserName("Satan"));
	ReturnValue ret = TEST_FUNCTION(user.userName());
	QCOMPARE(ret.toString(), QString("Satan"));
/*	TEST_FUNCTION(user.setUserName(""));///			broken
	TEST_FUNCTION_ERROR(user.userName());*/

	TEST_FUNCTION(user.setDescription("testdescription"));
	ret = TEST_FUNCTION(user.description());
	QCOMPARE(ret.toString(), QString("testdescription"));
	TEST_FUNCTION(user.setDescription(""));///		different
	ret = TEST_FUNCTION(user.description());
	QCOMPARE(ret.toString(), QString());

	TEST_FUNCTION(user.setFirstName("devil"));
	ret = TEST_FUNCTION(user.firstName());
	QCOMPARE(ret.toString(), QString("devil"));
	TEST_FUNCTION(user.setFirstName(""));
	TEST_FUNCTION_ERROR(user.firstName());

	TEST_FUNCTION(user.setInitials("td"));
	ret = TEST_FUNCTION(user.initials());
	QCOMPARE(ret.toString(), QString("td"));
	TEST_FUNCTION(user.setInitials(""));
	TEST_FUNCTION_ERROR(user.initials());

	TEST_FUNCTION(user.setLastName("lucifer"));
	ret = TEST_FUNCTION(user.lastName());
	QCOMPARE(ret.toString(), QString("lucifer"));
	TEST_FUNCTION(user.setLastName(""));
	TEST_FUNCTION_ERROR(user.lastName());

	TEST_FUNCTION(user.setDisplayName("fallenAngel666"));
	ret = TEST_FUNCTION(user.displayName());
	QCOMPARE(ret.toString(), QString("fallenAngel666"));
	TEST_FUNCTION(user.setDisplayName(""));
	TEST_FUNCTION_ERROR(user.displayName());

	TEST_FUNCTION(user.setOffice("Hell"));
	ret = TEST_FUNCTION(user.office());
	QCOMPARE(ret.toString(), QString("Hell"));
	TEST_FUNCTION(user.setOffice(""));
	TEST_FUNCTION_ERROR(user.office());

	TEST_FUNCTION(user.setPhoneNumber("666-666-6666"));
	ret = TEST_FUNCTION(user.phoneNumber());
	QCOMPARE(ret.toString(), QString("666-666-6666"));
	TEST_FUNCTION(user.setPhoneNumber(""));
	TEST_FUNCTION_ERROR(user.phoneNumber());

	TEST_FUNCTION(user.setEmail("dark1@hell.pit"));
	ret = TEST_FUNCTION(user.email());
	QCOMPARE(ret.toString(), QString("dark1@hell.pit"));
	TEST_FUNCTION(user.setEmail(""));
	TEST_FUNCTION_ERROR(user.email());

	TEST_FUNCTION(user.setWebPage("www.hell.pit"));
	ret = TEST_FUNCTION(user.webPage());
	QCOMPARE(ret.toString(), QString("www.hell.pit"));
	TEST_FUNCTION(user.setWebPage(""));
	TEST_FUNCTION_ERROR(user.webPage());

	TEST_FUNCTION(user.setStreet("Satan Way"));
	ret = TEST_FUNCTION(user.street());
	QCOMPARE(ret.toString(), QString("Satan Way"));
	TEST_FUNCTION(user.setStreet(""));
	TEST_FUNCTION_ERROR(user.street());

	TEST_FUNCTION(user.setPoBox("666"));
	ret = TEST_FUNCTION(user.poBox());
	QCOMPARE(ret.toString(), QString("666"));
	TEST_FUNCTION(user.setPoBox(""));
	TEST_FUNCTION_ERROR(user.poBox());

	TEST_FUNCTION(user.setCity("Torturetopia"));
	ret = TEST_FUNCTION(user.city());
	QCOMPARE(ret.toString(), QString("Torturetopia"));
/*	TEST_FUNCTION(user.setCity(""));///			broken
	TEST_FUNCTION_ERROR(user.city());*/

	TEST_FUNCTION(user.setState("Underground"));
	ret = TEST_FUNCTION(user.state());
	QCOMPARE(ret.toString(), QString("Underground"));
	TEST_FUNCTION(user.setState(""));
	TEST_FUNCTION_ERROR(user.state());
/*
	TEST_FUNCTION(user.setCountry("China"));///		broken
	ret = TEST_FUNCTION(user.country());
	QCOMPARE(ret.toString(), QString("China"));
	TEST_FUNCTION(user.setCountry(""));
	TEST_FUNCTION_ERROR(user.country());*/

	TEST_FUNCTION(user.setPostalCode("66666"));
	ret = TEST_FUNCTION(user.postalCode());
	QCOMPARE(ret.toString(), QString("66666"));
	TEST_FUNCTION(user.setPostalCode(""));
	TEST_FUNCTION_ERROR(user.postalCode());

	TEST_FUNCTION(user.setHomeDrive("H:"));
	ret = TEST_FUNCTION(user.homeDrive());
	QCOMPARE(ret.toString(), QString("H:"));
	TEST_FUNCTION(user.setHomeDrive(""));
	TEST_FUNCTION_ERROR(user.homeDrive());

	TEST_FUNCTION(user.setHomePath("/downthepit/accrossthelava/tothedevilshousewego"));
	ret = TEST_FUNCTION(user.homePath());
	QCOMPARE(ret.toString(), QString("/downthepit/accrossthelava/tothedevilshousewego"));
	TEST_FUNCTION(user.setHomePath(""));
	TEST_FUNCTION_ERROR(user.homePath());

	TEST_FUNCTION(user.setProfilePath("/gtfo"));
	ret = TEST_FUNCTION(user.profilePath());
	QCOMPARE(ret.toString(), QString("/gtfo"));
	TEST_FUNCTION(user.setProfilePath(""));
	TEST_FUNCTION_ERROR(user.profilePath());

	TEST_FUNCTION(user.setLogonScript("I'm the Juggernaut bitch"));
	ret = TEST_FUNCTION(user.logonScript());
	QCOMPARE(ret.toString(), QString("I'm the Juggernaut bitch"));
	TEST_FUNCTION(user.setLogonScript(""));
	TEST_FUNCTION_ERROR(user.logonScript());

	TEST_FUNCTION(user.setPagerNumber("6"));
	ret = TEST_FUNCTION(user.pagerNumber());
	QCOMPARE(ret.toString(), QString("6"));
	TEST_FUNCTION(user.setPagerNumber(""));
	TEST_FUNCTION_ERROR(user.pagerNumber());

	TEST_FUNCTION(user.setMobileNumber("66"));
	ret = TEST_FUNCTION(user.mobileNumber());
	QCOMPARE(ret.toString(), QString("66"));
	TEST_FUNCTION(user.setMobileNumber(""));
	TEST_FUNCTION_ERROR(user.mobileNumber());

	TEST_FUNCTION(user.setFaxNumber("666"));
	ret = TEST_FUNCTION(user.faxNumber());
	QCOMPARE(ret.toString(), QString("666"));
	TEST_FUNCTION(user.setFaxNumber(""));
	TEST_FUNCTION_ERROR(user.faxNumber());

	TEST_FUNCTION(user.setHomeNumber("666-6"));
	ret = TEST_FUNCTION(user.homeNumber());
	QCOMPARE(ret.toString(), QString("666-6"));
	TEST_FUNCTION(user.setHomeNumber(""));
	TEST_FUNCTION_ERROR(user.homeNumber());

	TEST_FUNCTION(user.setNotes("this is demonic"));
	ret = TEST_FUNCTION(user.notes());
	QCOMPARE(ret.toString(), QString("this is demonic"));
	TEST_FUNCTION(user.setNotes(""));
	TEST_FUNCTION_ERROR(user.notes());

	TEST_FUNCTION(user.setTitle("tricksy"));
	ret = TEST_FUNCTION(user.title());
	QCOMPARE(ret.toString(), QString("tricksy"));
	TEST_FUNCTION(user.setTitle(""));
	TEST_FUNCTION_ERROR(user.title());

	TEST_FUNCTION(user.setDepartment("Destruction"));
	ret = TEST_FUNCTION(user.department());
	QCOMPARE(ret.toString(), QString("Destruction"));
	TEST_FUNCTION(user.setDepartment(""));
	TEST_FUNCTION_ERROR(user.department());

	TEST_FUNCTION(user.setCompany("God is a Dick, Inc."));
	ret = TEST_FUNCTION(user.company());
	QCOMPARE(ret.toString(), QString("God is a Dick, Inc."));
	TEST_FUNCTION(user.setCompany(""));
	TEST_FUNCTION_ERROR(user.company());

}
