/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdssidtester.h"

REGISTER_TEST(RdsSidTester);

RdsSidTester::RdsSidTester(QObject *parent)
		: QObject(parent)
{
}


RdsSidTester::~RdsSidTester()
{
}

void RdsSidTester::constructorTest()
{
	RdsSid sid("S-1-5-21-3623811015-3361044348-30300820-1013"), sid2(RdsSid::getDomainSid()), sid3, sid4;
	sid3 = sid2;
	sid4 = QString("S-1-5-21-3623811015-3361044348-30300820-1013");
	RdsSid sid5(sid.toBinary());
	
	QCOMPARE(sid.toString(), QString("S-1-5-21-3623811015-3361044348-30300820-1013"));
	QCOMPARE(sid.toShortString(), QString("S-1-5-21-3623811015-3361044348-30300820-1013"));
	QCOMPARE(sid.toBinary(), sid5.toBinary());
	QCOMPARE(sid5, sid);
	QCOMPARE(sid2, RdsSid::getDomainSid());
	QVERIFY(sid == sid4);
	QVERIFY(sid != sid2);
	QVERIFY(sid == QString("S-1-5-21-3623811015-3361044348-30300820-1013"));
	QVERIFY(sid != sid2.toString());

	RdsSid testsid1(RdsSid::getDomainSid()), testsid2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream <<testsid1;
	}
	{
		QDataStream stream(ar);
		stream >>testsid2;
	}
	QCOMPARE(testsid2,testsid1);
}

void RdsSidTester::getSetTest()
{
	RdsSid sid;
	QVERIFY(sid.isNull());

	///version
	QCOMPARE(sid.version(), uchar(1));
	sid.setVersion(132);
	QCOMPARE(sid.version(), uchar(132));

	///authority
	unsigned long long auth = 0;
	QCOMPARE(sid.authority(), auth);
	sid.setAuthority(5);
	auth = 5;
	QCOMPARE(sid.authority(), auth);

	///domain
	QList<uint> list;
	QCOMPARE(sid.domain(), list);
	list.append(1234567890);
	list.append(2345678901);
	list.append(3456789012);
	sid.setDomain(list);
	QCOMPARE(sid.domain(), list);

	///rid
	QCOMPARE(sid.rid(), uint(0));
	sid.setRid(1234);
	QCOMPARE(sid.rid(), uint(1234));

	QVERIFY(!sid.isNull());

	QCOMPARE(sid, RdsSid("S-132-5-1234567890-2345678901-3456789012-1234"));
}
