/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "config.h"
#include "rdssharingtester.h"

REGISTER_TEST(RdsSharingTester);

RdsSharingTester::RdsSharingTester(QObject *parent)
		: QObject(parent)
{
}

RdsSharingTester::~RdsSharingTester()
{
}

void RdsSharingTester::getTest()
{
	RdsShareManager shary;
	ReturnValue ret = shary.init();
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));

	ret = shary.listShares();
	if (ret.isError())
		qDebug() << ret;
	QVERIFY(!ret.isError());
	qDebug() << ret.toStringList().size();
	foreach(QString entry, ret.toStringList())
	qDebug() << entry;
	ret = shary.share(QString("sysvol"));
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	RdsShare share = ret;
	QCOMPARE(QString("sysvol"), share.name().toString());
	QCOMPARE(QString(RDS_SAMBA_SYSVOL), share.path().toString());
	QCOMPARE(false, share.readOnly().toBool());
	QCOMPARE(true, share.hidden().toBool());
	QCOMPARE(QString(""), share.description().toString());
}

void RdsSharingTester::addRemoveTest()
{
	RdsShareManager shary;
	ReturnValue ret = shary.init();
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));

	ret = shary.addShare(QString("TestShare"), QString("/thisismy/brokenpath"));
	QVERIFY(ret.isError());
	ret = shary.addShare(QString("TestShare"), QString("this is my broken path"));
	QVERIFY(ret.isError());
	ret = shary.addShare(QString("TestShare"), QString("/home/jchamberlin"));
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	QVERIFY(shary.listShares().toStringList().contains("TestShare"));

	ret = shary.share("TestShare");
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	RdsShare share = ret;

	QCOMPARE(QString("TestShare"), share.name().toString());
	ret = share.setName("Episode 666");
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	QCOMPARE(QString("Episode 666"), share.name().toString());

	QCOMPARE(QString(""), share.description().toString());
	ret = share.setDescription("destination chaos");
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	QCOMPARE(QString("destination chaos"), share.description().toString());

	QCOMPARE(false, share.readOnly().toBool());
	ret = share.setReadOnly(true);
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	QCOMPARE(true, share.readOnly().toBool());

	QCOMPARE(true, share.hidden().toBool());
	ret = share.setHidden(false);
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	QCOMPARE(false, share.hidden().toBool());

	QCOMPARE(QString("/home/jchamberlin"), share.path().toString());
	ret = share.setPath("/home/jchamberlin/Desktop");
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
	QCOMPARE(QString("/home/jchamberlin/Desktop"), share.path().toString());

#ifdef __RDS_SERVER
	ret = shary.removeShare(share);
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
#else
	ret = shary.removeShare("Episode 666");
	QVERIFY2(!ret.isError(), qPrintable(ret.errString()));
#endif
}

#ifdef __RDS_SERVER

void RdsSharingTester::listEntitiesTest()
{

}

void RdsSharingTester::fileNameTest()
{

}

#endif



















