/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsntsecuritydescriptortester.h"

REGISTER_TEST(RdsNtSecurityDescriptorTester);

#define OWNER_SID "S-1-5-21-3623811015-3361044348-30300820-1013"
#define GROUP_SID "S-1-5-21-3623811015-3361044348-30300820-1015"
#define INHERIT_OBJ_GUID "3F2504E0-4F89-11D3-9A0C-0305E82C3301"
#define OBJ_GUID "3F2504E0-4F89-11D3-9A0C-0305E82C3305"
#define ACE "(OU;OIFA;WP;f30e3bbe-9ff0-11d1-b603-0000f80367c1;bf967aa5-0de6-11d0-a285-00aa003049e2;WD)"

#define SEC_DESC "O:BAG:BAD:PAI(OA;OIIO;RP;4c164200-20c0-11d0-a768-00aa006e0529;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;4c164200-20c0-11d0-a768-00aa006e0529;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;5f202010-79a5-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;bc0ac240-79a9-11d0-9020-00c04fc2d4cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;59ba2f42-79a2-11d0-9020-00c04fc2d3cf;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RP;037088f8-0ae1-11d2-b422-00a0c968f939;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RP;037088f8-0ae1-11d2-b422-00a0c968f939;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;S-1-5-21-2336184427-3484212696-2663171178-498)(OA;;CR;1131f6ad-9c07-11d1-f79f-00c04fc2dcd2;;S-1-5-21-2336184427-3484212696-2663171178-516)(OA;OIIO;RP;b7c69e6d-2cc7-11d2-854e-00a0c983f608;bf967a86-0de6-11d0-a285-00aa003049e2;ED)(OA;OIIO;RP;b7c69e6d-2cc7-11d2-854e-00a0c983f608;bf967a9c-0de6-11d0-a285-00aa003049e2;ED)(OA;OIIO;RP;b7c69e6d-2cc7-11d2-854e-00a0c983f608;bf967aba-0de6-11d0-a285-00aa003049e2;ED)(OA;;CR;89e95b76-444d-4c62-991a-0facbeda640c;;BA)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ad-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;1131f6ae-9c07-11d1-f79f-00c04fc2dcd2;;BA)(OA;;CR;e2a36dc9-ae17-47c3-b58b-be34c55ba633;;S-1-5-32-557)(OA;;RP;c7407360-20bf-11d0-a768-00aa006e0529;;RU)(OA;;RP;b8119fd0-04f6-4762-ab7a-4986c76b3f9a;;RU)(OA;OIIO;RCRPLCLO;;4828cc14-1437-45bc-9b07-ad6f015e5f28;RU)(OA;OIIO;RCRPLCLO;;bf967a9c-0de6-11d0-a285-00aa003049e2;RU)(OA;OIIO;RCRPLCLO;;bf967aba-0de6-11d0-a285-00aa003049e2;RU)(OA;;CR;05c74c5e-4deb-43b4-bd9f-86664c2a7fd5;;AU)(OA;;CR;89e95b76-444d-4c62-991a-0facbeda640c;;ED)(OA;;CR;ccc2dc7d-a6ad-4a7a-8846-c04e3cc53501;;AU)(OA;;CR;280f369c-67c7-438e-ae98-1d46f3c6f541;;AU)(OA;;CR;1131f6aa-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ab-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ac-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;CR;1131f6ae-9c07-11d1-f79f-00c04fc2dcd2;;ED)(OA;;RP;b8119fd0-04f6-4762-ab7a-4986c76b3f9a;;AU)(OA;OIIO;RPWPCR;91e647de-d96f-4b70-9557-d63ff4f3ccd8;;PS)(A;;RCWDWORPWPCCLCSWLOCR;;;S-1-5-21-2336184427-3484212696-2663171178-512)(A;OI;RCSDWDWORPWPCCDCLCSWLODTCR;;;S-1-5-21-2336184427-3484212696-2663171178-519)(A;;RCRP;;;RU)(A;OI;LC;;;RU)(A;OI;RCSDWDWORPWPCCLCSWLOCR;;;BA)(A;;RP;;;WD)(A;;RCRPLCLO;;;ED)(A;;RCRPLCLO;;;AU)(A;;RCSDWDWORPWPCCDCLCSWLODTCR;;;SY)S:(OU;OIFA;WP;f30e3bbe-9ff0-11d1-b603-0000f80367c1;bf967aa5-0de6-11d0-a285-00aa003049e2;WD)(OU;OIFA;WP;f30e3bbf-9ff0-11d1-b603-0000f80367c1;bf967aa5-0de6-11d0-a285-00aa003049e2;WD)(AU;FA;CR;;;S-1-5-21-2336184427-3484212696-2663171178-513)(AU;FA;CR;;;BA)(AU;FA;WDWOWP;;;WD)"

RdsNtSecurityDescriptorTester::RdsNtSecurityDescriptorTester(QObject *parent)
		: QObject(parent)
{
}


RdsNtSecurityDescriptorTester::~RdsNtSecurityDescriptorTester()
{
}

void RdsNtSecurityDescriptorTester::init()
{
	///create RdsAce object to use
	ace.setType(RdsAce::Allow);
	ace.setInheritedObject(RdsGuid(INHERIT_OBJ_GUID));
	ace.setObject(RdsGuid(OBJ_GUID));
	ace.setSid(RdsSid("S-1-5-21-3623811015-3361044348-30300820-1019"));
	RdsAce::AccessFlags access = RdsAce::FileAll | RdsAce::KeyAll;
	ace.setAccess(access);
	RdsAce::Flags flags = RdsAce::NoPropogate | RdsAce::Inherited; 
	ace.setFlags(flags);

	///create RdsNtSecurityDescriptor to use
	desc = SEC_DESC;
}

void RdsNtSecurityDescriptorTester::descriptorConstructorTest()
{
	RdsNtSecurityDescriptor desc1(desc), desc2(desc.toString()), desc3(desc.toBinary(0)), desc4(SEC_DESC);
	QCOMPARE(desc1,desc);
	QCOMPARE(desc2,desc);
	QCOMPARE(desc3,desc);
	QCOMPARE(desc4,desc);

	foreach(RdsAce ace, desc.sacl())
		qDebug() << ace.toString();

	///make one of them different
	desc4.setOwner(RdsSid(OWNER_SID));

	QVERIFY(desc == desc1);
	QVERIFY(desc != desc4);
	QVERIFY(desc == desc1.toString());
	QVERIFY(desc != desc4.toString());
	QVERIFY(desc == desc1.toBinary(0));
	QVERIFY(desc != desc4.toBinary(0));
	QVERIFY(desc == SEC_DESC);
	QVERIFY(desc != qPrintable(desc4.toString()));

	desc = desc4;
	QCOMPARE(desc4,desc);

//---------------------------BIG OL' MESS-------------------------------
	QByteArray ary = desc4.toBinary(0).toHex(), ary2 = desc.toBinary(0).toHex();
	qDebug() << ary.size() << ary2.size() << ary.size()*2;

	desc = desc4.toBinary(0);

	ary = desc4.toBinary(0).toHex(); ary2 = desc.toBinary(0).toHex();
//	QByteArray ary = desc4.toBinary(0).toHex(), ary2 = desc.toBinary(0).toHex();
	qDebug() << ary.size() << ary2.size();
	for(int i = 0; i < 1000; ++i)
	{
		if (ary[i] != ary2[i])
			;//qDebug() << "FUCKING SHIT!!! HERE:" << i << ary[i] << ary2[i];
	}
	QCOMPARE(desc4, desc);
//------------------------------------------------------------

	desc = desc4.toString();
	QCOMPARE(desc4,desc);
	desc = qPrintable(desc4.toString());
	QCOMPARE(desc4,desc);

	RdsNtSecurityDescriptor testdesc1(desc), testdesc2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream <<testdesc1;
	}
	{
		QDataStream stream(ar);
		stream >>testdesc2;
	}
	QCOMPARE(testdesc2,testdesc1);
}

void RdsNtSecurityDescriptorTester::descriptorGetSetTest()
{
	RdsNtSecurityDescriptor desc1;
	RdsSid sid(GROUP_SID);

	///group()
	QCOMPARE(desc1.group(), RdsSid());
	desc1.setGroup(sid);
	QCOMPARE(desc1.group().toString(), QString(GROUP_SID));

	///owner()
	QCOMPARE(desc1.owner(), RdsSid());
	desc1.setOwner(RdsSid(OWNER_SID));
	QCOMPARE(desc1.owner().toString(), QString(OWNER_SID));

	///saclFlags()
	QCOMPARE(desc1.saclFlags(), RdsNtSecurityDescriptor::AclFlags());
	RdsNtSecurityDescriptor::AclFlags flags = RdsNtSecurityDescriptor::AutoInherited | RdsNtSecurityDescriptor::Protected;
	desc1.setSaclFlags(flags);
	QCOMPARE(desc1.saclFlags(), RdsNtSecurityDescriptor::AutoInherited | RdsNtSecurityDescriptor::Protected);

	///daclFlags()
	QCOMPARE(desc1.daclFlags(), RdsNtSecurityDescriptor::AclFlags());
	desc1.setDaclFlags(flags);
	QCOMPARE(desc1.daclFlags(), RdsNtSecurityDescriptor::AutoInherited | RdsNtSecurityDescriptor::Protected);

	///sacl()
	QList<RdsAce> list;
	QCOMPARE(desc1.sacl(), list);
	list.append(ace);
	desc1.setSacl(list);
	QCOMPARE(desc1.sacl(), list);

	///dacl()
	list.clear();
	QCOMPARE(desc1.dacl(), list);
	list.append(ace);
	desc1.setDacl(list);
	QCOMPARE(desc1.dacl(), list);
}

void RdsNtSecurityDescriptorTester::aceConstructorTest()
{
	ace = ACE;
	RdsAce ace1(ace), ace2(ace.toString()), ace3(ace.toBinary()), ace4(ACE);
	QCOMPARE(ace, ace1);
	QCOMPARE(ace, ace2);
	QCOMPARE(ace, ace3);
	QCOMPARE(ace, ace4);

	///make one different
	ace4.setType(RdsAce::Allow);
	QVERIFY(ace == ace1);
	QVERIFY(ace != ace4);
	QVERIFY(ace == ace1.toString());
	QVERIFY(ace != ace4.toString());
	QVERIFY(ace == ace1.toBinary());
	QVERIFY(ace != ace4.toBinary());
	QVERIFY(ace == ACE);
	QVERIFY(ace != qPrintable(ace4.toString()));

	ace = ace4;
	QCOMPARE(ace, ace4);
	ace = ace4.toString();
	QCOMPARE(ace, ace4);
	ace = ace4.toBinary();
	QCOMPARE(ace, ace4);
	ace = qPrintable(ace4.toString());
	QCOMPARE(ace, ace4);

	RdsAce testace1(ace), testace2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream <<testace1;
	}
	{
		QDataStream stream(ar);
		stream >>testace2;
	}
	QCOMPARE(testace2,testace1);
}

void RdsNtSecurityDescriptorTester::aceGetSetTest()
{
	RdsAce ace1;

	///type
	QCOMPARE(ace1.type(), RdsAce::Type());
	ace1.setType(RdsAce::Audit);
	QCOMPARE(ace1.type(), RdsAce::Audit);

	///flags
	QCOMPARE(ace1.flags(), RdsAce::Flags());
	ace1.setFlags(RdsAce::Success | RdsAce::Inherited);
	QCOMPARE(ace1.flags(), RdsAce::Success | RdsAce::Inherited);

	///access
	QCOMPARE(ace1.access(), RdsAce::AccessFlags());
	ace1.setAccess(RdsAce::WriteProperty | RdsAce::WriteOwner);
	QCOMPARE(ace1.access(), RdsAce::WriteProperty | RdsAce::WriteOwner);

	///object
	QCOMPARE(ace1.object(), RdsGuid());
	ace1.setObject(RdsGuid(OBJ_GUID));
	QCOMPARE(ace1.object(), RdsGuid(OBJ_GUID));

	///inherited object
	QCOMPARE(ace1.inheritedObject(), RdsGuid());
	ace1.setInheritedObject(RdsGuid(INHERIT_OBJ_GUID));
	QCOMPARE(ace1.inheritedObject(), RdsGuid(INHERIT_OBJ_GUID));

	///sid
	QCOMPARE(ace1.sid().toString(), RdsSid().toString());
	ace1.setSid(RdsSid(OWNER_SID));
	QCOMPARE(ace1.sid(), RdsSid(OWNER_SID));
}

