/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsldapactionstester.h"
#include "../rdsldap/rdsldapactions_p.h"

#include <rdsdefines.h>
REGISTER_TEST(RdsLdapActionsTester);

RdsLdapActionsTester::RdsLdapActionsTester(QObject *parent)
		: QObject(parent)
{
}


RdsLdapActionsTester::~RdsLdapActionsTester()
{
}


void RdsLdapActionsTester::constructorTest()
{
	RdsLdapActions action;
	action.add(RdsLdapActions::Add, QString("name1"), QString("value1"));
	RdsLdapActions action2(action);

	QList<LdapAction> list = action.getActions();
	QList<LdapAction> list2 = action2.getActions();
	QVERIFY(list.size() == list2.size());
	for (int i = 0; i < list.size(); ++i)
	{
		QVERIFY(list[i].type == list2[i].type);
		QVERIFY(list[i].name == list2[i].name);
		QVERIFY(list[i].values == list2[i].values);
	}

	action.add(RdsLdapActions::Add, QString("name2"), QString("value2"));
	RdsLdapActions action3(action.getActions());
	list = action.getActions();
	list2 = action3.getActions();
	QVERIFY(list.size() == list2.size());
	for (int i = 0; i < list.size(); ++i)
	{
		QVERIFY(list[i].type == list2[i].type);
		QVERIFY(list[i].name == list2[i].name);
		QVERIFY(list[i].values == list2[i].values);
	}

	RdsLdapActions action4 = action;
	list2 = action4.getActions();
	QVERIFY(list.size() == list2.size());
	for (int i = 0; i < list.size(); ++i)
	{
		QVERIFY(list[i].type == list2[i].type);
		QVERIFY(list[i].name == list2[i].name);
		QVERIFY(list[i].values == list2[i].values);
	}
}

void RdsLdapActionsTester::addTest()
{
	RdsLdapActions action;
	QList<QString> values;
	for (int i = 0; i < 5; ++i)
		values.append(QString("val%1").arg(i));
	action.add(RdsLdapActions::Add, QString("name1"), QString("value1"));
	action.add(RdsLdapActions::Add, QString("name1"), values);
	action.add(RdsLdapActions::Remove, QString("name2"), QString("value2"));
	action.add(RdsLdapActions::Remove, QString("name2"), values);
	action.add(RdsLdapActions::Replace, QString("name3"), QString("value3"));
	action.add(RdsLdapActions::Replace, QString("name3"), values);
	QList<LdapAction> list = action.getActions();
	QVERIFY(list.size() == 6);

	QVERIFY(list[0].type == RdsLdapActions::Add);
	QVERIFY(list[0].name == QString("name1"));
	QVERIFY(list[0].values[0] == QString("value1"));
	QVERIFY(list[1].type == RdsLdapActions::Add);
	QVERIFY(list[1].name == QString("name1"));
	for (int i = 0; i < list[1].values.size(); ++i)
		QVERIFY(list[1].values[i] == QString("val%1").arg(i));

	QVERIFY(list[2].type == RdsLdapActions::Remove);
	QVERIFY(list[2].name == QString("name2"));
	QVERIFY(list[2].values[0] == QString("value2"));
	QVERIFY(list[3].type == RdsLdapActions::Remove);
	QVERIFY(list[3].name == QString("name2"));
	for (int i = 0; i < list[1].values.size(); ++i)
		QVERIFY(list[3].values[i] == QString("val%1").arg(i));

	QVERIFY(list[4].type == RdsLdapActions::Replace);
	QVERIFY(list[4].name == QString("name3"));
	QVERIFY(list[4].values[0] == QString("value3"));
	QVERIFY(list[5].type == RdsLdapActions::Replace);
	QVERIFY(list[5].name == QString("name3"));
	for (int i = 0; i < list[1].values.size(); ++i)
		QVERIFY(list[5].values[i] == QString("val%1").arg(i));
}

void RdsLdapActionsTester::addDataTest()
{
	RdsLdapActions action;
	QList<QByteArray> balist;
	balist.append(QByteArray("val1"));
	balist.append(QByteArray("val2"));
	balist.append(QByteArray("val3"));

	action.addData(RdsLdapActions::Add, QString("name1"), QByteArray("value1"));
	action.addData(RdsLdapActions::Add, QString("name1"), balist);
	action.addData(RdsLdapActions::Remove, QString("name2"), QByteArray("value2"));
	action.addData(RdsLdapActions::Remove, QString("name2"), balist);
	action.addData(RdsLdapActions::Replace, QString("name3"), QByteArray("value3"));
	action.addData(RdsLdapActions::Replace, QString("name3"), balist);
	QList<LdapAction> list = action.getActions();
	QVERIFY(list.size() == 6);

	QVERIFY(list[0].type == RdsLdapActions::Add);
	QVERIFY(list[0].name == QString("name1"));
	QVERIFY(list[0].values[0] == QByteArray("value1"));
	QVERIFY(list[1].type == RdsLdapActions::Add);
	QVERIFY(list[1].name == QString("name1"));
	for (int i = 0; i < list[1].values.size(); ++i)
		QVERIFY(list[1].values[i] == QString("val%1").arg(i + 1));

	QVERIFY(list[2].type == RdsLdapActions::Remove);
	QVERIFY(list[2].name == QString("name2"));
	QVERIFY(list[2].values[0] == QByteArray("value2"));
	QVERIFY(list[3].type == RdsLdapActions::Remove);
	QVERIFY(list[3].name == QString("name2"));
	for (int i = 0; i < list[1].values.size(); ++i)
		QVERIFY(list[3].values[i] == QString("val%1").arg(i + 1));

	QVERIFY(list[4].type == RdsLdapActions::Replace);
	QVERIFY(list[4].name == QString("name3"));
	QVERIFY(list[4].values[0] == QByteArray("value3"));
	QVERIFY(list[5].type == RdsLdapActions::Replace);
	QVERIFY(list[5].name == QString("name3"));
	for (int i = 0; i < list[1].values.size(); ++i)
		QVERIFY(list[5].values[i] == QString("val%1").arg(i + 1));
}

void RdsLdapActionsTester::addUnicodeTest()
{
	RdsLdapActions action;
	QStringList slist;
	slist << QString("val1") << QString("val2") << QString("val3");

	action.addUnicode(RdsLdapActions::Add, QString("name1"), QString("value1"));
	action.addUnicode(RdsLdapActions::Remove, QString("name2"), QString("value2"));
	action.addUnicode(RdsLdapActions::Replace, QString("name3"), QString("value3"));
	action.addUnicode(RdsLdapActions::Add, QString("name1"), slist);
	action.addUnicode(RdsLdapActions::Remove, QString("name2"), slist);
	action.addUnicode(RdsLdapActions::Replace, QString("name3"), slist);

	QList<LdapAction> list = action.getActions();
	QVERIFY(list.size() == 6);

	QVERIFY(list[0].type == RdsLdapActions::Add);
	QVERIFY(list[0].name == QString("name1"));
	QVERIFY(list[0].values.size() == 1);
	QVERIFY(QString::fromUtf16((ushort*)list[0].values[0].data(), list[0].values[0].size() / 2) == QString("value1"));

	QVERIFY(list[1].type == RdsLdapActions::Remove);
	QVERIFY(list[1].name == QString("name2"));
	QVERIFY(list[1].values.size() == 1);

	QVERIFY(QString::fromUtf16((ushort*)list[1].values[0].data(), list[1].values[0].size() / 2) == QString("value2"));

	QVERIFY(list[2].type == RdsLdapActions::Replace);
	QVERIFY(list[2].name == QString("name3"));
	QVERIFY(list[2].values.size() == 1);
	QVERIFY(QString::fromUtf16((ushort*)list[2].values[0].data(), list[2].values[0].size() / 2) == QString("value3"));

	QVERIFY(list[3].type == RdsLdapActions::Add);
	QVERIFY(list[3].name == QString("name1"));
	QVERIFY(list[3].values.size() == 3);
	for (int i = 0; i < list[3].values.size(); ++i)
		QVERIFY(QString::fromUtf16((ushort*)list[3].values[i].data(), list[3].values[i].size() / 2) == QString("val%1").arg(i + 1));

	QVERIFY(list[4].type == RdsLdapActions::Remove);
	QVERIFY(list[4].name == QString("name2"));
	QVERIFY(list[4].values.size() == 3);
	for (int i = 0; i < list[4].values.size(); ++i)
		QVERIFY(QString::fromUtf16((ushort*)list[4].values[i].data(), list[4].values[i].size() / 2) == QString("val%1").arg(i + 1));

	QVERIFY(list[5].type == RdsLdapActions::Replace);
	QVERIFY(list[5].name == QString("name3"));
	QVERIFY(list[5].values.size() == 3);
	for (int i = 0; i < list[5].values.size(); ++i)
		QVERIFY(QString::fromUtf16((ushort*)list[5].values[i].data(), list[5].values[i].size() / 2) == QString("val%1").arg(i + 1));
}

void RdsLdapActionsTester::clearGetTest()
{
	RdsLdapActions action;
	QList<LdapAction> list = action.getActions();
	QVERIFY(list.size() == 0);
	action.add(RdsLdapActions::Add, QString("name1"), QString("value1"));
	action.add(RdsLdapActions::Add, QString("name2"), QString("value2"));
#ifndef __RDS_CLIENT
	QVERIFY(action.getLdapActions() != NULL);
#endif
	list = action.getActions();
	QVERIFY(list.size() == 2);
	action.clear();
	list = action.getActions();
	QVERIFY(list.size() == 0);
}

void RdsLdapActionsTester::streamTest()
{
	RdsLdapActions action, action2;
	action.add(RdsLdapActions::Add, QString("name1"), QString("value1"));
	action.add(RdsLdapActions::Add, QString("name2"), QString("value2"));
	action.add(RdsLdapActions::Remove, QString("name1"), QString("value1"));
	action.add(RdsLdapActions::Replace, QString("name2"), QString("value2"));
	action.add(RdsLdapActions::Add, QString("name1"), QString("value1"));
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << action;
	}
	{
		QDataStream stream(ar);
		stream >> action2;
	}

	QList<LdapAction> list = action.getActions();
	QList<LdapAction> list2 = action2.getActions();
	QVERIFY(list.size() == list2.size());
	for (int i = 0; i < list.size(); ++i)
	{
		QVERIFY(list[i].type == list2[i].type);
		QVERIFY(list[i].name == list2[i].name);
		QVERIFY(list[i].values == list2[i].values);
	}
}
