/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsguidtester.h"

REGISTER_TEST(RdsGuidTester);

RdsGuidTester::RdsGuidTester(QObject *parent)
		: QObject(parent)
{
}


RdsGuidTester::~RdsGuidTester()
{
}

void RdsGuidTester::constructorTest()
{
	RdsGuid guid("3F2504E0-4F89-11D3-9A0C-0305E82C3301"), guid2, guid3("3F2504E0-4F89-11D3-9A0C-0305E82C3302");

	guid2 = guid;
	QCOMPARE(guid2, guid);
	guid2 = guid.toString();
	QCOMPARE(guid2, guid);
	guid2 = guid.toBinary();
	QCOMPARE(guid2, guid);
	guid2 = "3F2504E0-4F89-11D3-9A0C-0305E82C3301";
	QCOMPARE(guid2, guid);

	QVERIFY(!guid.isNull());
	QVERIFY(!guid2.isNull());
	QVERIFY(!guid3.isNull());

	QVERIFY(guid == guid2);
	QVERIFY(guid != guid3);
	QVERIFY(guid == guid2.toString());
	QVERIFY(guid != guid3.toString());
	QVERIFY(guid == guid2.toBinary());
	QVERIFY(guid != guid3.toBinary());
	QVERIFY(guid == "3F2504E0-4F89-11D3-9A0C-0305E82C3301");
	QVERIFY(guid != "3F2504E0-4F89-11D3-9A0C-0305E82C3302");

	RdsGuid testguid1(guid), testguid2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream <<testguid1;
	}
	{
		QDataStream stream(ar);
		stream >>testguid2;
	}
	QCOMPARE(testguid2,testguid1);
}

void RdsGuidTester::getSetTest()
{
	RdsGuid guid;
	QVERIFY(guid.isNull());

	QCOMPARE(guid.timeLow(), quint32(0));
	TEST_FUNCTION(guid.setTimeLow(0x29993344));
	QCOMPARE(guid.timeLow(), quint32(0x29993344));

	QCOMPARE(guid.timeMiddle(), quint16(0));
	TEST_FUNCTION(guid.setTimeMiddle(0x1234));
	QCOMPARE(guid.timeMiddle(), quint16(0x1234));

	QCOMPARE(guid.timeHiAndVersion(), quint16(0));
	TEST_FUNCTION(guid.setTimeHiAndVersion(0x9876));
	QCOMPARE(guid.timeHiAndVersion(), quint16(0x9876));

	QCOMPARE(guid.clockSequence(), quint16(0));
	TEST_FUNCTION(guid.setClockSequence(0x5555));
	QCOMPARE(guid.clockSequence(), quint16(0x5555));

	QCOMPARE(guid.node(), quint64(0));
	TEST_FUNCTION(guid.setNode(0x321321321321));
	QCOMPARE(guid.node(), quint64(0x321321321321));

	QVERIFY(!guid.isNull());

	QCOMPARE(guid, RdsGuid("29993344-1234-9876-5555-321321321321"));
}
