/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsentitytester.h"

REGISTER_TEST(RdsEntityTester);

RdsEntityTester::RdsEntityTester(QObject *parent)
		: QObject(parent)
{
}


RdsEntityTester::~RdsEntityTester()
{
}

void RdsEntityTester::constructorTest()
{
	RdsEntity entity;
	RdsEntity entity2(entity), entity3;
	entity3 = entity;

	RdsEntity ent1, ent2;
	ent1.setName("a name");
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << ent1;
	}
	{
		QDataStream stream(ar);
		stream >> ent2;
	}
	QCOMPARE(ent2.name(), ent1.name());

}

void RdsEntityTester::getSetTest()
{
	RdsEntity ent;

	ent.setName("Blackwater Park");
	QCOMPARE(ent.name(), QString("Blackwater Park"));
	QString str = ent.name();

	ent.setId("Bleak");
	QCOMPARE(ent.id(), QString("Bleak"));
	str = ent.id();

	ent.setType("Song");
	QCOMPARE(ent.type(), QString("Song"));
	str = ent.type();

	ent.setVisible(false);
	QVERIFY(!ent.visible());
	bool flag = ent.visible();

	ent.setParent("Opeth");
	QCOMPARE(ent.parent(), QString("Opeth"));
	str = ent.parent();

	ent.setGroup(true);
	QVERIFY(ent.isGroup());
	flag = ent.isGroup();

	ent.setHasMore(true);
	QVERIFY(ent.hasMore());
	flag = ent.hasMore();

}

void RdsEntityTester::metaDataTest()
{
	RdsEntity ent;
	QVariantMap map, entitymap;
	map["dtp"] = "ki";
	map["albums"] = 2;
	map["disbanded"] = false;

	ent.metadata() = map;

	entitymap = ent.metadata();
	QCOMPARE(entitymap, map);
}

void RdsEntityTester::childrenTest()
{
	RdsEntity ent, ent1, ent2, ent3;
	QList<RdsEntity> list, entitylist;

	ent1.setName("ent1");
	ent2.setName("ent2");
	ent3.setName("ent3");
	list.append(ent1);
	list.append(ent2);
	list.append(ent3);

	ent.children() = list;
	entitylist = ent.children();
	QCOMPARE(entitylist.size(), list.size());

	for(int i = 0; i < list.size(); ++i)
	{
		QCOMPARE(entitylist[i].name(), list[i].name());
	}
}


