/***************************************************************************
 *   Copyright (C) 2009 by Chris Vickery   *
 *   chris@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <QtTest>
#include <QDebug>
#include "rdstest.h"
#include <RdsLdapSession>
#include <RdsUtils>

int main(int argc, char** argv)
{
	QCoreApplication app(argc, argv);

	RdsLdapSession session;
	ReturnValue ret = RdsUtils::adminBind(session);

	if (ret.isError())
	{
		qCritical() << "Failed to connect to LDAP server:" << ret.errString();
		return(1);
	}

	RdsLdapSession::setGlobalSession(&session);

	RdsTest::runTests();
	return(0);
}



