/***************************************************************************
 *   Copyright (C) 2009 by Brendan Powers   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdsjobtester.h"
#include <QDebug>

RdsJobTester::RdsJobTester(RdsJob* job)
{
	connect(job, SIGNAL(progressChanged(int , const QString& , const QString&)), this, SLOT(progressChanged(int , const QString& , const QString&)));
	connect(job, SIGNAL(statusChanged(RdsJob::Status)), this, SLOT(statusChanged(RdsJob::Status)));
	connect(job, SIGNAL(newLogMsg(const QString&)), this, SLOT(newLogMsg(const QString&)));
	connect(job, SIGNAL(finished(const ReturnValue&)), this, SLOT(finished(const ReturnValue&)));
}

RdsJobTester::~RdsJobTester()
{
}

void RdsJobTester::progressChanged(int percent, const QString& progressText, const QString& progressDetails)
{
	qDebug() << "progressChanged(percent" << percent << ", progressText" << progressText << ", progressDetails" << progressDetails << ")";
}

void RdsJobTester::statusChanged(RdsJob::Status status)
{
	qDebug() << "statusChanged(status" << status << ")";
}

void RdsJobTester::newLogMsg(const QString& line)
{
	qDebug() << "newLogMsg(line" << line << ")";
}

void RdsJobTester::finished(const ReturnValue& ret)
{
	qDebug() << "finished(ret" << ret << ")";
}




