/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSID_P_H
#define RDSSID_P_H

#include <QxtPimpl>
#include <QSharedDataPointer>
#include <ReturnValue>
#include "rdssid.h"


/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsSidData : public QSharedData
{
public:
	RdsSidData()
	:	version(0),authority(0),domain(),rid(0)
	{
	}
	uchar version;
	unsigned long long authority;
	QList<uint> domain;
	uint rid;
};

class RdsSidPrivate : public QxtPrivate<RdsSid>
{
public:
	RdsSidPrivate()
	{
	}
	QSharedDataPointer<RdsSidData> data;
	void parseString(QString str);
	static RdsSid domainsid;
};

#endif
