/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSPROTOCOLVERSION_H_
#define RDSPROTOCOLVERSION_H_

#include "config.h"
#include <QStringList>

enum RdsProtocol
{
	Global, // Global version number, rarely changes
	Users //Users and groups classes
	///@todo: Fill these in
};

inline QStringList rdsProtocolVersions()
{
	static QStringList versions = QStringList()
	                              << "2.0" // Global
	                              << "2.0" // Users
	                              ;
	return versions;
}

inline QString rdsProtocolVersion(RdsProtocol protocol)
{
	QStringList versions = rdsProtocolVersions();
	if (protocol < versions.count())
		return versions.at(protocol);
	return "0.0";
}

#endif //#ifndef RDSPROTOCOLVERSION_H_

